﻿USE [DRGNationalDB]
GO

BEGIN TRY
	SET QUOTED_IDENTIFIER ON
    BEGIN TRANSACTION
	set nocount on

	--modificari Lista Sectii
	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id and t.name = 'ListaSectii' and c.name = 'DataExpirare')
	begin
		update ListaSectii set DataExpirare = '2017-04-01'  where CodSectie in ('1272.1','1272.2','1333')

		if not exists (select * from [dbo].[ListaSectii] where CodSectie = '1423.3')
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare]) 
		VALUES ('1423.3','Exceptie anexa 25: sectia de recuperare medicala neuropsihomotorie copii din cadrul spitalului CT11',0,'14233',NULL)

		if not exists (select * from [dbo].[ListaSectii] where CodSectie = '1423.4')
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare]) 
		VALUES ('1423.4','Exceptie anexa 25: compartimentul recuperare neuro-psiho-motorie din cadrul spitalului BH18',0,'14234',NULL)

		update [dbo].[ListaSectii] set DenSectie = 'Exceptie anexa 23C sectia de recuperare medicala neurologie din cadrul spitalului B_80'
		where CodSectie = '1393.4'
		print '1.15 - Update lista sectii - OK'
	end

	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id 
	and t.name = 'ListaCazRezolvatInterventiiChirurgicale' and c.name = 'DenCazRezolvatInterventieComplet')
	begin
		update ListaCazRezolvatInterventiiChirurgicale
		set DenCazRezolvatInterventieComplet = DenCazRezolvatInterventiiChirurgicale 
						+ case when DataValabilitate is not null then ' - ' + convert(varchar(20), ISNULL(DataValabilitate,''),103)
						  else '' end
	end

	if not exists(select * from ListaSectii where CodSectie='1393.4')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1393.4','Exceptie anexa 23C sectia clinica(IV) de recuperare medicala neurologie din cadrul spitalului B_70',0,'13934',NULL)
	end

	--vers 1.19
	if not exists(select * from ListaSectii where CodSectie='1493')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1493','Genetica medicala (acuti si cronici)',1,'1493',NULL)
	end

	print 'Update lista sectii - OK'

	--vers 1.20
	if not exists(select * from ListaAccidente where IdAccident='6')
	begin
		INSERT INTO [dbo].[ListaAccidente] ([IdAccident],[DenAccident])
		VALUES (6,'Infectie confirmata cu COVID-19')
	end

	if not exists(select * from ListaAccidente where IdAccident='7')
	begin
		INSERT INTO [dbo].[ListaAccidente] ([IdAccident],[DenAccident])
		VALUES (7,'Suspiciune/testare pentru infectie cu COVID-19, neconfirmata')
	end

	print 'Update lista accidente - OK'

	--vers 1.21
	if not exists(select * from ListaDiagnosticeClase where IdClasaDiagnostic=22)
	begin
		INSERT INTO [dbo].[ListaDiagnosticeClase] ([IdClasaDiagnostic],[DenClasaDiagnostic])
		VALUES (22,'Coduri pentru scopuri speciale')
	end
	print 'v1.21 - Update ListaDiagnosticeClase - OK'

	if not exists(select * from ListaDiagnosticeSubClase where IdSubClasaDiagnostic=274)
	begin
		INSERT INTO [dbo].[ListaDiagnosticeSubClase] ([IdSubClasaDiagnostic],[IdClasaDiagnostic],[DenSubClasaDiagnostic])
		VALUES (274,22,'Afectiuni noi, de etiologie incerta, alocate temporar sau in situatii de urgenta U00-U49')
	end
	print 'v1.21 - Update ListaDiagnosticeSubClase - OK'

	if not exists(select * from ListaDiagnostice where IdDiagnostic=15928)
	begin
		INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])
		VALUES(15928,'U07.1',274,'COVID-19, virus identificat',1,0,0,0,0,0,'U07.1 - COVID-19, virus identificat')
	end

	if not exists(select * from ListaDiagnostice where IdDiagnostic=15929)
	begin
		INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])
		VALUES(15929,'U07.2',274,'COVID-19, virus neidentificat',1,0,0,0,0,0,'U07.2 - COVID-19, virus neidentificat')
	end
	print 'v1.21 - Update ListaDiagnostice - OK'

	if not exists(select * from ListaDiagnosticeSubClase where IdSubClasaDiagnostic=275)
	begin
		INSERT INTO [dbo].[ListaDiagnosticeSubClase] ([IdSubClasaDiagnostic],[IdClasaDiagnostic],[DenSubClasaDiagnostic])
		VALUES (275,22,'Rezistenta la medicamente antimicrobiene si antineoplazice (U82-U85)')
	end
	print 'v1.22 - Update ListaDiagnosticeSubClase - OK'

	if not exists(select * from ListaDiagnostice where IdDiagnostic=15930) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15930,'U04.9',274,'Sindromul sever respirator acut [SARS], nespecificat',0,0,0,0,1,0,'U04.9 - Sindromul sever respirator acut [SARS], nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15931) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15931,'U07.0',274,'Tulburari asociate inhalarii de vapori din dispozitive electronice',0,0,0,0,1,0,'U07.0 - Tulburari asociate inhalarii de vapori din dispozitive electronice')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15932) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15932,'U08.9',274,'Istoric personal de COVID-19, nespecificat',0,0,0,0,1,0,'U08.9 - Istoric personal de COVID-19, nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15933) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15933,'U09.9',274,'Conditie (status) post-COVID-19, nespecificata',0,0,0,0,1,0,'U09.9 - Conditie (status) post-COVID-19, nespecificata')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15934) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15934,'U10.9',274,'Sindrom inflamator multisistemic asociat cu COVID-19, nespecificat',0,0,0,0,1,0,'U10.9 - Sindrom inflamator multisistemic asociat cu COVID-19, nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15935) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15935,'U11.9',274,'Necesitatea imunizarii impotriva COVID-19, nespecificata',0,0,0,0,1,0,'U11.9 - Necesitatea imunizarii impotriva COVID-19, nespecificata')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15936) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15936,'U12.9',274,'Vaccinuri anti-COVID-19 producand efecte adverse in utilizare terapeutica, nespecificate',0,0,0,0,1,0,'U12.9 - Vaccinuri anti-COVID-19 producand efecte adverse in utilizare terapeutica, nespecificate')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15937) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15937,'U82.0',275,'Rezistenta la penicilina',0,0,0,0,1,0,'U82.0 - Rezistenta la penicilina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15938) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15938,'U82.1',275,'Rezistenta la meticilina',0,0,0,0,1,0,'U82.1 - Rezistenta la meticilina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15939) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15939,'U82.2',275,'Rezistenta de tip beta-lactamaze cu spectru extins',0,0,0,0,1,0,'U82.2 - Rezistenta de tip beta-lactamaze cu spectru extins')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15940) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15940,'U82.8',275,'Rezistenta la alte beta-lactamine',0,0,0,0,1,0,'U82.8 - Rezistenta la alte beta-lactamine')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15941) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15941,'U82.9',275,'Rezistenta la beta-lactamine, nespecificate',0,0,0,0,1,0,'U82.9 - Rezistenta la beta-lactamine, nespecificate')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15942) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15942,'U83.0',275,'Rezistenta la vancomicina',0,0,0,0,1,0,'U83.0 - Rezistenta la vancomicina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15943) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15943,'U83.1',275,'Rezistenta la alte antibiotice inrudite cu vancomicina',0,0,0,0,1,0,'U83.1 - Rezistenta la alte antibiotice inrudite cu vancomicina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15944) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15944,'U83.2',275,'Rezistenta la chinolone',0,0,0,0,1,0,'U83.2 - Rezistenta la chinolone')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15945) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15945,'U83.7',275,'Rezistenta la antibiotice multiple',0,0,0,0,1,0,'U83.7 - Rezistenta la antibiotice multiple')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15946) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15946,'U83.8',275,'Rezistenta la alt antibiotic unic, specificat',0,0,0,0,1,0,'U83.8 - Rezistenta la alt antibiotic unic, specificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15947) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15947,'U83.9',275,'Rezistenta la antibiotic nespecificat',0,0,0,0,1,0,'U83.9 - Rezistenta la antibiotic nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15948) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15948,'U84.0',275,'Rezistenta la medicament(e) antiparazitare',0,0,0,0,1,0,'U84.0 - Rezistenta la medicament(e) antiparazitare')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15949) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15949,'U84.1',275,'Rezistenta la medicament(e) antifungice',0,0,0,0,1,0,'U84.1 - Rezistenta la medicament(e) antifungice')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15950) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15950,'U84.2',275,'Rezistenta la medicament(e) antivirale',0,0,0,0,1,0,'U84.2 - Rezistenta la medicament(e) antivirale')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15951) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15951,'U84.3',275,'Rezistenta la medicament(e) tuberculostatice',0,0,0,0,1,0,'U84.3 - Rezistenta la medicament(e) tuberculostatice')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15952) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15952,'U84.7',275,'Rezistenta la multiple medicamente antimicrobiene',0,0,0,0,1,0,'U84.7 - Rezistenta la multiple medicamente antimicrobiene')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15953) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15953,'U84.8 ',275,'Rezistenta la alt medicament antimicrobian specificat',0,0,0,0,1,0,'U84.8  - Rezistenta la alt medicament antimicrobian specificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15954) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15954,'U84.9',275,'Rezistenta la medicamente antimicrobiene nespecificate',0,0,0,0,1,0,'U84.9 - Rezistenta la medicamente antimicrobiene nespecificate')

	print 'v1.22 - Update ListaDiagnostice - OK'
	
	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=156))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (156
        ,'Evaluarea sindromului Post Covid-19'
        ,NULL
        ,0
        ,0
        ,'B.3.2'
        ,'SPT_191'
        ,'156 -- Evaluarea sindromului Post Covid-19 -- NA -- B.3.2')

	print 'v1.22 - Update lista [ListaTipServicii] - OK'

	update ListaSectii set densectie='Ingrijiri paleative' where codsectie='1061_PAL'--Ingrijiri paliative
	update ListaSectii set densectie='Exceptie anexa 25: Geriatrie si gerontologie' where codsectie='1121.1'--Exceptie anexa 25 Geriatrie si gerontologie
	update ListaSectii set densectie='Hematologie' where codsectie='1131'--Hematologie clinica
	update ListaSectii set densectie='Neonatologie (prematuri) aferente unei maternitati de grd II' where codsectie='1222.1'--Neonatologie (prematuri)_MaternitateGrII
	update ListaSectii set densectie='Neonatologie (prematuri) aferente unei maternitati de gradul III' where codsectie='1222.2'--Neonatologie (prematuri)_MaternitateGrIII
	update ListaSectii set densectie='Neurologie' where codsectie='1231'--Neurologie
	update ListaSectii set densectie='Pediatrie (Recuperare pediatrica)' where codsectie='1272'--Pediatrie ( recuperare pediatrica)
	update ListaSectii set densectie='Psihatrie pediatrica' where codsectie='1312'--Psihiatrie pediatrica
	update ListaSectii set densectie='Psihiatrie(Nevroze)' where codsectie='1321'--Psihiatrie (Nevroze)
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare, medicina fizica si balneologie copii' where codsectie='1372.1'--Exceptie anexa 25 Recuperare, medicina fizica si balneologie copii
	update ListaSectii set densectie='Recuperare medicala cardiovasculara' where codsectie='1383'--Recuperare medicala - cardiovasculara
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare medicala cardiovasculara' where codsectie='1383.1'--Exceptie anexa 25 Recuperare medicala cardiovasculara
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare medicala neurologie' where codsectie='1393.1'--Exceptie anexa 25 Recuperare medicala neurologie
	update ListaSectii set densectie='Exceptie anexa 23C: Recuperare medicala neurologie' where codsectie='1393.2'--Exceptie anexa 23C Recuperare medicala neurologie
	update ListaSectii set densectie='Exceptie anexele 23C si 25: Recuperare medicala neurologie' where codsectie='1393.3'--Exceptie anexele 23C si 25 Recuperare medicala neurologie
	update ListaSectii set densectie='Recuperare medicala neurologie' where codsectie='1393.4'--Exceptie anexa 23C sectia de recuperare medicala neurologie din cadrul spitalului B_80
	update ListaSectii set densectie='Recuperare medicala ortopedie si traumatologie' where codsectie='1403'--Recuperare medicala - ortopedie  si traumatologie
	update ListaSectii set densectie='Recuperare medicala respiratorie' where codsectie='1413'--Recuperare medicala - respiratorie
	update ListaSectii set densectie='Recuperare neuro-psihomotorie' where codsectie='1423'--Recuperare neuro-psiho-motorie
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare neuro-psihomotorie' where codsectie='1423.1'--Exceptie anexa 25 Recuperare neuro-psihomotorie
	update ListaSectii set densectie='Exceptie anexa 23C: Recuperare neuro-psihomotorie' where codsectie='1423.2'--Exceptie anexa 23C Recuperare neuro-psihomotorie
	update ListaSectii set densectie='Exceptie anexa 25: sectia de recuperare medicala neuropsihomotorie copii din cadrul spitalului CT11' where codsectie='1423.3'--Exceptie anexa 25 sectia de recuperare medicala neuropsihomotorie copii din CT11
	update ListaSectii set densectie='Exceptie anexa 25: compartimentul recuperare neuro-psiho-motorie din cadrul spitalului BH18' where codsectie='1423.4'--Exceptie anexa 25 compartimentul recuperare neuro-psiho-motorie din BH18
	update ListaSectii set densectie='Terapie intensiva coronarieni - UTIC' where codsectie='1453'--Terapie intensiva coronarieni -UTIC
	update ListaSectii set densectie='Sectii sanatoriale altele decat balneare' where codsectie='1473'--Sectii sanatoriale
	update ListaSectii set densectie='Otorinolaringologie (ORL)- implant cohlear' where codsectie='2233'--Otorinolaringologie (ORL) - implant cohlear
	update ListaSectii set densectie='Sterilitate-infertilitate' where codsectie='2241'--Sterilitate- infertilitate
	update ListaSectii set densectie='Sterilitate -infertilitate (Fertilizare in vitro)' where codsectie='2251'--Sterilitate- infertilitate (Fertilizare in vitro)
	update ListaSectii set densectie='Urgenta-CPU' where codsectie='3023'--Urgenta - CPU
	update ListaSectii set densectie='Urgenta-UPU' where codsectie='3033'--Urgenta - UPU
	update ListaSectii set densectie='Urgenta-MU' where codsectie='3043'--Urgenta - MU
	update ListaSectii set densectie='Bloc operator**' where codsectie='4023'--Bloc Operator
	update ListaSectii set densectie='Laborator de prevenire si control infectii nosocomia' where codsectie='4143'--Laborator de prevenire si control infectii nosocomiale
	update ListaSectii set densectie='Cabinete de ambulator de specialitate' where codsectie='8013'--Cabinete de specialitate ambulator

	print 'v1.22 - Update lista [ListaSectii] - OK'

	print 'v1.23 - Start'

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=157))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (157,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii',NULL,0,0,'B.4.x','SPT_192','157 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=158))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (158,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii–cu investigatie CT',NULL,0,0,'B.4.x','SPT_193','158 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii–cu investigatie CT -- NA -- B.4.x')
 
	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=159))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (159,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii–cu investigatie RX',NULL,0,0,'B.4.x','SPT_194','159 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii–cu investigatie RX -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=160))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (160,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului–cu investigatie CT',NULL,0,0,'B.4.x','SPT_195','160 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului–cu investigatie CT -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=161))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (161,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului–cu investigatie RX',NULL,0,0,'B.4.x','SPT_196','161 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului–cu investigatie RX -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=162))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (162,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului',NULL,0,0,'B.4.x','SPT_197','162 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=163))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (163,'Infectie cu SARS-CoV-2 confirmata–fara tratament',NULL,0,0,'B.4.x','SPT_198','163 -- Infectie cu SARS-CoV-2 confirmata–fara tratament -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=164))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (164,'Infectie cu SARS-CoV-2 confirmata–cu RX– fara tratament',NULL,0,0,'B.4.x','SPT_199','164 -- Infectie cu SARS-CoV-2 confirmata–cu RX– fara tratament -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=165))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (165,'Infectie cu SARS-CoV-2 confirmata–cu investigatie CT–fara tratament',NULL,0,0,'B.4.x','SPT_200','165 -- Infectie cu SARS-CoV-2 confirmata–cu investigatie CT–fara tratament -- NA -- B.4.x')

	print 'v1.23 - Update lista [ListaTipServicii] - OK'
	
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=115)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (115,'Pulsoximetrie',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=116)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (116,'Administrare de medicamente injectabil/ perfuzii/ alte tipuri de administrari de medicamente',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=117)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (117,'Medicamente cu actiune antivirala administrate parenteral/oral: anticorpi monoclonali neutralizanti/molnupiravir/paxlovid sau alte medicamente achizitionate de Ministerul Sanatatii si distribuite gratuit la nivelul centrului de evaluare',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=118)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (118,'Computer tomografie torace',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=119)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (119,'Examen radiologic torace ansamblu',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=120)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (120,'Medicamente cu actiune antivirala, cu administrare orala achizitionate la nivelul unitatii sanitare:  Favipiravir administrat in centrul de evaluare si eliberat pacientului pentru tratament la domiciliu',NULL)

	print '1.23 - update ListaTipServiciiCerinte - OK'

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=157) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (157,'103,41,53,54,38,19,89,109,105,115,116,117','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=158) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (158,'103,41,53,54,38,19,89,109,118,105,115,116,117','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=159) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (159,'103,41,53,54,38,19,89,109,119,105,115,116,117','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=160) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (160,'103,41,53,54,38,19,89,109,45,48,118,105,115,116,120','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=161) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (161,'103,41,53,54,38,19,89,109,45,48,119,105,115,116,120','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=162) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (162,'103,41,53,54,38,19,89,109,45,48,105,115,116,120','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=163) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (163,'103,41,53,54,38,19,89,109,105,115','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=164) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (164,'103,41,53,54,38,19,89,109,119,105,115','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=165) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (165,'103,41,53,54,38,19,89,109,118,105,115','B4.x')

	print '1.23 - update ListaTipServiciuXCerinta - OK'

	if not exists(select * from ListaSectii where CodSectie='1483.2')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1483.2','Centru de evaluare',0,'14832',NULL)
	end
	print '1.23 - update ListaSectii - OK'

	print 'v1.23 - Stop'

	print 'v1.25 - Start'

	if not exists(select * from [dbo].[ListaTipAsigurareCNAS] where IdTipAsigurareCNAS=6)
	begin
		INSERT INTO [dbo].[ListaTipAsigurareCNAS] ([IdTipAsigurareCNAS],[DenTipAsigurareCNAS],[DataValabilitate]) 
		VALUES (6,'Beneficiari OUG 15',NULL)
	end
	print 'v1.25 - update ListaTipAsigurareCNAS - OK'
	print 'v1.25 - Stop'

	---------------------------------------- 	print 'v1.26 - Start'     ----------------------------------------

	print 'v1.26 - Start'

	print 'v1.26 - Update lista [ListaTipServicii] - OK'
	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=166))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (166
        ,'Infectii acute ale cailor respiratorii la copii - fara tratament'
        ,NULL
        ,0
        ,0
        ,'B.4.x'
        ,'SPT_201'
        ,'166 -- Infectii acute ale cailor respiratorii la copii - fara tratament -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=167))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (167
        ,'Infectii acute ale cailor respiratorii la copii cu RX - fara tratament'
        ,NULL
        ,0
        ,0
        ,'B.4.x'
        ,'SPT_202'
        ,'167 -- Infectii acute ale cailor respiratorii la copii cu RX - fara tratament -- NA -- B.4.x')

	print 'v1.26 - update ListaTipServicii - OK'

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=166) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (166,'103,41,53,54,38,19,89,109,105,115','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=167) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (167,'103,41,53,54,38,19,89,109,119,105,115','B4.x')

	print 'v1.26 - update ListaTipServiciuXCerinta - OK'
	---------------------------------------- 	print 'v1.26 - Stop'     ----------------------------------------

	---------------------------------------- 	print 'v1.27 - Start'     ----------------------------------------

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=168))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (168
        ,'Inductia tratamentului cu Esketaminum (1) – maxim 7 vizite/luna/asigurat'
        ,NULL
        ,1
        ,0
        ,'B.3.1'
        ,'SPT_203'
        ,'168 -- Inductia tratamentului cu Esketaminum (1) – maxim 7 vizite/luna/asigurat -- NA -- B.3.1')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=169))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (169
        ,'Intretinerea tratamentului cu Esketaminum (1) – maxim 4 vizite/luna/asigurat'
        ,NULL
        ,1
        ,0
        ,'B.3.1'
        ,'SPT_204'
        ,'169 -- Intretinerea tratamentului cu Esketaminum (1) – maxim 4 vizite/luna/asigurat -- NA -- B.3.1')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=170))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (170
        ,'Initiere protocol de administrare a Esketaminum (1)'
        ,NULL
        ,0
        ,0
        ,'B.3.2'
        ,'SPT_205'
        ,'170 -- Initiere protocol de administrare a Esketaminum (1) -- NA -- B.3.2')


	print 'v1.27 - Update lista [ListaTipServicii] - OK'

---------------------------------------- 	print 'v1.27 - Stop'     ----------------------------------------

---------------------------------------- 	print 'v1.28 - Start'     ----------------------------------------

-------------------------------------------INSERT SERVICII NOI-----------------------------------------------------------
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=171))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (171, 'Depistarea precoce a cancerului de san cu suspiciune identificata mamografic*5b)',NULL,0, 0, 'B.4.2', 'SPT_301')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=172))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (172, 'Depistarea precoce a cancerului de san cu suspiciune de leziuni infraclinice ale sanului identificate mamografic si ecografic *6a)',NULL,0, 0, 'B.4.2', 'SPT_302')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=173))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (173, 'Depistarea precoce a cancerului de san cu suspiciune de leziuni infraclinice (microcalcificari) ale sanului identificate mamografic si / sau ecografic *6b)',NULL,0, 0, 'B.4.2', 'SPT_303')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=174))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (174, 'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare - tip IV(Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_247')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=175))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (175, 'Depistarea si controlul insuficientei cardiace la populatia la risc (incluzand examinare RMN cord si determinarea NT-proBNP) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_248')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=176))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (176, 'Monitorizarea prin RMN cardiac a pacientului cu infarct miocardic acut in antecedente (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_249')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=177))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (177, 'Monitorizarea prin Angio CT cardiac a pacientului cu stent sau bypass coronarian (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_250')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=178))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (178, 'Monitorizarea prin Angio CT periferic a pacientului cu stent periferic, bypass periferic sau in urma unei proceduri de angioplastie periferica (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_251')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=179))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (179, 'Managementul sindroamelor coronariene cronice (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_252')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=180))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (180, 'Evaluarea cardiomiopatiilor si a patologiei cardiace complexe (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_253')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=181))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (181, 'Evaluarea si monitorizarea ischemiei miocardice in sindromul coronarian cronic (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_254')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=182))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (182, 'Evaluarea riscului cardiovascular la pacientii cu istoric familial, prin depistarea mutatiilor genetice asociate cu risc crescut de boli cardiovasculare rare cu transmitere genetica (o data in viata)',NULL,0, 0, 'B.4.1', 'SPT_255')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=183))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (183, 'Boli alergice cu suspiciune de polisensibilizare si limitarea testarii in vivo – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_256')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=184))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (184, 'Boli alergice cu suspiciune de polisensibilizare si limitarea testarii in vivo – monitorizare (5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_257')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=185))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (185, 'Boli alergice cu suspiciune de sensibilizare la alergene respiratorii si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_258')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=186))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (186, 'Boli alergice cu suspiciune de sensibilizare la alergene respiratorii si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_259')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=187))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (187, 'Boli alergice cu suspiciune de sensibilizare la alergene alimentare si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_260')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=188))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (188, 'Boli alergice cu suspiciune de sensibilizare la alergene alimentare si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_261')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=189))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (189, 'Boli alergice cu suspiciune de sensibilizare la alergene din veninuri de himenoptere  si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_262')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=190))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (190, 'Boli alergice cu suspiciune de sensibilizare la alergene din veninuri de himenoptere  si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_263')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=191))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (191, 'Boli alergice cu suspiciune de sensibilizare la medicamente si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_264')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=192))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (192, 'Boli alergice cu suspiciune de sensibilizare la medicamente si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_265')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=193))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (193, 'Boli alergice cu suspiciune de sensibilizare la latex si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_266')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=194))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (194, 'Boli alergice cu suspiciune de sensibilizare la latex si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_267')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=195))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (195, 'Acondroplazia – monitorizare cu proceduri de inalta performanta la pacientii cu suspiciune de  complicatii neurologice si respiratorii severe (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_268')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=196))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (196, 'Boala Fabry – monitorizare (Serviciu bianual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_269')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=197))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (197, 'Osteogenza imperfecta - monitorizare (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_270')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=198))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (198, 'Sindromul Down – monitorizare (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_271')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=200))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (200, 'Sindrom DiGeorge – monitorizare (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_273')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=201))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (201, 'Sindromul Williams – monitorizare (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_274')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=202))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (202, 'Hiperchilomicoanemie',NULL,0, 0, 'B.4.1', 'SPT_275')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=203))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (203, 'Sindrom Smith Lemil Opitz',NULL,0, 0, 'B.4.1', 'SPT_276')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=204))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (204, 'Boala depozitarii glicogenului',NULL,0, 0, 'B.4.1', 'SPT_277')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=205))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (205, 'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore (6)',NULL,0, 0, 'B.4.1', 'SPT_278')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=206))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (206, 'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore cu administrare de fier intravenos 500 mg(6)',NULL,0, 0, 'B.4.1', 'SPT_279')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=207))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (207, 'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore cu administrare de fier intravenos 1000 mg(6)',NULL,0, 0, 'B.4.1', 'SPT_280')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=208))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (208, 'Monitorizarea nou-nascutului prematur',NULL,0, 0, 'B.4.1', 'SPT_281')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=209))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (209, 'Gastroenterite alimentare si alergice la copii',NULL,0, 0, 'B.4.1', 'SPT_282')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=210))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (210, 'Evaluarea cardiologica a  bolnavului  oncologic, inainte  de initierea tratamentul chimio si /sau radioterapic',NULL,0, 0, 'B.4.1', 'SPT_283')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=211))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (211, 'Evaluarea cardiologica a bolnavului  oncologic, in timpul chimio/radioterapiei',NULL,0, 0, 'B.4.1', 'SPT_284')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=212))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (212, 'Tratamentul cariei simple la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_285')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=213))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (213, 'Obturatia dintelui dupa tratamentul afectiunilor pulpare sau al gangrenei la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_286')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=214))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (214, 'Tratamentul de urgenta al traumatismelor dento-alveolare la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_287')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=215))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (215, 'Tratamentul afectiunilor pulpare la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_288')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=216))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (216, 'Tratamentul gangrenei pulpare la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_289')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=217))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (217, 'Tratamentul paradontitelor apicale prin incizie la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_290')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=218))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (218, 'Tratamentul afectiunilor paradontiului la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_291')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=219))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (219, 'Tratamentul afectiunilor mucoasei bucale la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_292')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=220))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (220, 'Extractia dintilor temporari la copii cu nevoi speciale ',NULL,0, 0, 'B.4.1', 'SPT_293')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=221))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (221, 'Extractia dintilor permanenti la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_294')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=222))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (222, 'Chiuretaj alveolar si tratamentul hemoragiei la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_295')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=223))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (223, 'Decapusonarea la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_296')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=224))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (224, 'Reducerea luxatiei articulatiei temporo-mandibulare la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_297')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=225))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (225, 'Fluorizare la copii cu nevoi speciale ',NULL,0, 0, 'B.4.1', 'SPT_298')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=226))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (226, 'Artropatia psoriazica pentru tratamentul cu imunosupresoare (4)',NULL,0, 0, 'B.3.2', 'SPT_92')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=227))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (227, 'Terapia distoniilor musculare cu dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru adulti; Terapia paraliziilor cerebrale/paraliziilor care genereaza spasticitate cu dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru copii cu greutate peste 25 kg',NULL,0, 0, 'B.3.2', 'SPT_136')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=228))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (228, 'Terapia distoniilor musculare fara dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru adulti; Terapia paraliziilor cerebrale/paraliziilor care genereaza spasticitate fara dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru copii cu greutate peste 25 kg',NULL,0, 0, 'B.3.2', 'SPT_138')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=229))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (229, 'Terapia spasticitatii membrului superior si/sau inferior aparuta ca urmare a unui accident vascular cerebral pentru pacientul adult – cu toxina botulinica',NULL,0, 0, 'B.3.2', 'SPT_147')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=230))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (230, 'Monitorizarea pacientului cu stenoze coronariene sau periferice',NULL,0, 0, 'B.3.2', 'SPT_206')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=231))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (231, 'Monitorizarea prin RMN cardiac a pacientului cu infarct miocardic acut in antecedente',NULL,0, 0, 'B.3.2', 'SPT_249')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=232))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (232, 'Monitorizarea prin Angio CT cardiac a pacientului cu stent sau bypass coronarian',NULL,0, 0, 'B.3.2', 'SPT_250')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=233))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (233, 'Monitorizarea prin Angio CT periferic a pacientului cu stent periferic, bypass periferic sau in urma unei proceduri de angioplastie periferica',NULL,0, 0, 'B.3.2', 'SPT_251')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=234))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (234, 'Tratamentul anemiei prin carenta de fier la pacientii cu insuficienta cardiaca cronica prin administrare de fier injectabil intravenos',NULL,0, 0, 'B.3.2', 'SPT_210')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=235))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (235, 'Monitorizarea cardiaca a pacientului post-COVID prin RMN cardiac',NULL,0, 0, 'B.3.2', 'SPT_211')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=236))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (236, 'Monitorizarea cardiaca a pacientului post-COVID prin Angio CT coronarian',NULL,0, 0, 'B.3.2', 'SPT_212')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=237))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (237, 'Tratamentul anemiei din boala cronica renala',NULL,0, 0, 'B.3.2', 'SPT_213')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=238))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (238, 'Terapie imunosupresiva in boala cronica renala',NULL,0, 0, 'B.3.2', 'SPT_214')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=239))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (239, 'Monitorizarea evolutiei fenilcetonuriei',NULL,0, 0, 'B.3.2', 'SPT_215')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=240))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (240, 'Diagnostic si/sau stadializare cu proceduri de inalta performanta (2 segmente torace/abdomen sau abdomen/pelvis) in tumori digestive',NULL,0, 0, 'B.3.2', 'SPT_216')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=241))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (241, 'Diagnostic si stadializare cu proceduri de inalta performanta (3 segmente torace/abdomen/pelvis) in tumori digestive',NULL,0, 0, 'B.3.2', 'SPT_217')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=242))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (242, 'Diagnostic cu proceduri de inalta performanta (1 segment abdomen) in boli inflamatorii intestinale',NULL,0, 0, 'B.3.2', 'SPT_218')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=243))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (243, 'Paracenteza',NULL,0, 0, 'B.3.2', 'SPT_219')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=244))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (244, 'Reechilibrare hidro-electrolitica la pacientii cu boli cronice progresive',NULL,0, 0, 'B.3.2', 'SPT_220')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=245))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (245, 'Initierea terapiei antalgice la pacientii cu durere severa',NULL,0, 0, 'B.3.2', 'SPT_221')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=246))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (246, 'Evaluare si tratament la pacientul cu limfedem secundar',NULL,0, 0, 'B.3.2', 'SPT_222')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=247))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (247, 'Monitorizarea pacientului cu durere cronica severa generata de boli cronice progresive',NULL,0, 0, 'B.3.2', 'SPT_223')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=248))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (248, 'Monitorizarea pacientului cu dermatita atopica forma moderat-severa in tratament cu terapii inovatoare (biologice sau cu molecule mici)',NULL,0, 0, 'B.3.2', 'SPT_224')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=249))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (249, 'Tratamentul prin titrare automata al apneei de somn diagnosticata prin poligrafie',NULL,0, 0, 'B.3.2', 'SPT_225')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=250))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (250, 'Monitorizarea si ajustarea tratamentului tulburarilor respiratorii de somn',NULL,0, 0, 'B.3.2', 'SPT_226')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=251))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (251, 'Diagnosticul, tratamentul si monitorizarea tulburarilor respiratorii de somn',NULL,0, 0, 'B.3.2', 'SPT_227')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=252))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (252, 'Poligrafie',NULL,0, 0, 'B.3.2', 'SPT_228')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=253))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (253, 'Poligrafie si titrare automata',NULL,0, 0, 'B.3.2', 'SPT_229')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=254))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (254, 'Polisomnografie si titrare automata',NULL,0, 0, 'B.3.2', 'SPT_230')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=255))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (255, 'Diagnosticul complex al bolii de suprafata oculara (DED) si al altor boli ale suprafatei oculare',NULL,0, 0, 'B.3.2', 'SPT_231')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=256))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (256, 'Tratamentul bolii de suprafata oculara (DED) cu ser autolog si sau imunomodulatoare topice',NULL,0, 0, 'B.3.2', 'SPT_232')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=257))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (257, 'Crosslinking pentru keratoconus',NULL,0, 0, 'B.3.2', 'SPT_233')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=258))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (258, 'Injectare intravitreana de substante terapeutice si monitorizare',NULL,0, 0, 'B.3.2', 'SPT_234')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=259))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (259, 'Tratament si monitorizare tratament chirurgical glob ocular',NULL,0, 0, 'B.3.2', 'SPT_235')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=260))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (260, 'Tratament si monitorizare examinare copil in narcoza',NULL,0, 0, 'B.3.2', 'SPT_236')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=261))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (261, 'Tratament si monitorizare injectie intraoculara',NULL,0, 0, 'B.3.2', 'SPT_237')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=262))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (262, 'Tratament si monitorizare tratament laser glaucom',NULL,0, 0, 'B.3.2', 'SPT_238')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=263))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (263, 'Tratament si monitorizare tratament laser pol posterior al globului ocular',NULL,0, 0, 'B.3.2', 'SPT_239')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=264))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (264, 'Tratament si monitorizare sondaj cai lacrimale la copil in narcoza',NULL,0, 0, 'B.3.2', 'SPT_240')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=265))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (265, 'Diagnosticul si tratamentul anemiei si/sau deficitului de fier, cu fier intravenos, la pacientii cu boli inflamatorii intestinale',NULL,0, 0, 'B.3.2', 'SPT_241')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=266))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (266, 'Monitorizarea pacientilor cu tumori neuroendocrine utilizand scintigrafie 99m-Tc-EDDA-HYNIC TOC (Tektrotyd)  (8)',NULL,0, 0, 'B.3.2', 'SPT_242')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=267))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (267, 'Initiere protocol de administrare a Esketaminei (1)',NULL,0, 0, 'B.3.2', 'SPT_205')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=268))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (268, 'Montare pompe de insulina sau pompe de insulina cu senzori de monitorizare continua a glicemiei',NULL,0, 0, 'B.3.2', 'SPT_243')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=269))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (269, 'Montare sisteme de monitorizare continua a glicemiei',NULL,0, 0, 'B.3.2', 'SPT_244')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=270))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (270, 'Urgenta medicala cu investigatii de inalta performanta (CT, RMN) in camerele de garda',NULL,0, 1, 'B.3.2', 'SPT_245')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=271))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (271, 'Urgenta medicala cu investigatii de inalta performanta (CT, RMN, ANGIOGRAFIE) in structurile de urgenta din cadrul spitalelor pentru care finantarea nu se face din bugetul Ministerului Sanatatii',NULL,0, 1, 'B.3.2', 'SPT_246')
print '1.28 - INSERT INTO [dbo].[ListaTipServicii] - OK'

--------------------------------------------- UPDATE Denumire servicii
update ListaTipServicii   set DenTipServiciu = 'Monitorizare boli neurologice (epilepsie si tulburari de somn, boala Parkinson si alte manifestari extrapiramidale, boli neuromusculare, miastenia gravis si sindromul miastenic, neuropatii periferice, boli neurodegenerative ale sistemului nervos central, ' where IdTipServiciu = 40
update ListaTipServicii   set DenTipServiciu = 'Monitorizare afectiuni oncologice, cu investigatii de inalta performanta' where IdTipServiciu = 77
update ListaTipServicii   set DenTipServiciu = 'Monitorizare afectiuni oncologice, fara investigatii de inalta performanta' where IdTipServiciu = 78
update ListaTipServicii   set DenTipServiciu = 'Chimioterapie (1) cu monitorizare' where IdTipServiciu = 92
update ListaTipServicii   set DenTipServiciu = 'Monitorizarea bolilor psihiatrice adulti si copii (tulburari cognitive minore, demente incipiente, tulburari psihotice si afective în perioade de remisiune, tulburari nevrotice si de personalitate)' where IdTipServiciu = 93
update ListaTipServicii   set DenTipServiciu = 'Implantarea cateterului venos central cu camera implantabila destinat administrarii de chimioterapice (în cure lungi de 6 - 24 luni) pentru pacientii oncologici ?i hematologici. Tariful aferent acestui serviciu include costul cateterului venos central ?i camerei implantabile.' where IdTipServiciu = 98
update ListaTipServicii   set DenTipServiciu = 'Monitorizarea si tratamentul colagenenozelor: poliartrita reumatoida, lupus  eritematos  sistemic,  dermato-polimiozita,  sindrom  Sjorgen, vasculite sistemice.' where IdTipServiciu = 99
update ListaTipServicii   set DenTipServiciu = 'Ciroza hepatica – monitorizare  cu  proceduri de inalta performanta la pacientii cu suspiciune de hepatocarcinom (Serviciu anual per asigurat)' where IdTipServiciu = 111
update ListaTipServicii   set DenTipServiciu = 'Ciroza hepatica virala -  monitorizare si prescriere tratament antiviral (1) (Serviciu lunar per asigurat)' where IdTipServiciu = 113
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala B – diagnostic (Serviciu anual per asigurat)' where IdTipServiciu = 114
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala B fara agent delta – monitorizare tratament antiviral (Serviciu anual per asigurat)' where IdTipServiciu = 115
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala B cu agent delta – diagnostic (Serviciu anual per asigurat)' where IdTipServiciu = 116
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala B cu agent delta - Monitorizarea eficientei si stabilirea continuarii terapiei antivirale (Serviciu anual per asigurat)' where IdTipServiciu = 117
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala C – diagnostic (Serviciu anual per asigurat)' where IdTipServiciu = 118
update ListaTipServicii   set DenTipServiciu = 'Boli inflamatorii intestinale – administrare si prescriere tratament biologic (4) (Serviciu lunar per asigurat)' where IdTipServiciu = 119
update ListaTipServicii   set DenTipServiciu = 'Boli inflamatorii intestinale – monitorizare (Serviciu bianual per asigurat)' where IdTipServiciu = 120
update ListaTipServicii   set DenTipServiciu = 'Monitorizare lunara si prescriere tratament antiviral B, C, D (4) (Serviciu lunar per asigurat)' where IdTipServiciu = 121
update ListaTipServicii   set DenTipServiciu = 'Stadializare fibroza hepatica – Fibroscan la pacientii cu afectiuni hepatice preexistente (Serviciu anual per asigurat)' where IdTipServiciu = 122
update ListaTipServicii   set DenTipServiciu = 'Evaluare postransplant hepatic (Serviciu anual per asigurat)' where IdTipServiciu = 123
update ListaTipServicii   set DenTipServiciu = 'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare-tip I (Serviciu anual per asigurat)' where IdTipServiciu = 124
update ListaTipServicii   set DenTipServiciu = 'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare- tip II (Serviciu anual per asigurat)' where IdTipServiciu = 125
update ListaTipServicii   set DenTipServiciu = 'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare- tip III (Serviciu anual per asigurat)' where IdTipServiciu = 126
update ListaTipServicii   set DenTipServiciu = 'Supravegherea unei sarcini normale (la gravida care nu detine documente medicale care sa ateste existenta in antecedentele personale patologice a rubeolei, toxoplasmozei, infectiei CMV) (1)' where IdTipServiciu = 128
update ListaTipServicii   set DenTipServiciu = 'Supravegherea unei sarcini normale (la gravida care detine documente medicale ce atesta existenta in antecedentele personale patologice a hepatita B si C rubeolei, toxoplasmozei, infectiei CMV) (1)' where IdTipServiciu = 129
update ListaTipServicii   set DenTipServiciu = 'Screening prenatal (S11 - S19+6 zile) (2)' where IdTipServiciu = 130
update ListaTipServicii   set DenTipServiciu = 'Supravegherea altor sarcini cu risc crescut (edem gestational) (3)' where IdTipServiciu = 131
update ListaTipServicii   set DenTipServiciu = 'Supravegherea altor sarcini cu risc crescut (hiperemeza gravidica usoara) (3)' where IdTipServiciu = 132
update ListaTipServicii   set DenTipServiciu = 'Supravegherea altor sarcini cu risc crescut (evaluarea gravidelor cu uter cicatriceal in trimestrul III) (6)' where IdTipServiciu = 133
update ListaTipServicii   set DenTipServiciu = 'Depistarea precoce a cancerului de sân (4)' where IdTipServiciu = 134
update ListaTipServicii   set DenTipServiciu = 'Depistarea si diagonsticarea precoce a leziunilor displazice ale  colului uterin (6)' where IdTipServiciu = 136
update ListaTipServicii   set DenTipServiciu = 'Depistarea si diagonsticarea precoce a leziunilor displazice ale  colului uterin cu examen citologic (7)' where IdTipServiciu = 137
update ListaTipServicii   set DenTipServiciu = 'Diagnosticarea precoce a leziunilor displazice ale colului uterin cu biopsie*8)' where IdTipServiciu = 138
update ListaTipServicii   set DenTipServiciu = 'Terapia spasticitatii membrului superior ?i/sau inferior aparuta ca urmare a unui accident vascular cerebral pentru pacientul adult-cu toxina botulinica' where IdTipServiciu = 140
update ListaTipServicii   set DenTipServiciu = 'Endoscopie digestiva inferioara cu sedare, fara biopsie - colonoscopie flexibila pâna la cec' where IdTipServiciu = 143
update ListaTipServicii   set DenTipServiciu = 'Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pâna la cec' where IdTipServiciu = 144
update ListaTipServicii   set DenTipServiciu = 'Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pâna la flexura hepatica' where IdTipServiciu = 150
update ListaTipServicii   set DenTipServiciu = 'Tratamentul excizional sau ablativ al leziunilor precanceroase ale colului uterin (9)' where IdTipServiciu = 155
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii (1)' where IdTipServiciu = 157
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii (1) –cu investigatie CT' where IdTipServiciu = 158
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii (1) –cu investigatie RX' where IdTipServiciu = 159
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului (2) –cu investigatie CT' where IdTipServiciu = 160
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului  (2) –cu investigatie RX' where IdTipServiciu = 161
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului  (2)' where IdTipServiciu = 162
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata – fara tratament' where IdTipServiciu = 163
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata–cu investigatie CT – fara tratament' where IdTipServiciu = 165
update ListaTipServicii   set DenTipServiciu = 'Distrofie musculara Duchenne/Becker – monitorizare (Serviciu anual per asigurat)' where IdTipServiciu = 199
print '1.28 - Update Denumire servicii - OK'

------------------------------------------------------ UPDATE DataStart servicii
update ListaTipServicii   set DataStart = '2023-06-01 00:00:00' where IdTipServiciu = 168
update ListaTipServicii   set DataStart = '2023-06-01 00:00:00' where IdTipServiciu = 169
update ListaTipServicii   set DataStart = '2023-06-01 00:00:00' where IdTipServiciu = 170
update ListaTipServicii   set DataStart = '2023-07-01 00:00:00' where IdTipServiciu between 171 and 271
print '1.28 - Update DataStart servicii - OK'

-------------------------------------------------------UPDATE Denumire completa servicii
update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)
print '1.28 - Update IdDenDataTipServiciu - OK'

------------------------------------------------------ UPDATE ListaCazRezolvatInterventiiChirurgicale
if not exists (select * from [ListaCazRezolvatInterventiiChirurgicale] where IDCazRezolvatInterventiiChirurgicale = 95)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicale]([IDCazRezolvatInterventiiChirurgicale],[DenCazRezolvatInterventiiChirurgicale],[DataValabilitate],[DenCazRezolvatInterventieComplet])
VALUES (95, 'Montare drenaj ureteral intern', NULL, 'Montare drenaj ureteral intern')

if not exists (select * from [ListaCazRezolvatInterventiiChirurgicale] where IDCazRezolvatInterventiiChirurgicale = 96)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicale]([IDCazRezolvatInterventiiChirurgicale],[DenCazRezolvatInterventiiChirurgicale],[DataValabilitate],[DenCazRezolvatInterventieComplet])
VALUES (96, 'Dezobstructia tractului urinar superior', NULL, 'Dezobstructia tractului urinar superior')

if not exists (select * from [ListaCazRezolvatInterventiiChirurgicale] where IDCazRezolvatInterventiiChirurgicale = 97)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicale]([IDCazRezolvatInterventiiChirurgicale],[DenCazRezolvatInterventiiChirurgicale],[DataValabilitate],[DenCazRezolvatInterventieComplet])
VALUES (97, 'Dilatarea progresiva a stricturilor uretrale', NULL, 'Dilatarea progresiva a stricturilor uretrale')
print '1.28 - Update ListaCazRezolvatInterventiiChirurgicale - OK'

------------------------------------------------------ UPDATE ListaCazRezolvatAfectiuni
if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 114))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (114 ,'Degenerescenta senila a creierului, neclasificata altundeva' ,'G31.1',NULL,'G31.1' + ' - ' + 'Degenerescenta senila a creierului, neclasificata altundeva')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 115))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (115 ,'Osteoporoza (Alte afectiuni specificate ale densitatii si structurii osoase, localizari multiple)' ,'M85.50',NULL,'M85.50' + ' - ' + 'Osteoporoza (Alte afectiuni specificate ale densitatii si structurii osoase, localizari multiple)')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 116))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (116 ,'Pubertate precoce' ,'E30.1',NULL,'E30.1' + ' - ' + 'Pubertate precoce')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 117))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (117 ,'Insuficienta staturala' ,'E34.3',NULL,'E34.3' + ' - ' + 'Insuficienta staturala')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 118))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (118 ,'Alte tireotoxicoze' ,'E05.8',NULL,'E05.8' + ' - ' + 'Alte tireotoxicoze')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 119))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (119 ,'Tumora tiroida cu evolutie imprevizibila si necunoscuta' ,'D44.0',NULL,'D44.0' + ' - ' + 'Tumora tiroida cu evolutie imprevizibila si necunoscuta')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 120))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (120 ,'Pubertate intarziata' ,'E30.0',NULL,'E30.0' + ' - ' + 'Pubertate intarziata')

print '1.28 - Update ListaCazRezolvatAfectiuni - OK'

------------------------------------------------------ UPDATE camp ListaNorme
Update ListaTipServicii
set ListaNorme = 'B.3.2'
where IdTipServiciu in ('1','2','3','4','9','10','11','12','13','14','15','16','17','18','19','20','21','22','30','31','32','71','72')
print '1.28 - Update camp ListaNorme - OK'

------------------------------------------------------ UPDATE camp DataValabilitate
Update ListaTipServicii
set DataValabilitate = '2023-06-30 23:59:59'
where IdTipServiciu = 48
print '1.28 - Update camp DataValabilitate - OK'
------------------------------------------------------ UPDATE ListaTipServiciiCerinte
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =121 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (121,'Mamografie cu tomosinteza unilateral')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =122 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (122,'Senologie imagistica')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =123 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (123,'Punctie biopsie mamara ghidata ecografic, cu marcaj aplicat*10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =124 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (124,'Punctie biopsie mamara cu vacuum ghidata mamografic (stereotactic) sau ecografic, cu marcaj aplicat*10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =125 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (125,'Examen histopatologic procedura completa HE şi coloraţii speciale (1 - 3 blocuri) *10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =126 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (126,'Consultatie de specialitate obstetrica-ginecologie (interpretare integrative a rezultatelor)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =127 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (127,'Mamografie digitala (10)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =128 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (128,'Teste imuno-histochimice *10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =129 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (129,'Examen imunohistochimic *10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =130 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (130,'EKG de repaus 12 derivatii')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =131 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (131,'Doppler color')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =132 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (132,'Angio CT')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =133 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (133,'RMN cord cu contrast')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =134 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (134,'Determinarea NT-pro BNP')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =135 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (135,'Consultatie chirurgie cardiovasculara')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =136 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (136,'Angio CT cardiac cu contrast')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =137 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (137,'Consultatie chirurgie vasculara')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =138 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (138,'Angio CT periferic cu contrast')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =139 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (139,'Angio CT coronarian')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =140 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (140,'Lipidograma')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =141 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (141,'Ionograma')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =142 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (142,'eRFG')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =143 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (143,'Test de efort')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =144 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (144,'RMN')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =145 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (145,'Scintigrafie cardiaca de stress si repaus')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =146 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (146,'Anticorpi anti-gliadina/anti-transglutaminaza tisulara')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =147 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (147,'Testare genetica “next generation sequencing” panel boli cardiovasculare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =148 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (148,'Consultatie de specialitate alergologie si imunologie clinica')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =149 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (149,'IgE specifice serice pentru alergene moleculare multiple (multiplex)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =150 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (150,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 8 alergene moleculare respiratorii)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =151 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (151,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 8 alergene moleculare alimentare)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =152 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (152,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 6 alergene moleculare din veninuri de himenoptere)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =153 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (153,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 4 alergene moleculare medicamentoase)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =154 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (154,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 2 alergene moleculare din latex)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =155 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (155,'Consultatie de specialitate genetica medicala')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =156 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (156,'Spirometrie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =157 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (157,'RMN craniu nativ si cu substanta de contrast ')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =158 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (158,'Rata filtrarii glomerulare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =159 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (159,'Microalbuminurie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =160 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (160,'Examen sumar de urina')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =161 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (161,'Calciu seric total')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =162 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (162,'Fosfor seric')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =163 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (163,'25-OH Vit. D')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =164 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (164,'DXA coloana lombara si sold')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =165 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (165,'Radiografie coloana anteroposterior si profil')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =166 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (166,'Audiometrie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =167 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (167,'Creatinkinaza (CK)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =168 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (168,'Evaluare respiratorie functionala')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =169 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (169,'Evaluare status nutritional')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =170 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (170,'Ecografie renala ')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =171 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (171,'Parathormon seric')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =172 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (172,'FT4')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =173 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (173,'Radiografie coloana vertebrala')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =174 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (174,'Calciu urinar')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =175 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (175,'Consultatie de specialitate pediatrie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =176 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (176,'Consultatie de specialitate diabet si boli metabolice')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =177 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (177,'LDH')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =178 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (178,'Lipaza')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =179 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (179,'Ecografie abdomen ')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =180 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (180,'Determinare grup sanguin si Rh')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =181 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (181,'Fier injectabil intravenos 1000 mg')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =182 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (182,'Consultatie neurologie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =183 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (183,'Consultatie oftalmologie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =184 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (184,'Consultatie dermatologie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =185 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (185,'IgM')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =186 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (186,'IgG')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =187 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (187,'Ecografie sold')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =188 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (188,'Ecografie transfontanelara (ETF)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =189 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (189,'Frotiu sangvin')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =190 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (190,'IgE')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =191 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (191,'Amilaza')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =192 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (192,'Calciu ionic')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =193 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (193,'Bicarbonat seric')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =194 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (194,'Test pt hemoragii oculte')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =195 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (195,'Antigen Helicobacter Pylori')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =196 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (196,'Coeficient de saturatie al transferinei')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =197 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (197,'Ecografie Doppler vasculara periferica (artere sau vene)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =198 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (198,'Ecocardiografie Doppler color, inclusiv GLS (deformare longitudinala globala)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =199 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (199,'Holter EKG 24 ore')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =200 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (200,'Holter EKG 72 ore')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =201 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (201,'Holter TA 24 ore')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =202 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (202,'Electroforeza proteinelor serice')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =203 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (203,'D-Dimeri')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =204 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (204,'Sedare procedurala')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =205 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (205,'Tratamentul cariei simple')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =206 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (206,'Obturatia dintelui dupa tratamentul afectiunilor pulpare sau al gangrenei')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =207 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (207,'Tratamentul de urgenta al traumatismelor dento-alveolare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =208 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (208,'Tratamentul afectiunilor pulpare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =209 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (209,'Tratamentul gangrenei pulpare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =210 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (210,'Tratamentul paradontitelor apicale prin incizie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =211 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (211,'Tratamentul afectiunilor paradontiului')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =212 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (212,'Tratamentul afectiunilor mucoasei bucale')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =213 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (213,'Extractia dintilor temporari')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =214 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (214,'Extractia dintilor permanenti')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =215 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (215,'Chiuretaj alveolar si tratamentul hemoragiei')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =216 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (216,'Decapusonare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =217 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (217,'Reducerea luxatiei articulatiei temporo-mandibulare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =218 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (218,'Fluorizare')
print '1.28 - INSERT ListaTipServiciiCerinte - OK'

------------------------------------------------------ UPDATE ListaTipServiciuXCerinta
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 171) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (171,'95,94,127,121,122,63','B4.2')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 172) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (172,'123,125,128,63','B4.2')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 173) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (173,'124,80,129,63','B4.2')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 174) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (174,'93,38,40,18,46,39,55,19,4,53,54,130,42,29,31,13,32,132','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 175) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (175,'93, 133, 134','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 176) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (176,'93,130,42,29,133','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 177) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (177,'(93 sau 135) si 136','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 178) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (178,'(93 sau 135 sau 137) si 138','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 179) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (179,'93, 41, 38, 140, 141, 89, 19, 105, 139','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 180) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (180,'93, 41, 38, 140, 141, 89, 19, 29, 105, 143, 144','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 181) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (181,'93, 41, 38, 140, 141, 167, 19, 29, 105, 143, 145','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 182) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (182,'93, 41, 38, 140, 141, 19, 167, 134, 29, 105, 147','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 183) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (183,'148, 149','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 184) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (184,'148, 149','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 185) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (185,'148, 150','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 186) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (186,'148, 150','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 187) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (187,'148, 151','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 188) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (188,'148, 151','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 189) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (189,'148, 152','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 190) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (190,'148, 152','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 191) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (191,'148, 153','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 192) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (192,'148, 153','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 193) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (193,'148, 154','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 194) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (194,'148, 154','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 195) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (195,'(155 sau 182) si 19, 156, 157','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 196) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (196,'103, 41, 89, 19, 158, 68, 159, 160, 18, 55, 46, 39, 48, 45, 161, 29, 131, 156','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 197) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (197,'103, 41, 161, 162, 36, 82, 53, 54, 19, 142, 163, 79, 164, 165','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 198) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (198,'103, 41, 51, 34, 38, 18, 55, 53, 54, 19, 161, 48, 45, 109, 88, 146, 79, 29, 131, 166, 105','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 199) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (199,'103, 41, 51, 34, 38, 82, 18, 55, 53, 54, 161, 48, 45, 163, 56, 109, 167, 88, 79, 105, 29, 131, 168, 169, 19','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 200) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (200,'103, 41, 161, 171, 88, 172, 105, 29, 131, 170, 166, 173','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 201) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (201,'103, 41, 51, 38, 18, 55, 53, 54, 19, 48, 45, 161, 174, 163, 56, 109, 88, 79, 105, 29, 131, 170','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 202) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (202,'(175 sau 176) si 41, 38, 53, 54, 11, 12, 82, 7, 37, 36, 177, 111, 99, 106, 88, 18, 39, 46, 55','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 203) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (203,'(175 sau 176) si 41, 38, 53, 54, 18, 39, 46, 55, 178','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 204) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (204,'(175, sau176) si 41, 38, 53, 57, 11, 12, 82, 7, 37, 36, 177, 111, 99, 106, 18, 39, 46, 54, 89, 19, 159, 167, 48, 45, 29, 179','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 205) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (205,'41, 34, 109, 38, 19, 89, 111, 99, 82, 7, 53, 54, 180, 93, 105, 29, 102','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 206) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (206,'41, 34, 109, 38, 19, 89, 111, 99, 82, 7, 53, 54, 180, 93, 105, 29, 102, 112','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 207) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (207,'41, 34, 109, 38, 19, 89, 111, 99, 82, 7, 53, 54, 180, 93, 105, 29, 102, 181','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 208) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (208,'(175 sau 183 sau 182 sau 184), 41, 109, 82, 11, 12, 51, 185, 186, 89, 19, 179, 29, 187, 188','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 209) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (209,'(175 sau 91 sau 148) si41, 189, 109,  56, 82, 7, 18, 46, 39, 55, 51, 34, 190, 53, 54, 89, 19, 99, 111, 106, 191, 48, 45, 161, 192, 193, 194, 195, 179,38','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 210) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (210,'93, 130, 131, 18, 46, 39, 55, 38, 53, 54, 19, 142, 89, 141, 4, 41, 34, 196, 51, 172, 88','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 211) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (211,'93 si 130 si 197 si 198 si (199 sau 200 sau 201) si 19, 142, 89, 82, 202, 53, 54, 203, 134, 141, 41, 51, 34, 196','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 212) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (212,'102, 204, 205','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 213) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (213,'102, 204, 206','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 214) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (214,'102, 204, 207','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 215) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (215,'102, 204, 208','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 216) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (216,'102, 204, 209','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 217) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (217,'102, 204, 210','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 218) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (218,'102, 204, 211','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 219) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (219,'102, 204, 212','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 220) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (220,'102, 204, 213','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 221) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (221,'102, 204, 214','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 222) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (222,'102, 204, 215','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 223) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (223,'102, 204, 216','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 224) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (224,'102, 204, 217','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 225) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (225,'102, 204, 218','B4.1')

------------------------------------------------------ Marire camp ListaTipServiciuXCerinta
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,19,20,44,17', [TipLista] = 'B4.1' WHERE IdTipServiciu = 111
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,41,43,7,38,19,48,45,15,5', [TipLista] = 'B4.1' WHERE IdTipServiciu = 112
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,41,43,53,54,7,38,11,12,19,48,45', [TipLista] = 'B4.1' WHERE IdTipServiciu = 113
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,1,6,2,3,22,35', [TipLista] = 'B4.1' WHERE IdTipServiciu = 114
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,41,53,54,1,6,2,22', [TipLista] = 'B4.1' WHERE IdTipServiciu = 115
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,23', [TipLista] = 'B4.1' WHERE IdTipServiciu = 116
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,23', [TipLista] = 'B4.1' WHERE IdTipServiciu = 117
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92 si 21,35', [TipLista] = 'B4.1' WHERE IdTipServiciu = 118
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,41,7,38,19,53,54,48,45', [TipLista] = 'B4.1' WHERE IdTipServiciu = 119
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,41,43,7,38,19,53,54,36,37,49,56,14,34,51', [TipLista] = 'B4.1' WHERE IdTipServiciu = 120
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,41,53,54,19', [TipLista] = 'B4.1' WHERE IdTipServiciu = 121
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,35', [TipLista] = 'B4.1' WHERE IdTipServiciu = 122
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,16,25,52,58,27,22,21', [TipLista] = 'B4.1' WHERE IdTipServiciu = 123
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '93,38,40,18,46,39,55,19,4,53,54,26,42,29,13,32', [TipLista] = 'B4.1' WHERE IdTipServiciu = 124
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '93,38,40,18,46,39,55,19,4,53,54,26,42,29,13,32,(31sau47)', [TipLista] = 'B4.1' WHERE IdTipServiciu = 125
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '93,38,40,18,46,39,55,19,4,53,54,26,42,29,13,32,31,47', [TipLista] = 'B4.1' WHERE IdTipServiciu = 126
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,10,49,50,24,96,33,9,8,30', [TipLista] = 'B4.1' WHERE IdTipServiciu = 127
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,41,66,67,89,57,19,38,53,54,88,79,90,86,76,84,70,78,85,40,59,65', [TipLista] = 'B4.2' WHERE IdTipServiciu = 128
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,41,66,67,89,57,19,38,53,54,88,79,90,86,75,84,70,78,85,40,59,65', [TipLista] = 'B4.2' WHERE IdTipServiciu = 129
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,69,72', [TipLista] = 'B4.2' WHERE IdTipServiciu = 130
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,41,19,57,53,54,79,68,82,30', [TipLista] = 'B4.2' WHERE IdTipServiciu = 131
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,41,48,79,45,57,19,30,89', [TipLista] = 'B4.2' WHERE IdTipServiciu = 132
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,62,30', [TipLista] = 'B4.2' WHERE IdTipServiciu = 133
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '95,94,127,63', [TipLista] = 'B4.2' WHERE IdTipServiciu = 134
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '95,94,127,122,63', [TipLista] = 'B4.2' WHERE IdTipServiciu = 135
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,87,83,64', [TipLista] = 'B4.2' WHERE IdTipServiciu = 136
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,87,83,77,64', [TipLista] = 'B4.2' WHERE IdTipServiciu = 137
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,60,80', [TipLista] = 'B4.2' WHERE IdTipServiciu = 138
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,34,110,41,51,109,38,19,89,111,99,112', [TipLista] = 'B4.1' WHERE IdTipServiciu = 142
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,100', [TipLista] = 'B4.1' WHERE IdTipServiciu = 143
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,100', [TipLista] = 'B4.1' WHERE IdTipServiciu = 144
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,100,108,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 145
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,100,108,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 146
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,100,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 147
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,100,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 148
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,101', [TipLista] = 'B4.1' WHERE IdTipServiciu = 149
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,101', [TipLista] = 'B4.1' WHERE IdTipServiciu = 150
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,101,108,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 151
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,101,108,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 152
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,101,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 153
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,101,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 154
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,104,97,107,113', [TipLista] = 'B4.2' WHERE IdTipServiciu = 155
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 157
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 157
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,118,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 158
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,118,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 158
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,119,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 159
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,119,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 159
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,118,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 160
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,118,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 160
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,119,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 161
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,119,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 161
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 162
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 162
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 163
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 163
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,119,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 164
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,119,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 164
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,118,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 165
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,118,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 165
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109, 105, 115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 166
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109, 105, 115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 166
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109, 119,105, 115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 167
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109, 119,105, 115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 167
print '1.28 - UPDATE ListaTipServiciuXCerinta - OK'

------------------------------------------------------ Marire camp RegulaIncalcata
alter table PacientFisa
alter column RegulaIncalcata nvarchar(2000) NULL
print '1.28 - Marire camp RegulaIncalcata - OK'


---------------------------------------- 	print 'v1.28 - Stop'     ----------------------------------------

---------------------------------------- 	print 'v1.29 - Stop'     ----------------------------------------
-------------------------------------------------------Stergere servicii inactive
update PacientTipServiciiSZ
set IdTipServiciu = NULL
where IdTipServiciu in (227, 228, 231, 232, 233)

update PacientFisaSZ
set IdTipServiciuUPU = NULL
where IdTipServiciuUPU in (227, 228, 231, 232, 233)

delete from ListaTipServiciuXCerinta
where IdTipServiciu in (227, 228, 231, 232, 233)

delete from ListaTipServicii
where IdTipServiciu in (227, 228, 231, 232, 233)
print '1.29 - Stergere servicii inactive - OK'

--------------------------------------------Expirate la 2023/6/30: 134, 135, 140
update ListaTipServicii
set DataValabilitate = '2023-06-30 23:59:59.000'
where IdTipServiciu in (134, 135, 140)
print '1.29 - Expirare servicii 134, 135, 140 - OK'

-------------------------------------------Inserare servicii noi
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=999))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (999, 'NA',NULL,0, 0, 'B.3.2', NULL)

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=272))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  VALUES (272, 'Depistarea precoce a cancerului de san (4)',NULL,0, 0, 'B.4.2', 'SPT_299', '2023-07-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=273))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  VALUES (273, 'Depistarea precoce a leziunilor precanceroase ale sanului cu suspiciune identificata mamografic',NULL,0, 0, 'B.4.2', 'SPT_300', '2023-07-01 00:00:00.000')

update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)
print '1.29 - Insert servicii noi  999, 272, 273 - OK'

-------------------------------------------Inserare itemuri noi in ListaCazRezolvatInterventiiChirurgicaleProceduri
if not exists (select * from [ListaCazRezolvatInterventiiChirurgicaleProceduri] where [IDCazRezolvatInterventiiChirurgicaleProceduri] = 155)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicaleProceduri]([IDCazRezolvatInterventiiChirurgicaleProceduri],[IDCazRezolvatInterventiiChirurgicale],[CodProcedura])
VALUES (155, 95, 'K02801')

if not exists (select * from [ListaCazRezolvatInterventiiChirurgicaleProceduri] where [IDCazRezolvatInterventiiChirurgicaleProceduri] = 156)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicaleProceduri]([IDCazRezolvatInterventiiChirurgicaleProceduri],[IDCazRezolvatInterventiiChirurgicale],[CodProcedura])
VALUES (156, 96, 'K02901')

if not exists (select * from [ListaCazRezolvatInterventiiChirurgicaleProceduri] where [IDCazRezolvatInterventiiChirurgicaleProceduri] = 157)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicaleProceduri]([IDCazRezolvatInterventiiChirurgicaleProceduri],[IDCazRezolvatInterventiiChirurgicale],[CodProcedura])
VALUES (157, 97, 'K08202')
print '1.29 - Insert proceduri in [ListaCazRezolvatInterventiiChirurgicaleProceduri] - OK'
----------------------------------------- End v1.29

------------------------------------------ Start v1.30
if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 121))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (121 ,'Hiposecretia si alte tulburari ale glandei hipofizare' ,'E23.0',NULL,'E23.0' + ' - ' + 'Hiposecretia si alte tulburari ale glandei hipofizare')

update [dbo].[ListaCazRezolvatAfectiuni]
set CodDiagnostic = 'M85.80',
	DenCazRezolvatAfectiuneComplet = 'M85.80 - Osteoporoza (Alte afectiuni specificate ale densitatii si structurii osoase, localizari multiple)'
where IDCazRezolvatAfectiune = 115
print '1.30 - Modificari in [ListaCazRezolvatAfectiuni] - OK'
------------------------------------------ End v1.30

------------------------------------------ Start v1.31
update PacientTipServiciiSZ
set IdTipServiciu = NULL
where IdTipServiciu in (267)

update PacientFisaSZ
set IdTipServiciuUPU = NULL
where IdTipServiciuUPU in (267)

delete from ListaTipServiciuXCerinta
where IdTipServiciu in (267)

delete from ListaTipServicii
where IdTipServiciu in (267)

update ListaTipServicii
set ListaNorme = 'B.4.1'
where IdTipServiciu = 199

update ListaTipServicii
set DenTipServiciu = 'Depistarea precoce a cancerului de sân cu suspiciune identificata mamografic *5a)'
where IdTipServiciu = 273

update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)
print '1.31 - Stergere servicii inactive - OK'

if not exists(select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 272)
INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista]) VALUES (272, '94,95,63,127', 'B.4.2')

if not exists(select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 273)
INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista]) VALUES (273, '94,95,63,122,127', 'B.4.2')

update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '17,19,20,44,91', TipLista = 'B.4.1' where IdTipServiciu = 111
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '15,19,38,41,43,45,48,5,7,91,92', TipLista = 'B.4.1' where IdTipServiciu = 112
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '11,12,19,38,41,43,45,48,53,54,7,91,92', TipLista = 'B.4.1' where IdTipServiciu = 113
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '1,2,22,3,35,6,91,92', TipLista = 'B.4.1' where IdTipServiciu = 114
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '1,2,22,41,53,54,6,91,92', TipLista = 'B.4.1' where IdTipServiciu = 115
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '23,91,92', TipLista = 'B.4.1' where IdTipServiciu = 116
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '23,91,92', TipLista = 'B.4.1' where IdTipServiciu = 117
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '21,35,91,92', TipLista = 'B.4.1' where IdTipServiciu = 118
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '19,38,41,45,48,53,54,7,91', TipLista = 'B.4.1' where IdTipServiciu = 119
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '14,19,34,36,37,38,41,43,49,51,53,54,56,7,91', TipLista = 'B.4.1' where IdTipServiciu = 120
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '19,41,53,54,91,92', TipLista = 'B.4.1' where IdTipServiciu = 121
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '35,91,92', TipLista = 'B.4.1' where IdTipServiciu = 122
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '16,21,22,25,27,52,58,91', TipLista = 'B.4.1' where IdTipServiciu = 123
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '13,18,19,26,29,32,38,39,4,40,42,46,53,54,55,57,93', TipLista = 'B.4.1' where IdTipServiciu = 124
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '13,18,19,26,29,31,32,38,39,4,40,42,46,47,53,54,55,57,93', TipLista = 'B.4.1' where IdTipServiciu = 125
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '13,18,19,26,29,31,32,38,39,4,40,42,46,47,53,54,55,57,93', TipLista = 'B.4.1' where IdTipServiciu = 126
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '10,24,30,33,49,50,8,9,94,96', TipLista = 'B.4.1' where IdTipServiciu = 127
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '19,38,4,40,41,53,54,57,59,65,66,67,70,76,78,79,84,85,86,88,89,90,94', TipLista = 'B.4.2' where IdTipServiciu = 128
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '19,38,4,40,41,53,54,57,59,65,66,67,70,75,78,79,84,85,86,88,89,90,94', TipLista = 'B.4.2' where IdTipServiciu = 129
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '69,72,94', TipLista = 'B.4.2' where IdTipServiciu = 130
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '19,30,4,41,53,54,57,68,79,82,94', TipLista = 'B.4.2' where IdTipServiciu = 131
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '19,30,4,41,45,48,57,79,89,94', TipLista = 'B.4.2' where IdTipServiciu = 132
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '30,62,94', TipLista = 'B.4.2' where IdTipServiciu = 133
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '63,74,94,95', TipLista = 'B.4.2' where IdTipServiciu = 134
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '63,73,74,94,95', TipLista = 'B.4.2' where IdTipServiciu = 135
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '64,83,87,94', TipLista = 'B.4.2' where IdTipServiciu = 136
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '64,77,83,87,94', TipLista = 'B.4.2' where IdTipServiciu = 137
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '60,80,94', TipLista = 'B.4.2' where IdTipServiciu = 138
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,109,110,111,112,19,34,38,41,51,89,99', TipLista = 'B.4.1' where IdTipServiciu = 142
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '100,102,103,105,106,111,41,98,99', TipLista = 'B.4.1' where IdTipServiciu = 143
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '100,103,105,106,111,41,99', TipLista = 'B.4.1' where IdTipServiciu = 144
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '100,102,103,105,106,108,111,114,41,80,98,99', TipLista = 'B.4.1' where IdTipServiciu = 145
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '100,103,105,106,108,111,114,41,80,99', TipLista = 'B.4.1' where IdTipServiciu = 146
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '100,102,103,105,106,111,114,41,80,98,99', TipLista = 'B.4.1' where IdTipServiciu = 147
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '100,103,105,106,111,114,41,80,99', TipLista = 'B.4.1' where IdTipServiciu = 148
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '101,102,103,105,106,111,41,98,99', TipLista = 'B.4.1' where IdTipServiciu = 149
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '101,103,105,106,111,41,99', TipLista = 'B.4.1' where IdTipServiciu = 150
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '101,102,103,105,106,108,111,114,41,80,98,99', TipLista = 'B.4.1' where IdTipServiciu = 151
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '101,103,105,106,108,111,114,41,80,99', TipLista = 'B.4.1' where IdTipServiciu = 152
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '101,102,103,105,106,111,114,41,80,98,99', TipLista = 'B.4.1' where IdTipServiciu = 153
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '101,103,105,106,111,114,41,80,99', TipLista = 'B.4.1' where IdTipServiciu = 154
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '104,107,113,94,97', TipLista = 'B.4.2' where IdTipServiciu = 155
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,116,117,19,38,41,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 157
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,116,117,118,19,38,41,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 158
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,116,117,119,19,38,41,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 159
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,116,118,120,19,38,41,45,48,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 160
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,116,119,120,19,38,41,45,48,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 161
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,116,120,19,38,41,45,48,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 162
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,19,38,41,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 163
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,119,19,38,41,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 164
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,118,19,38,41,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 165
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,19,38,41,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 166
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,115,119,19,38,41,53,54,89', TipLista = 'B.4.x' where IdTipServiciu = 167
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '121,122,127,63,94,95', TipLista = 'B.4.2' where IdTipServiciu = 171
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '123,125,128,63', TipLista = 'B.4.2' where IdTipServiciu = 172
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '124,129,63,80', TipLista = 'B.4.2' where IdTipServiciu = 173
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '13,130,132,18,19,29,31,32,38,39,4,40,42,46,53,54,55,93', TipLista = 'B.4.1' where IdTipServiciu = 174
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '133,134,93', TipLista = 'B.4.1' where IdTipServiciu = 175
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '130,133,29,42,93', TipLista = 'B.4.1' where IdTipServiciu = 176
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '135,136,93', TipLista = 'B.4.1' where IdTipServiciu = 177
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '135,137,138,93', TipLista = 'B.4.1' where IdTipServiciu = 178
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '105,139,140,141,19,38,41,89,93', TipLista = 'B.4.1' where IdTipServiciu = 179
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '105,140,141,143,144,19,29,38,41,89,93', TipLista = 'B.4.1' where IdTipServiciu = 180
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '105,140,141,143,145,19,29,38,41,89,93', TipLista = 'B.4.1' where IdTipServiciu = 181
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '105,134,140,141,147,167,19,29,38,41,93', TipLista = 'B.4.1' where IdTipServiciu = 182
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,149', TipLista = 'B.4.1' where IdTipServiciu = 183
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,149', TipLista = 'B.4.1' where IdTipServiciu = 184
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,150', TipLista = 'B.4.1' where IdTipServiciu = 185
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,150', TipLista = 'B.4.1' where IdTipServiciu = 186
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,151', TipLista = 'B.4.1' where IdTipServiciu = 187
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,151', TipLista = 'B.4.1' where IdTipServiciu = 188
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,152', TipLista = 'B.4.1' where IdTipServiciu = 189
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,152', TipLista = 'B.4.1' where IdTipServiciu = 190
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,153', TipLista = 'B.4.1' where IdTipServiciu = 191
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,153', TipLista = 'B.4.1' where IdTipServiciu = 192
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,154', TipLista = 'B.4.1' where IdTipServiciu = 193
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '148,154', TipLista = 'B.4.1' where IdTipServiciu = 194
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '155,156,157,182,19', TipLista = 'B.4.1' where IdTipServiciu = 195
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,131,156,158,159,160,161,18,19,29,39,41,45,46,48,55,68,89', TipLista = 'B.4.1' where IdTipServiciu = 196
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,142,161,162,163,164,165,19,36,41,53,54,79,82', TipLista = 'B.4.1' where IdTipServiciu = 197
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,131,146,161,166,18,19,29,34,38,41,45,48,51,53,54,55,79,88', TipLista = 'B.4.1' where IdTipServiciu = 198
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,131,161,163,167,168,169,18,19,29,34,38,41,45,48,51,53,54,55,56,79,82,88', TipLista = 'B.4.1' where IdTipServiciu = 199
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,131,161,166,170,171,172,173,29,41,88', TipLista = 'B.4.1' where IdTipServiciu = 200
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '103,105,109,131,161,163,170,174,18,19,29,38,41,45,48,51,53,54,55,56,79,88', TipLista = 'B.4.1' where IdTipServiciu = 201
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '106,11,111,12,175,176,177,18,36,37,38,39,41,46,53,54,55,7,82,88,99', TipLista = 'B.4.1' where IdTipServiciu = 202
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '175,176,178,18,38,39,41,46,53,54,55', TipLista = 'B.4.1' where IdTipServiciu = 203
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '106,11,111,12,159,167,175,176,177,179,18,19,29,36,37,38,39,41,45,46,48,53,54,57,7,82,89,99', TipLista = 'B.4.1' where IdTipServiciu = 204
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,105,109,111,180,19,29,34,38,41,53,54,7,82,89,93,99', TipLista = 'B.4.1' where IdTipServiciu = 205
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,105,109,111,112,180,19,29,34,38,41,53,54,7,82,89,93,99', TipLista = 'B.4.1' where IdTipServiciu = 206
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,105,109,111,180,181,19,29,34,38,41,53,54,7,82,89,93,99', TipLista = 'B.4.1' where IdTipServiciu = 207
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '109,11,12,175,179,182,183,184,185,186,187,188,19,29,41,51,82,89', TipLista = 'B.4.1' where IdTipServiciu = 208
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '106,109,111,148,161,175,179,18,189,19,190,191,192,193,194,195,34,38,39,41,45,46,48,51,53,54,55,56,7,82,89,91,99', TipLista = 'B.4.1' where IdTipServiciu = 209
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '130,131,141,142,172,18,19,196,29,34,38,39,4,41,46,51,53,54,55,88,89,93', TipLista = 'B.4.1' where IdTipServiciu = 210
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '130,134,141,142,19,196,197,198,199,200,201,202,203,34,41,51,53,54,82,89,93', TipLista = 'B.4.1' where IdTipServiciu = 211
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,205', TipLista = 'B.4.1' where IdTipServiciu = 212
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,206', TipLista = 'B.4.1' where IdTipServiciu = 213
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,207', TipLista = 'B.4.1' where IdTipServiciu = 214
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,208', TipLista = 'B.4.1' where IdTipServiciu = 215
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,209', TipLista = 'B.4.1' where IdTipServiciu = 216
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,210', TipLista = 'B.4.1' where IdTipServiciu = 217
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,211', TipLista = 'B.4.1' where IdTipServiciu = 218
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,212', TipLista = 'B.4.1' where IdTipServiciu = 219
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,213', TipLista = 'B.4.1' where IdTipServiciu = 220
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,214', TipLista = 'B.4.1' where IdTipServiciu = 221
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,215', TipLista = 'B.4.1' where IdTipServiciu = 222
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,216', TipLista = 'B.4.1' where IdTipServiciu = 223
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,217', TipLista = 'B.4.1' where IdTipServiciu = 224
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '102,204,218', TipLista = 'B.4.1' where IdTipServiciu = 225
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '127,63,94,95', TipLista = 'B.4.2' where IdTipServiciu = 272
update ListaTipServiciuXCerinta   set IdsTipServiciuCerinte = '122,127,63,94,95', TipLista = 'B.4.2' where IdTipServiciu = 273
print '1.31 - Insert si update cerinte in ListaTipServiciuXCerinta - OK'

------------------------------------------ End v1.31
------------------------------------------ Start v1.32
ALTER TABLE [dbo].[IstoricPFSZ]
ALTER COLUMN [IdTipServiciuUPU] smallint NULL
print '1.32 - ALTER COLUMN [IstoricPFSZ].[IdTipServiciuUPU] - OK'

-- Adaugare servicii noi 274-277
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=274))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (274, 'Terapia paraliziilor cerebrale/paraliziilor care genereaza spasticitate cu dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru copii cu greutate peste 25 kg',NULL,0, 0, 'B.3.2', 'SPT_304', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=275))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (275, 'Terapia distoniilor musculare cu dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru adulti',NULL,0, 0, 'B.3.2', 'SPT_305', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=276))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (276, 'Terapia paraliziilor cerebrale/paraliziilor care genereaza spasticitate fara dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru copii cu greutate peste 25 kg',NULL,0, 0, 'B.3.2', 'SPT_306', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=277))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (277, 'Terapia distoniilor musculare fara dirijare electromiografica (cervicale, craniofaciale, ale  membrelor, laringiene etc.) cu toxina botulinica pentru adulti',NULL,0, 0, 'B.3.2', 'SPT_307', '2023-10-01 00:00:00.000')

update ListaTipServicii
set DataValabilitate = '2023-09-30 23:59:59.000'
where IdTipServiciu in (102, 104)

update ListaTipServicii
set DenTipServiciu = 'Monitorizare afectiuni onclogice, cu  minim 3 investigatii de inalta performanta'
where IdTipServiciu = 77

update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)
print '1.32 - ListaTipServicii - OK'

ALTER TABLE [dbo].[PacientFisa]
ALTER COLUMN [RegulaIncalcata] nvarchar(2000) NULL

ALTER TABLE [dbo].[PacientFisaSZ]
ALTER COLUMN [RegulaIncalcata] nvarchar(2000) NULL

ALTER TABLE [dbo].[IstoricPF]
ALTER COLUMN [RegulaIncalcata] nvarchar(2000) NULL

ALTER TABLE [dbo].[IstoricPFSZ]
ALTER COLUMN [RegulaIncalcata] nvarchar(2000) NULL
print '1.32 - Marire camp RegulaIncalcata - OK'

------------------------------------------ End v1.32
------------------------------------------ Start v1.33
-- Adaugare servicii noi 278-286
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=278))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (278, 'Radioterapie IMRT-adulti',NULL,1, 0, 'B.3.1', 'SPT_3.13', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=279))
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (279, 'Radioterapie IMRT-copii, fara anestezie',NULL,1, 0, 'B.3.1', 'SPT_3.14', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=280))
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (280, 'Radioterapie IMRT-copii, cu anestezie',NULL,1, 0, 'B.3.1', 'SPT_3.15', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=281))
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (281, 'Radioterapie stereotactica - adulti',NULL,1, 0, 'B.3.1', 'SPT_3.16', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=282))
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (282, 'Radioterapie stereotactica- copii, fara anestezie',NULL,1, 0, 'B.3.1', 'SPT_3.17', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=283))
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (283, 'Radioterapie stereotactica-copii, cu anestezie',NULL,1, 0, 'B.3.1', 'SPT_3.18', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=284))
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (284, 'Iradiere corporala totala-adulti, fara anestezie',NULL,1, 0, 'B.3.1', 'SPT_3.19', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=285))
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (285, 'Iradiere corporala totala sau cranio-spinala copii, fara anestezie',NULL,1, 0, 'B.3.1', 'SPT_3.20', '2023-10-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=286))
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  
VALUES (286, 'Iradiere corporala totala sau cranio-spinala copii, cu anestezie',NULL,1, 0, 'B.3.1', 'SPT_3.21', '2023-10-01 00:00:00.000')


update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)
print '1.33 - ListaTipServicii - OK'

------------------------------------------ End v1.33

------------------------------------------ Start v1.34
--Adaugare proceduri noi

if not exists (select IdProcedura from ListaProceduri where IdProcedura = 5927)
INSERT INTO [dbo].[ListaProceduri] ([IdProcedura], [CodProcedura], [DenProcedura], [IdBloc], [EsteInterventieChirurgicala], [CodDenProcedura], [DataStart], [DataEnd])
VALUES (5927, 'A00608', 'Monitorizare neurofiziologica intraoperatorie - supratentoriala', 6, 0, 'A00608 - Monitorizare neurofiziologica intraoperatorie - supratentoriala - 2024-07-01 - NA', '2024-07-01 00:00:00.000', NULL)

if not exists (select IdProcedura from ListaProceduri where IdProcedura = 5928)
INSERT INTO [dbo].[ListaProceduri] ([IdProcedura], [CodProcedura], [DenProcedura], [IdBloc], [EsteInterventieChirurgicala], [CodDenProcedura], [DataStart], [DataEnd])
VALUES (5928, 'A00609', 'Monitorizare neurofiziologica intraoperatorie - infratentoriala', 6, 0, 'A00609 - Monitorizare neurofiziologica intraoperatorie - infratentoriala - 2024-07-01 - NA', '2024-07-01 00:00:00.000', NULL)

if not exists (select IdProcedura from ListaProceduri where IdProcedura = 5929)
INSERT INTO [dbo].[ListaProceduri] ([IdProcedura], [CodProcedura], [DenProcedura], [IdBloc], [EsteInterventieChirurgicala], [CodDenProcedura], [DataStart], [DataEnd])
VALUES (5929, 'A00610', 'Monitorizare neurofiziologica intraoperatorie – spinala si nervi periferici', 6, 0, 'A00610 - Monitorizare neurofiziologica intraoperatorie – spinala si nervi periferici - 2024-07-01 - NA', '2024-07-01 00:00:00.000', NULL)

print '1.34 - Adaugare 3 recorduri in ListaProceduri - OK'

if not exists(select IdCriteriuInternare from ListaCriteriiInternare where IdCriteriuInternare = 7)
INSERT INTO [dbo].[ListaCriteriiInternare] ([IdCriteriuInternare], [DenCriteriuInternare]) VALUES (7, 'Afectiune oncologica diagnosticata - persoana asigurata')

if not exists(select IdCriteriuInternare from ListaCriteriiInternare where IdCriteriuInternare = 8)
INSERT INTO [dbo].[ListaCriteriiInternare] ([IdCriteriuInternare], [DenCriteriuInternare]) VALUES (8, 'Suspiciune de afectiune oncologica, pentru confirmare - persoana asigurata')

update ListaCriteriiInternare
set DenCriteriuInternare = 'Bolnavi aflati sub incidenta art. 109, 110, 124 si 125 din Legea nr. 286/2009 privind Codul penal, cu modificarile si completarile ulterioare, si in cazurile dispuse prin ordonanta a procurorului pe timpul judecarii sau urmaririi penale, care necesita izolare ori internare obligatorie, si tratamentul persoanelor private de libertate pentru care instanta de judecata a dispus executarea pedepsei intr-un penitenciar-spital, precum si tratamentul pacientilor din penitenciare ale caror afectiuni necesita monitorizare si reevaluare in cadrul penitenicarelor-spital'
where IdCriteriuInternare = 4

print '1.34 - Adaugare 2 recorduri in ListaCriteriiInternare - OK'

update ListaCriteriiInternareSZ 
set DenCriteriuInternare = 'Urgente medico-chirurgicale, ce necesita supraveghere medicala pana la 12 ore'
where IdCriteriuInternare = 1

update ListaCriteriiInternareSZ 
set DenCriteriuInternare = 'Epidemiologic pentru bolnavii care necesita tratament in afectiuni care nu necesita izolare'
where IdCriteriuInternare = 3

if not exists(select IdCriteriuInternare from ListaCriteriiInternareSZ where IdCriteriuInternare = 4)
INSERT INTO [dbo].[ListaCriteriiInternareSZ] ([IdCriteriuInternare], [DenCriteriuInternare]) VALUES (4, 'Afectiune oncologica diagnosticata - persoana asigurata')

if not exists(select IdCriteriuInternare from ListaCriteriiInternareSZ where IdCriteriuInternare = 5)
INSERT INTO [dbo].[ListaCriteriiInternareSZ] ([IdCriteriuInternare], [DenCriteriuInternare]) VALUES (5, 'Suspiciune de afectiune oncologica, pentru confirmare - persoana asigurata')

if not exists(select IdCriteriuInternare from ListaCriteriiInternareSZ where IdCriteriuInternare = 6)
INSERT INTO [dbo].[ListaCriteriiInternareSZ] ([IdCriteriuInternare], [DenCriteriuInternare]) VALUES (6, 'Suspiciune de afectiune oncologica, pentru confirmare - persoana neasigurata')


print '1.34 - Adaugare 2 recorduri in ListaCriteriiInternareSZ - OK'

update ListaCazRezolvatAfectiuni
set DataValabilitate = '2024-06-30',
DenCazRezolvatAfectiuneComplet = 'K76.0 - Degenerescenta grasoasa a ficatului, neclasificata altundeva -- 30/06/2024'
where IDCazRezolvatAfectiune = 64

print '1.34 - Modificare record in ListaCazRezolvatAfectiuni - OK'

update ListaTipServicii
set DataValabilitate = '2024-06-30'
where IdTipServiciu in (240,241)

update ListaTipServicii
set DataValabilitate = '2024-06-30'
where IdTipServiciu in (128, 129, 130, 131, 132, 133, 155)

update ListaTipServicii
set DataValabilitate = '2024-06-30'
where IdTipServiciu in (143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 205, 206, 207, 210)

if not exists (select * from ListaTipServicii where IdTipServiciu = 287) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(287,'Endoscopie digestiva inferioara cu sedare, fara biopsie - colonoscopie flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_308', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 288) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(288,'Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_309', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 289) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(289,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie 1-3 blocuri, fara hemostaza - colonoscopie flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_310', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 290) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(290,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie 1-3 blocuri, fara hemostaza - colonoscopie flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_311', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 291) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(291,'Endoscopie digestiva inferioara cu sedare, cu biopsie - colonoscopie flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_312', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 292) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(292,'Endoscopie digestiva inferioara fara sedare, cu biopsie - colonoscopie flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_313', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 293) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(293,'Endoscopie digestiva inferioara cu sedare, fara biopsie - colonoscopie flexibila pana la flexura hepatica', NULL, 0, 0,'B.4.1','SPT_314', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 294) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(294,'Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pana la flexura hepatica', NULL, 0, 0,'B.4.1','SPT_315', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 295) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(295,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la flexura hepatica', NULL, 0, 0,'B.4.1','SPT_316', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 296) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(296,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la flexura hepatica', NULL, 0, 0,'B.4.1','SPT_317', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 297) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(297,'Endoscopie digestiva inferioara cu sedare, cu biopsie - colonoscopie flexibila pana la flexura hepatica', NULL, 0, 0,'B.4.1','SPT_318', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 298) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(298,'Endoscopie digestiva inferioara fara sedare, cu biopsie - colonoscopie flexibila pana la flexura hepatica', NULL, 0, 0,'B.4.1','SPT_319', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 299) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(299,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie, 1-3 blocuri,  cu hemostaza - Colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_320', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 300) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(300,'Ecoendoscopie cu sedare, cu biopsie - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_330', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 301) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(301,'Ecoendoscopie cu sedare, fara biopsie', NULL, 0, 0,'B.4.1','SPT_331', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 302) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(302,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie, 1-3 blocuri, cu hemostaza - Colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_321', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 303) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(303,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie, 4-6 blocuri,  fara hemostaza - Colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_322', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 304) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(304,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie, 4-6 blocuri, fara hemostaza - Colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_323', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 305) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(305,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie, 4-6 blocuri,  cu hemostaza - Colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_324', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 306) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(306,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie, 4-6 blocuri, cu hemostaza - Colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_325', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 307) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(307,'Endoscopia digestiva superioara si inferioara, fara sedare, fara biopsie - Endoscopia digestiva superioara si colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_326', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 308) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(308,'Endoscopia digestiva superioara si inferioara, cu sedare, fara biopsie - Endoscopia digestiva superioara si colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_327', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 309) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(309,'Endoscopia digestiva superioara si inferioara, fara sedare, cu biopsie - Endoscopia digestiva superioara si colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_328', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 310) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(310,'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore, cu determinare CTLF******)', NULL, 0, 0,'B.4.1','SPT_363', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 311) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(311,'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore, cu determinarea transferinei******)', NULL, 0, 0,'B.4.1','SPT_364', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 312) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(312,'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore, cu determinare CTLF, cu administrare de fier intravenos 500 mg******)', NULL, 0, 0,'B.4.1','SPT_365', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 313) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(313,'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore, cu determinarea transferinei, cu administrare de fier intravenos 500 mg******)', NULL, 0, 0,'B.4.1','SPT_366', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 314) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(314,'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore, cu determinare CTLF, cu administrare de fier intravenos 1000 mg******)', NULL, 0, 0,'B.4.1','SPT_367', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 315) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(315,'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore, cu determinarea transferinei, cu administrare de fier intravenos 1000 mg******)', NULL, 0, 0,'B.4.1','SPT_368', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 316) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(316,'Diagnosticul mielomului multiplu, amiloidozei tip lant usor, macroglobulinemiei Waldenstrom, bolii de depozitare a lanturilor usoare, gamapatiei monoclonale cu etiologie neprecizata - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_386', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 317) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(317,'Evaluarea extensiei  mielomului multiplu/  amiloidozei tip lant usor, macroglobulinemiei Waldenstrom, bolii de depozitare a lanturilor usoare, gamapatiei monoclonale cu etiologie neprecizata - se deconteaza maxim un serviciu/an/pacient (CT whole body low dose)', NULL, 0, 0,'B.4.1','SPT_387', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 318) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(318,'Monitorizarea evolutiei si raspunsului la tratamentul mielomului multiplu, amiloidozei tip lant usor, macroglobulinemiei Waldenstrom, bolii de depozitare a lanturilor usoare - se deconteaza maxim 5 servicii/an/pacient', NULL, 0, 0,'B.4.1','SPT_388', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 319) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(319,'Evaluarea raspunsului complet dupa tratament pentru mielomul multiplu, amiloidoza tip lant usor, macroglobulinemia Waldenstrom, boala de depozitare a lanturilor usoare - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_389', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 320) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(320,'Urmarirea gamapatiei monoclonale cu etiologie neprecizata - se deconteaza maxim 2 servicii/an/pacient', NULL, 0, 0,'B.4.1','SPT_390', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 321) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(321,'Evaluarea pacientului cu suspiciune de cancer colo-rectal - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_391', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 322) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(322,'Diagnosticul Cancerului Colo-rectal - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_392', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 323) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(323,'Evaluarea extensiei reale a Cancerului de colon  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_393', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 324) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(324,'Evaluarea statusului clinico-biologic la pacientul cu Cancer de colon in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_394', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 325) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(325,'Evaluarea extensiei reale a Cancerului de rect - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_395', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 326) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(326,'Evaluarea statusului clinico-biologic la pacientul cu Cancer de rect, in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_396', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 327) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(327,'Diagnosticul cancerului mamar cu punctie biopsie ghidata ecografic cu marcaj - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_397', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 328) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(328,'Diagnosticul cancerului mamar cu mamografie cu tomosinteza si punctie biopsie ghidata ecografic cu marcaj - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_398', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 329) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(329,'Diagnosticul cancerului mamar cu punctie biopsie mamara cu vacuum - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_400', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 330) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(330,'Diagnosticul cancerului mamar cu mamografie cu tomosinteza si punctie biopsie mamara cu vacuum - se deconteaza maxim un serviciu/an/pacienta  - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_401', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 331) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(331,'Evaluarea extensiei reale a Cancerului mamar luminal A/Cancerului mamar luminal B/Cancerului mamar triplu negative/ Cancerului mamar her pozitiv/amplificat  - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_402', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 332) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(332,'Evaluarea statusului clinico-biologic la pacientul cu Cancer mamar luminal A/Cancerul mamar luminal B/Cancerul mamar triplu negativ/Cancerul mamar HER pozitiv/amplificat,  in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_403', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 333) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(333,'Diagnosticul Cancerului de prostata – Adenocarcinom/cu diferentiere neuroendocrina/ carcinom neuroendocrin - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_404', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 334) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(334,'Evaluarea statusului clinico-biologic la pacientul cu Cancer de prostata – Adenocarcinom/cu diferentiere neuroendocrina/ carcinom neuroendocrin - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_405', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 335) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(335,'Diagnosticul Cancerului bronho-pulmonar cu celula mica/fara celula mica scuamos (carcinom fara celula mica scuamos)/fara celula mica non-scuamos (carcinom fara celula mica non-scuamos) - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_406', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 336) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(336,'Evaluarea extensiei reale a  Cancerului bronho-pulmonar cu celula mica, cu punctie pleurala  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului, de la aceasta pozitie sau urmatoarea - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_407', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 337) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(337,'Evaluarea extensiei reale a  Cancerului bronho-pulmonar cu celula mica - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului, de la aceasta pozitie sau precedenta', NULL, 0, 0,'B.4.1','SPT_408', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 338) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(338,'Evaluarea extensiei reale a  Cancerului bronho-pulmonar fara celula mica scuamos (carcinom fara celula mica scuamos) stadiu nonmetastatic - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_409', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 339) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(339,'Evaluarea extensiei reale a  Cancerului bronho-pulmonar fara celula mica scuamos (carcinom fara celula mica scuamos) stadiu metastatic - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_410', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 340) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(340,'Evaluarea statusului clinico-biologic la pacientul cu  Cancer bronho-pulmonar cu celula mica/fara celula mica scuamos (carcinom fara celula mica scuamos)/fara celula mica non-scuamos (carcinom fara celula mica non-scuamos)  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_411', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 341) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(341,'Diagnosticul Cancerului de col uterin - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_412', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 342) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(342,'Evaluarea extensiei cancerului de col uterin incipient (limitat local) - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_413', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 343) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(343,'Evaluarea extensiei cancerului de col uterin, stadiu avansat (IIB-IV) - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_414', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 344) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(344,'Evaluarea statusului clinico-biologic la pacientul cu cancer de col uterin (carcinom scuamos)/(endocol)- adenocarcinom  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_415', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 345) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(345,'Diagnosticul carcinomului urotelial al vezicii urinare - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_416', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 346) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(346,'Diagnosticul  carcinomului urotelial al cailor urinare superioare (ureter sau bazinet renal) - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_417', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 347) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(347,'Evaluarea extensiei carcinomului urotelial al vezicii urinare/ carcinomului urotelial al cailor urinare superioare (ureter sau bazinet renal)  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_418', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 348) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(348,'Evaluarea statusului clinico-biologic la pacientul cu  carcinom urotelial al vezicii urinare/ carcinomului urotelial al cailor urinare superioare (ureter sau bazinet renal)  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_419', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 349) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(349,'Diagnosticul  cancerului gastric si de jonctiune gastro-esofagiana - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_420', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 350) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(350,'Evaluarea extensiei reale a  cancerului gastric si de jonctiune gastro-esofagiana/limfomului gastric tip MALT/ limfomului malign non-Hodgkin gastric non-MALT - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_421', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 351) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(351,'Evaluarea statusului clinico-biologic  la pacientul cu cancer gastric si de jonctiune gastro-esofagiana - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_422', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 352) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(352,'Diagnosticul limfomului gastric tip MALT/ limfomului malign non-Hodgkin gastric non-MALT - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_423', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 353) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(353,'Evaluarea statusului clinico-biologic al pacientului cu  limfom gastric tip MALT/ limfomului malign non-Hodgkin gastric non-MALT - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_424', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 354) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(354,'Diagnosticul cancerului hepatocelular - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_425', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 355) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(355,'Evaluarea extensiei reale a  cancerului hepatocelular - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_426', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 356) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(356,'Evaluarea statusului clinico-biologic  la  pacientul cu cancer hepatocelular - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_427', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 357) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(357,'Diagnosticul ampulomului vaterian - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_428', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 358) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(358,'Evaluarea extensiei reale a ampulomului vaterian  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_429', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 359) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(359,'Evaluarea statusului clinico-biologic  la pacientul cu ampulom vaterian - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_430', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 360) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(360,'Diagnosticul cancerului pancreatic - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_431', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 361) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(361,'Evaluarea extensiei reale a  adenocarcinomului pancreatic  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_432', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 362) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(362,'Evaluarea statusului clinico-biologic la pacientul cu  adenocarcinom pancreatic  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_433', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 363) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(363,'Diagnosticul tumorilor neuroendocrine pancreatice  - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_434', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 364) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(364,'Evaluarea extensiei reale a  tumorilor neuroendocrine pancreatice - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_435', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 365) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(365,'Evaluarea statusului clinico-biologic la pacientul cu  tumori neuroendocrine pancreatice  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_436', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 366) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(366,'Diagnosticul cancerului non-urotelial, cu celule clare/ cancerului renal non-urotelial, cu alte celule decat cel cu celule clare - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_437', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 367) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(367,'Evaluarea extensiei reale a cancerului non-urotelial, cu celule clare/ cancerului renal non-urotelial, cu alte celule decat cel cu celule clare - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_438', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 368) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(368,'Evaluarea statusului clinico-biologic la pacientul cu cancer non-urotelial, cu celule clare/ cancer renal non-urotelial, cu alte celule decat cel cu celule clare - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_439', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 369) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(369,'Diagnosticul cancerului endometrial/ cancerelor corpului uterin  - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_440', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 370) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(370,'Evaluarea extensiei reale a  cancerului endometrial/ cancerului corpului uterin - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_441', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 371) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(371,'Evaluarea statusului clinico-biologic la pacienta cu  cancer endometrial/ cancer al corpului uterin - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_442', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 372) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(372,'Diagnosticul cancerelor de cavitate orala/orofaringe/ cancerelor de hipofaringe/ cancerelor de laringe/ cancerelor de nazofaringe - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_443', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 373) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(373,'Evaluarea extensiei reale a cancerelor de cavitate orala/orofaringe/ cancerelor de hipofaringe/ cancerelor de laringe/ cancerelor de nazofaringe - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_444', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 374) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(374,'Evaluarea statusului clinico-biologic la pacientul cu cancerul cavitatii orale/ cancerelor de orofaringe/ cancer de hipofaringe/ cancer de laringe/ cancer de nazofaringe - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_445', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 375) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(375,'Diagnosticul cancerelor de parotida/de glande salivare - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_446', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 376) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(376,'Evaluarea extensiei reale a cancerelor de parotida/de glande salivare  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_447', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 377) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(377,'Evaluarea statusului clinico-biologic la pacientul cu cancer de parotida/glande salivare - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_448', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 378) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(378,'Diagnosticul cancerului tiroidian papilar/ cancerului tiroidian folicular/ cancerului tiroidian oncocitic - se deconteaza maxim un serviciu/an/CNP - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_449', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 379) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(379,'Evaluarea statusului clinico-biologic la pacientul cu  cancer tiroidian papilar/ cancerului tiroidian folicular/ cancerului tiroidian oncocitic  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_450', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 380) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(380,'Diagnosticul cancerului tiroidian medular - se deconteaza maxim un serviciu/an/CNP - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_451', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 381) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(381,'Evaluarea extensiei reale a  cancerului tiroidian medular  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_452', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 382) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(382,'Evaluarea statusului clinico-biologic la pacientul cu  cancer  tiroidian medular  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_453', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 383) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(383,'Diagnosticul cancerelor de tiroida anaplazice - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_454', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 384) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(384,'Evaluarea statusului clinico-biologic la pacientul cu  cancer de tiroida anaplazice  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_455', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 385) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(385,'Diagnosticul cancerului ovarian, falopian si peritoneal primar/ tumorilor ovariene borderline/cancerelor ovariene particulare  - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_456', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 386) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(386,'Evaluarea extensiei reale a  cancerului  ovarian, falopian si peritoneal primar/ tumorilor ovariene borderline   - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_457', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 387) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(387,'Evaluarea statusului clinico-biologic la pacienta cu  cancer  ovarian, falopian ?i peritoneal primar/ tumorilor ovariene borderline/cancer ovarian particular  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_458', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 388) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(388,'Evaluarea extensiei reale a  cancerelor ovariene particulare  - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_459', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 389) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(389,'Diagnosticul melanomului malign cutanat/ melanomului malign al mucoasei - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_460', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 390) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(390,'Evaluarea extensiei reale a pacientului cu melanom malign cutanat/ melanom malign al mucoasei  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_461', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 391) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(391,'Evaluarea extensiei reale a pacientului cu melanom malign cutanat/ melanom malign al mucoasei cu localizare la nivelul membrelor superioare/inferioare - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_462', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 392) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(392,'Evaluarea statusului clinico-biologic la pacientul cu melanom malign cutanat/ melanom malign al mucoasei - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_463', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 393) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(393,'Diagnosticul melanomului malign coroidian - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_464', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 394) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(394,'Evaluarea extensiei melanomului malign coroidian  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_465', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 395) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(395,'Evaluarea statusului clinico-biologic la pacientul cu melanom malign coroidian - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_466', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 396) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(396,'Diagnosticul cancerelor cutanate (non-melanom)  - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_467', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 397) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(397,'Evaluarea extensiei cancerelor cutanate (non-melanom)  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_468', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 398) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(398,'Evaluarea statusului clinico-biologic la pacientul cu  cancer cutanat (non-melanom) - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_469', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 399) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(399,'Diagnosticul cancerului esofagian inferior/ cancerului esofagian inalt  - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_470', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 400) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(400,'Evaluarea extensiei reale a  cancerului esofagian inferior - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_471', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 401) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(401,'Evaluarea statusului clinico-biologic la pacientul cu   cancer esofagian inferior/ cancer esofagian inferior  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_472', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 402) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(402,'Evaluarea extensiei reale a  cancerului esofagian inalt - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_473', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 403) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(403,'Diagnosticul tumorilor vulvare/vaginale - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_474', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 404) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(404,'Evaluarea extensiei reale a  cancerului vulvar/vaginale  - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_475', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 405) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(405,'Evaluarea statusului clinico-biologic al pacientei cu   cancer vulvar/vaginal - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacienta, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_476', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 406) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(406,'Diagnosticul cancerului testicular  - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_477', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 407) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(407,'Evaluarea statusului clinico-biologic al pacientului cu cancer  testicular, tip seminom pur/ cancer  testicular  non-seminomatos - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_478', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 408) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(408,'Diagnosticul sarcoamelor de parai moi de trunchi ?i extremitaai/ tumorilor desmoide/ condrosarcoamelor/osteosarcoamelor  - se deconteaza maxim un serviciu/an/pacient  include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_479', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 409) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(409,'Evaluarea statusului clinico-biologic la pacientul cu  sarcom de parai moi de trunchi ?i extremitaai/cu  tumori desmoide/cu  condrosarcom/cu osteosarcom - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_480', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 410) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(410,'Diagnosticul tumorilor stromale gastrointestinale (GIST)  - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_481', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 411) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(411,'Evaluarea statusului clinico-biologic la pacientul cu tumora stromala gastrointestinala (GIST) - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_482', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 412) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(412,'Diagnosticul cancerului penian   - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_483', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 413) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(413,'Evaluarea statusului clinico-biologic la pacientul cu cancer penian - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_484', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 414) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(414,'Diagnosticul cancerului de intestin subaire - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_485', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 415) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(415,'Evaluarea statusului clinico-biologic la pacientul cu  cancer de intestin subaire - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_486', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 416) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(416,'Diagnosticul cancerului canalului anal  - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_487', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 417) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(417,'Evaluarea extensiei reale a  cancerului canalului anal  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_488', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 418) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(418,'Evaluarea statusului clinico-biologic la pacientul cu  cancer de canal anal - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_489', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 419) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(419,'Diagnosticul cancerului suprarenalian  - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_490', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 420) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(420,'Evaluarea statusului clinico-biologic la pacientul cu  cancer suprarenalian - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_491', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 421) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(421,'Diagnosticul  mezoteliomului pleural   - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_492', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 422) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(422,'Evaluarea extensiei reale a mezoteliomului pleural  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_493', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 423) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(423,'Evaluarea statusului clinico-biologic la pacientul cu   mezoteliom pleural malign  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_494', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 424) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(424,'Diagnosticul mezoteliomului peritoneal - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_495', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 425) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(425,'Evaluarea extensiei  mezoteliomului peritoneal  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_496', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 426) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(426,'Evaluarea statusului clinico-biologic al pacienailor cu  mezoteliom peritoneal malign  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_497', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 427) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(427,'Diagnosticul metastazelor hepatice cu punct de plecare neprecizat  - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_498', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 428) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(428,'Diagnosticul metastazelor pulmonare cu punct de plecare neprecizat  - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_499', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 429) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(429,'Diagnosticul metastazelor ganglionare cu punct de plecare neprecizat - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_500', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 430) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(430,'Diagnosticul limfoamelor - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_501', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 431) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(431,'Evaluarea extensiei  limfoamelor  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_502', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 432) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(432,'Evaluarea statusului clinico-biologic al pacienailor cu  limfom  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_503', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 433) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(433,'Monitorizarea evoluaiei limfoamelor - se deconteaza maxim 4 servicii/an/pacient', NULL, 0, 0,'B.4.1','SPT_504', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 434) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(434,'Evaluarea raspunsului complet dupa tratament pentru limfoame - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_505', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 435) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(435,'Diagnosticul leucemiei limfatice cronice - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_506', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 436) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(436,'Evaluarea extensiei  leucemiei limfatice cronice  - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_507', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 437) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(437,'Evaluarea statusului clinico-biologic al pacienailor cu  leucemie limfatica cronica  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_508', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 438) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(438,'Monitorizarea evoluaiei leucemiei limfatice cronice - se deconteaza maxim 2 servicii/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_509', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 439) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(439,'Evaluarea raspunsului dupa tratament pentru leucemie limfatica cronica - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_510', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 440) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(440,'Diagnosticul sindroamelor mieloproliferative cronice - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_511', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 441) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(441,'Evaluarea statusului clinico-biologic al pacienailor cu  sindrom mieloproliferativ cronic  - in vederea stabilirii strategiei de tratament de catre comisia multidisciplinara - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului', NULL, 0, 0,'B.4.1','SPT_512', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 442) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(442,'Monitorizarea evoluaiei sindroamelor mieloproliferative cronice - se deconteaza maxim 2 servicii/an/pacient', NULL, 0, 0,'B.4.1','SPT_513', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 443) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(443,'Evaluarea raspunsului dupa tratament pentru sindroame mieloproliferative cronice - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa deaina o evidenaa cantitativa privind intrarile ?i consumul corelat cu serviciile medicale raportate', NULL, 0, 0,'B.4.1','SPT_514', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 444) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(444,'Degenerescenta grasoasa a ficatului, neclasificata altundeva – diagnostic si monitorizare - se deconteaza trei servicii/pacient/an', NULL, 0, 0,'B.4.1','SPT_515', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 445) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(445,'Ecografie cu substanta de contrast  pentru diagnosticul formatiunilor tumorale hepatice - se deconteaza un serviciu/pacient/an', NULL, 0, 0,'B.4.1','SPT_516', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 446) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(446,'Endoscopia digestiva superioara si inferioara, cu sedare, cu biopsie - Endoscopia digestiva superioara si colonoscopia flexibila pana la cec', NULL, 0, 0,'B.4.1','SPT_329', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 447) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(447,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie 1-3 blocuri, fara hemostaza- colonoscopie flexibila pana la cec;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_310.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 448) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(448,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie 1-3 blocuri, fara hemostaza - colonoscopie flexibila pana la cec;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_311.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 449) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(449,'Endoscopie digestiva inferioara cu sedare, cu biopsie - colonoscopie flexibila pana la cec;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_312.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 450) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(450,'Endoscopie digestiva inferioara fara sedare, cu biopsie - colonoscopie flexibila pana la cec;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_313.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 451) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(451,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la flexura hepatica;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_316.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 452) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(452,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la flexura hepatica;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_317.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 453) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(453,'Endoscopie digestiva inferioara cu sedare, cu biopsie - colonoscopie flexibila pana la flexura hepatica;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_318.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 454) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(454,'Endoscopie digestiva inferioara fara sedare, cu biopsie - colonoscopie flexibila pana la flexura hepatica;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_319.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 455) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(455,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie, 1-3 blocuri, cu hemostaza - Colonoscopia flexibila pana la cec;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_320.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 456) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(456,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie, 1-3 blocuri, cu hemostaza - Colonoscopia flexibila pana la cec;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_321.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 457) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(457,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie, 4-6 blocuri, fara hemostaza - Colonoscopia flexibila pana la cec;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_322.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 458) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(458,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie, 4-6 blocuri, fara hemostaza - Colonoscopia flexibila pana la cec;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_323.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 459) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(459,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie, 4-6 blocuri, cu hemostaza - Colonoscopia flexibila pana la cec;Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_324.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 460) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(460,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie, 4-6 blocuri, cu hemostaza - Colonoscopia flexibila pana la cec Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_325.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 461) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(461,'Endoscopia digestiva superioara si inferioara, fara sedare, cu biopsie - Endoscopia digestiva superioara si colonoscopia flexibila pana la cec Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_328.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 462) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(462,'Endoscopia digestiva superioara si inferioara, cu sedare, cu biopsie - Endoscopia digestiva superioara si colonoscopia flexibila pana la cec Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_329.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 463) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(463,'Ecoendoscopie cu sedare, cu biopsie - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale  raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_330.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 464) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(464,'Diagnosticul mielomului multiplu, amiloidozei tip lant usor, macroglobulinemiei Waldenstrom, bolii de depozitare a lanturilor usoare, gamapatiei monoclonale cu etiologie neprecizata - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_386.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 465) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(465,'Evaluarea raspunsului complet dupa tratament pentru mielomul multiplu, amiloidoza tip lant usor, macroglobulinemia Waldenstrom, boala de depozitare a lanturilor usoare - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_389.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 466) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(466,'Diagnosticul Cancerului Colo-rectal - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate  Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_392.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 467) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(467,'Diagnosticul cancerului mamar cu punctie biopsie ghidata ecografic cu marcaj - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_397.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 468) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(468,'Diagnosticul cancerului mamar cu mamografie cu tomosinteza si punctie biopsie ghidata ecografic cu marcaj - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_398.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 469) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(469,'Diagnosticul cancerului mamar cu punctie biopsie mamara cu vacuum - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate  Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_400.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 470) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(470,'Diagnosticul cancerului mamar cu mamografie cu tomosinteza si punctie biopsie mamara cu vacuum - se deconteaza maxim un serviciu/an/pacienta - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate  Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_401.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 471) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(471,'Diagnosticul Cancerului de prostata – Adenocarcinom/cu diferentiere neuroendocrina/ carcinom neuroendocrin - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_404.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 472) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(472,'Diagnosticul Cancerului bronho-pulmonar cu celula mica/fara celula mica scuamos (carcinom fara celula mica scuamos)/fara celula mica non-scuamos (carcinom fara celula mica non-scuamos) - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_406.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 473) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(473,'Evaluarea extensiei reale a Cancerului bronho-pulmonar fara celula mica scuamos (carcinom fara celula mica scuamos) stadiu nonmetastatic - se deconteaza maxim un serviciu/an/pacient, ulterior diagnosticului - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_409.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 474) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(474,'Diagnosticul Cancerului de col uterin - se deconteaza maxim un serviciu/an/pacienta; Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_412.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 475) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(475,'Diagnosticul  cancerului gastric si de jonctiune gastro-esofagiana - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate; Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_420.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 476) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(476,'Diagnosticul limfomului gastric tip MALT/ limfomului malign non-Hodgkin gastric non-MALT - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate; Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_423.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 477) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(477,'Diagnosticul cancerului hepatocelular - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate; Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_425.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 478) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(478,'Diagnosticul ampulomului vaterian - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate; Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_428.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 479) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(479,'Diagnosticul cancerului pancreatic - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_431.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 480) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(480,'Diagnosticul tumorilor neuroendocrine pancreatice - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_434.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 481) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(481,'Diagnosticul cancerului endometrial/ cancerelor corpului uterin  - se deconteaza maxim un serviciu/an/pacienta- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate - Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_440.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 482) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(482,'Diagnosticul cancerelor de cavitate orala/orofaringe/ cancerelor de hipofaringe/ cancerelor de laringe/ cancerelor de nazofaringe - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate - Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_443.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 483) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(483,'Diagnosticul cancerelor de parotida/de glande salivare - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_446.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 484) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(484,'Diagnosticul cancerului tiroidian papilar/ cancerului tiroidian folicular/ cancerului tiroidian oncocitic - se deconteaza maxim un serviciu/an/CNP- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_449.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 485) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(485,'Diagnosticul cancerului tiroidian medular - se deconteaza maxim un serviciu/an/CNP- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_451.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 486) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(486,'Diagnosticul cancerelor de tiroida anaplazice - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_454.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 487) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(487,'Diagnosticul melanomului malign cutanat/ melanomului malign al mucoasei - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_460.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 488) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(488,'Diagnosticul cancerelor cutanate (non-melanom)  - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_467.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 489) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(489,'Diagnosticul cancerului esofagian inferior/ cancerului esofagian înalt  - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_470.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 490) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(490,'Diagnosticul tumorilor vulvare/vaginale - se deconteaza maxim un serviciu/an/pacienta- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_474.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 491) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(491,'Diagnosticul sarcoamelor de parti moi de trunchi si extremitati/ tumorilor desmoide/ condrosarcoamelor/osteosarcoamelor  - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_479.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 492) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(492,'Diagnosticul cancerului penian   - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_483.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 493) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(493,'Diagnosticul cancerului canalului anal  - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_487.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 494) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(494,'Diagnosticul  mezoteliomului pleural   - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_492.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 495) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(495,'Diagnosticul metastazelor hepatice cu punct de plecare neprecizat  - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_498.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 496) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(496,'Diagnosticul metastazelor pulmonare cu punct de plecare neprecizat  - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_499.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 497) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(497,'Diagnosticul metastazelor ganglionare cu punct de plecare neprecizat - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_500.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 498) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(498,'Diagnosticul limfoamelor - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_501.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 499) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(499,'Evaluarea raspunsului complet dupa tratament pentru limfoame - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_505.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 500) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(500,'Diagnosticul leucemiei limfatice cronice - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_506.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 501) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(501,'Evaluarea raspunsului dupa tratament pentru leucemie limfatica cronica - se deconteaza maxim un serviciu/an/pacient - include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_510.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 502) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(502,'Diagnosticul sindroamelor mieloproliferative cronice - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_511.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 503) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(503,'Evaluarea raspunsului dupa tratament pentru sindroame mieloproliferative cronice - se deconteaza maxim un serviciu/an/pacient- include kitul de recoltare, pentru care furnizorul trebuie sa detina o evidenta cantitativa privind intrarile si consumul corelat cu serviciile medicale raportate- Cu examinare imunohistochimica', NULL, 0, 0,'B.4.1','SPT_514.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 504) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(504,'Depistarea si diagnosticarea precoce a leziunilor displazice ale colului uterin ( Cu recoltare material celular cervico-vaginal de Med. Fam. sau Med. specialist)', NULL, 0, 0,'B.4.2','SPT_174.1', NULL, '2024-07-01')
if not exists (select * from ListaTipServicii where IdTipServiciu = 505) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  VALUES(505,'Depistarea si diagnosticarea precoce a leziunilor displazice ale colului uterin cu examen citologic (Serviciile de consiliere si recolt/testare inclusiv de catre unit medicale mob/caravane medicale); (Depistarea si diagnosticarea precoce a leziunilor displazice ale colului uterin cu examen citologic (Serviciile de consiliere si recolt/testare inclusiv de catre unit medicale mob/caravane medicale). ( Cu recoltare material celular cervico-vaginal de Med. Fam. sau Med. specialist)', NULL, 0, 0,'B.4.2','SPT_175.1', NULL, '2024-07-01')

update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)

print '1.34 - Modificare ListaTipServicii - OK'

if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 219) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (219,'Consultatie de specialitate medicina interna')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 220) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (220,'Ig A')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 221) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (221,'Dozare Free Kappa din ser')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 222) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (222,'Dozare Free Lambda din ser')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 223) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (223,'Dozare Kappa si Lambda din urina imunofixarea proteinelor urinare')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 224) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (224,'Biopsie osteomedulara')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 225) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (225,'Punctie aspirativa de maduva osoasa')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 226) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (226,'Beta 2 microglobulina')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 227) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (227,'CTLF')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 228) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (228,'Proteinurie (24 de ore)')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 229) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (229,'Citodiagnostic aspirat')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 230) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (230,'Examen histopatologic procedura completa HE si coloratii speciale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 231) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (231,'CT whole body low dose')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 232) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (232,'Consultatie de specialitate hematologie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 233) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (233,'Electroforeza proteinelor serice cu Imunofixare proteinelor serice')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 234) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (234,'Imunofixarea proteinelor urinare')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 235) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (235,'Endoscopie digestiva inferioara cu biopsia formatiunii tumorale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 236) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (236,'CT-ABDOMEN nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 237) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (237,'CA 19-9')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 238) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (238,'Antigen carcinoembrionar (ACE)')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 239) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (239,'Consultatie de specialitate oncologie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 240) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (240,'Polipectomie cu hemostaza')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 241) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (241,'Consultatie de specialitate chirurgicala')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 242) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (242,'Examen histopatologic procedura completa HE (4 - 6 blocuri)')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 243) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (243,'Endoscopia digestiva superioara')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 244) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (244,'Ecoendoscopie cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 245) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (245,'RMN pelvis nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 246) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (246,'CT-TORACE nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 247) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (247,'Consultatie de specialitate radioterapie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 248) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (248,'Ag HBs')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 249) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (249,'Ac anti HCV')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 250) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (250,'Ac anti HBc')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 251) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (251,'CT pelvis nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 252) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (252,'CT regiune cervicala nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 253) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (253,'Ecografie ganglionara')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 254) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (254,'Punctie biopsie ganglionara sub ghidaj ecografic')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 255) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (255,'Consultatie de specialitate pneumologie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 256) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (256,'Biopsia percutanata a formatiunii tumorale hepatice')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 257) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (257,'CA 15-3')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 258) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (258,'Punctie biopsie percutanat transtoracica sub ghidaj CT')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 259) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (259,'Punctie biopsie hepatica sub ghidaj ecografic')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 260) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (260,'Consultatie de specialitate urologie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 261) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (261,'CA-125')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 262) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (262,'RMN multiparametric prostata 3 T')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 263) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (263,'SCC (antigen tumoral cancer celule scuamoase)')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 264) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (264,'Ecografie transrectala')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 265) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (265,'Punctie prostatica cu biopsia formatiunii tumorale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 266) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (266,'PSA')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 267) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (267,'Paracenteza diagnostica')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 268) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (268,'Consultatie de specialitate chirurgie toracica')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 269) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (269,'CT torace cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 270) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (270,'Bronhoscopie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 271) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (271,'Biopsie transbronsica')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 272) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (272,'Biopsie transtoracica')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 273) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (273,'Free T3 (FT3)')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 274) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (274,'RMN cranio-cerebral cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 275) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (275,'Punctie pleurala (toracenteza)')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 276) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (276,'RMN-ABDOMEN nativ si cu substanta contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 277) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (277,'Consultatie de specialitate endocrinologie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 278) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (278,'Biopsie pleurala')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 279) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (279,'Serotonina')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 280) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (280,'Cromogranina A')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 281) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (281,'Cortizol')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 282) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (282,'Acid 5-hidroxi-indolacetic')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 283) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (283,'ACTH')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 284) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (284,'Testare HIV')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 285) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (285,'Anoscopie/Examinare digitala')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 286) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (286,'Urocultura')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 287) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (287,'Biopsia formatiunii tumorale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 288) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (288,'Consultatie de specialitate ortopedie si traumatologie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 289) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (289,'chiuretaj bioptic al formatiunii tumorale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 291) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (291,'Consultatie de specialitate ORL/BMF')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 292) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (292,'Fibroscopie cu biopsia formatiunii tumorale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 293) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (293,'RMN gat nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 294) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (294,'CT membru afectat nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 295) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (295,'Consultatie de specialitate stomatologie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 296) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (296,'Biopsie prin tehnici adecvate localizarii')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 297) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (297,'Punctie cu biopsia formatiunii tumorale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 298) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (298,'BetaHCG')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 299) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (299,'CT gat nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 300) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (300,'CT cap nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 301) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (301,'Biopsie ganglioni mediastinali (EBUS / EUS)')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 302) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (302,'Ecografie scrotala')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 303) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (303,'CT pelvis cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 304) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (304,'Ecografie tiroidiana cu biopsia formatiunii tumorale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 305) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (305,'T3')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 306) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (306,'Ecografie transvaginala')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 307) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (307,'Tiroglobulina')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 308) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (308,'Evaluare nutritionala cu Consiliere nutritionala / stome de alimentatie / stentare esofagiana')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 309) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (309,'Ecografie cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 310) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (310,'Anticorpi antitireoglobulina')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 311) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (311,'Cistoscopie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 312) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (312,'Rectoscopie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 313) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (313,'Calcitonina')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 314) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (314,'Fibrotest')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 315) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (315,'Eritropoetina serica')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 316) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (316,'Gazometrie sanguina')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 317) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (317,'Ureteroscopie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 318) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (318,'Consultatie de specialitate nefrologie')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 319) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (319,'Endoscopie digestiva superioara cu biopsia formatiunii tumorale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 320) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (320,'Consultatie de specialitate chirurgie plastica')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 321) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (321,'Elastografie regiuni ganglionare regionale')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 322) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (322,'Biopsie excizionala')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 323) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (323,'Tomografie in coerenta optica')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 324) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (324,'CT craniu nativ si cu substanta de contrast')
if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 325) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (325,'Biopsie incizionala')

update ListaTipServiciiCerinte
set DataValabilitate = '2024-06-30',
	DenTipServiciuCerintaCalculata = DenTipServiciuCerinta + ' -- ' + (case when DataValabilitate is null then 'NA' else convert(varchar, DataValabilitate, 103) end)
where IdTipServiciuCerinta = 158

update ListaTipServiciiCerinte
set DenTipServiciuCerinta = 'eRFG (estimarea ratei de filtrare glomerulara)'
where IdTipServiciuCerinta = 142

update ListaTipServiciiCerinte
set DenTipServiciuCerintaCalculata = DenTipServiciuCerinta + ' -- ' + (case when DataValabilitate is null then 'NA' else convert(varchar, DataValabilitate, 103) end)

print '1.34 - Modificare ListaTipServiciiCerinte - OK'

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 287) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(287,'91,219,102,41,106,111,105,204,100')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 288) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(288,'91,219,41,106,111,105,100')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 289) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(289,'91,219,102,41,106,111,105,204,100,108,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 290) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(290,'91,219,41,106,111,105,100,108,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 291) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(291,'91,219,102,41,106,111,105,204,100,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 292) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(292,'91,219,41,106,111,105,100,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 293) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(293,'91,219,102,41,106,111,105,204,101')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 294) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(294,'91,219,41,106,111,105,101')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 295) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(295,'91,219,102,41,106,111,105,204,101,108,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 296) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(296,'91,219,41,106,111,105,101,108,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 297) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(297,'91,219,102,41,106,111,105,204,101,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 298) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(298,'91,219,41,106,111,105,101,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 299) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(299,'91,219,102,41,106,111,105,204,100,240,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 300) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(300,'91,219,102,41,106,111,105,204,244,60,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 301) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(301,'91,219,102,41,106,111,105,204,244')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 302) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(302,'91,219,41,106,111,105,100,240,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 303) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(303,'91,219,102,41,106,111,105,204,100,108,242')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 304) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(304,'91,219,41,106,111,105,100,108,242')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 305) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(305,'91,219,102,41,106,111,105,204,100,240,242')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 306) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(306,'91,219,41,106,111,105,100,240,242')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 307) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(307,'91,219,41,106,111,105,243,100')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 308) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(308,'91,219,102,41,106,111,105,204,243,100')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 309) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(309,'91,219,41,106,111,105,243,100,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 310) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(310,'41,34,227,109,38,19,89,111,99,82,7,53,54,180,241,93,105,29,102')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 311) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(311,'41,34,110,109,38,19,89,111,99,82,7,53,54,180,241,93,105,29,102')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 312) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(312,'41,34,227,109,38,19,89,111,99,82,7,53,54,180,241,93,105,29,102,112')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 313) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(313,'41,34,110,109,38,19,89,111,99,82,7,53,54,180,241,93,105,29,102,112')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 314) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(314,'41,34,227,109,38,19,89,111,99,82,7,53,54,180,241,93,105,29,102,181')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 315) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(315,'41,34,110,109,38,19,89,111,99,82,7,53,54,180,241,93,105,29,102,181')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 316) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(316,'232,233,220,186,185,221,222,223,224,225,41,43,99,177,105,142,19,82,7,226,161,228,229,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 317) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(317,'231,232,43,99')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 318) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(318,'232,202,220,186,185,221,222,225,41,43,99,177,142,19,82,7,53,54,37,36,226,161,228,229')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 319) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(319,'232,233,234,220,186,185,221,222,224,105,41,43,99,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 320) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(320,'232,202,220,186,185,221,222,177,142,19,7,82,226,161,228')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 321) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(321,'91,219,41,51,48,45,34,142,19,43')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 322) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(322,'91,219,102,204,235,41,105,43,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 323) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(323,'236,251,246,237,238,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 324) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(324,'91,219,93,95,239,41,38,53,54,37,19,142,248,249,250,12,161,36,48,45,202,29,51,34,169')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 325) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(325,'236,245,246,237,238,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 326) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(326,'91,219,93,95,247,41,38,53,54,37,19,142,248,249,250,12,161,36,48,45,202,29,51,34,169')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 327) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(327,'94,95,127,73,123,43,41,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 328) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(328,'94,95,127,121,73,123,43,41,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 329) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(329,'94,95,127,73,124,43,41,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 330) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(330,'94,95,127,121,73,124,43,41,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 331) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(331,'236,251,246,257,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 332) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(332,'93,95,94,239,247,38,37,53,54,19,142,248,249,250,161,36,48,45,12,202,29,51,34')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 333) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(333,'260,262,264,265,105,43,19,142,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 334) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(334,'93,247,260,239,266,41,38,111,53,54,37,248,249,250,161,36,48,45,12,202,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 335) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(335,'255,102,269,270,271,272,41,43,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 336) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(336,'236,251,246,274,275,15,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 337) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(337,'236,251,246,274,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 338) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(338,'236,251,246,301,239,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 339) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(339,'236,251,246,275,15,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 340) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(340,'247,268,239,93,255,38,53,54,37,19,142,248,249,250,88,273,191,12,161,36,48,45,202,29,51,34')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 341) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(341,'94,239,104,60,41,105,43,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 342) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(342,'236,251,246,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 343) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(343,'236,251,246,311,312,102,204,239,263,238,261')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 344) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(344,'93,239,247,95,38,53,54,37,19,142,248,249,250,161,12,36,48,45,202,29,51,34')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 345) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(345,'260,102,239,204,27,311,105,77,41,19,142,160,286,43')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 346) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(346,'260,239,102,204,27,317,105,77,41,19,142,160,286,43')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 347) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(347,'236,251,246,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 348) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(348,'260,239,93,318,38,53,54,37,248,249,250,19,142,89,161,36,48,45,12,202,29,51,34')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 349) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(349,'91,219,239,102,204,319,41,105,51,34,43,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 350) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(350,'236,251,246,237,238,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 351) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(351,'95,93,239,38,53,54,37,19,142,248,249,250,161,36,48,45,12,202,29,169')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 352) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(352,'91,219,239,232,102,204,319,41,105,43,51,34,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 353) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(353,'91,93,232,239,38,53,54,37,19,142,248,249,250,161,36,12,48,45,202,29,169')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 354) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(354,'91,219,239,102,204,243,256,179,248,249,250,12,11,36,37,41,38,202,19,142,53,54,105,43,58,237,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 355) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(355,'236,251,246,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 356) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(356,'95,93,239,41,161,192,48,45,12,248,250,249,29,169')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 357) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(357,'91,239,102,204,243,60,41,43,36,12,11,34,51,37,19,142,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 358) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(358,'239,236,251,246,237')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 359) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(359,'241,93,239,91,38,53,54,12,202,248,250,249,29,169')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 360) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(360,'91,239,102,204,244,60,20,41,38,43,19,142,53,54,191,178,237,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 361) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(361,'276,246,238,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 362) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(362,'241,239,93,247,37,19,142,161,36,48,45,12,202,29,248,250,249,169')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 363) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(363,'91,277,239,102,204,105,43,244,60,20,41,38,19,142,53,54,191,178,279,280,282,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 364) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(364,'276,251,246,279,280,282,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 365) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(365,'241,93,277,239,248,250,249,37,161,36,48,45,12,202,29,169')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 366) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(366,'260,239,41,19,142,160,286,179')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 367) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(367,'239,236,251,246')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 368) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(368,'260,239,93,38,105,29,43,51,34,53,54,161,248,250,249,36,48,45,12,202')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 369) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(369,'94,239,102,204,287,289,41,105,43,19,142,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 370) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(370,'236,245,246,261,238,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 371) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(371,'241,93,239,38,106,53,54,37,161,248,250,249,36,48,45,12,202,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 372) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(372,'291,239,292,41,43,105,19,142,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 373) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(373,'157,293,246,236,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 374) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(374,'241,247,295,93,291,239,38,53,54,37,161,248,250,249,36,48,45,12,202,7,88,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 375) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(375,'291,239,297,41,38,43,105,19,142,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 376) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(376,'239,246,236,299,300')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 377) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(377,'291,239,247,295,93,53,54,37,161,36,48,45,12,202,7,88,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 378) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(378,'277,239,304,41,43,19,142,88,305,172,307,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 379) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(379,'241,277,239,93,53,54,37,161,36,48,45,12,202,88,310,172,29,307')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 380) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(380,'277,239,304,41,38,19,142,88,313,238,43,105,172,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 381) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(381,'236,299,246,313,238,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 382) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(382,'241,277,239,93,53,54,37,161,36,48,45,12,202,88,305,172,313,238,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 383) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(383,'277,239,252,236,246,304,41,38,43,105,19,142,88,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 384) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(384,'241,277,93,247,239,53,54,37,161,36,48,45,12,202,7,273,172,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 385) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(385,'94,239,306,267,15,43,41,105')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 386) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(386,'236,251,246,261,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 387) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(387,'241,94,93,239,38,248,250,249,53,54,37,19,142,161,36,48,45,12,202,105,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 388) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(388,'236,251,246,261,58,298,177,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 389) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(389,'184,320,322,325,287,230,41,38,105,43,19,142')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 390) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(390,'239,324,246,236,251')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 391) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(391,'239,294,324,246,236,251')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 392) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(392,'320,184,239,93,53,54,37,248,250,249,161,36,48,45,12,202,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 393) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(393,'183,239,323,41,38,19,142')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 394) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(394,'239,299,246,236,157')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 395) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(395,'183,239,93,105,29,43,53,54,161,36,48,45,12,202')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 396) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(396,'184,320,287,322,230,41,38,19,142,43,105')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 397) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(397,'239,246,236,321')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 398) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(398,'184,320,93,239,53,54,37,248,250,249,161,36,48,45,12,202,105,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 399) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(399,'91,219,239,102,204,243,287,230,41,43,105,19,142')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 400) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(400,'236,251,246,238,237,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 401) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(401,'241,93,239,247,91,219,38,53,54,37,161,36,48,45,12,202,29,308')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 402) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(402,'236,299,246,263,239,291')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 403) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(403,'94,287,230,41,43,105,19,142')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 404) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(404,'236,251,246,263,238,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 405) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(405,'241,94,93,247,38,161,36,48,45,12,202,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 406) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(406,'260,239,298,58,177,119,302,20,303,43,41,19,142')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 407) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(407,'260,239,93,29,38,53,54,37,248,250,249,161,36,48,45,12,202')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 408) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(408,'241,288,239,247,246,294,296,230,41,43,19,142,105')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 409) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(409,'241,288,239,247,93,29,38,53,54,37,161,36,48,45,12,202')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 410) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(410,'91,239,236,251,243,105,41,19,142')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 411) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(411,'241,91,93,239,38,53,54,37,248,250,249,161,36,48,45,12,202,29,169')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 412) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(412,'260,239,41,19,142,287,105,43,102,204,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 413) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(413,'260,239,93,247,38,53,54,37,161,36,48,45,12,202,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 414) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(414,'91,239,243,236,241,41,19,142,237,238,105')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 415) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(415,'241,93,239,91,38,43,53,54,37,161,248,250,249,36,48,45,12,202,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 416) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(416,'241,239,285,287,230,41,43,19,142,105')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 417) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(417,'239,236,251,246,263')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 418) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(418,'95,239,93,247,38,53,54,37,161,36,48,45,12,202,284,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 419) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(419,'260,239,179,236,41,38,19,142,277')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 420) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(420,'241,93,277,239,43,53,54,37,161,36,48,45,12,202,281,283,105,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 421) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(421,'255,239,246,275,278,230,43,105,41,19,142')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 422) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(422,'239,236,251,246')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 423) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(423,'268,255,239,93,248,250,249,191,88,53,54,37,161,273,36,48,45,12,202,29,156')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 424) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(424,'91,219,239,95,267,15,41,43,105,19,142')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 425) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(425,'236,251,246,261,239')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 426) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(426,'95,91,219,239,93,38,53,54,37,248,250,249,161,36,48,45,12,202,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 427) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(427,'91,219,239,179,259,41,43,105,230,238,261,263')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 428) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(428,'255,219,239,94,91,246,258,41,43,105,19,142,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 429) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(429,'241,239,253,254,41,43,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 430) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(430,'232,224,105,41,77,189,43,99,19,142,89,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 431) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(431,'236,251,246,252,232')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 432) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(432,'232,93,177,226,82,38,53,54,37,12,248,250,249,284,36,202,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 433) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(433,'232,41,177,19,142,161,53,54,4,57,38')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 434) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(434,'232,224,41,43,99,177,19,142,161,105,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 435) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(435,'232,224,105,41,77,189,43,99,177,19,142,226,161,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 436) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(436,'20,303,269,232')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 437) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(437,'232,93,38,53,54,248,250,249,36,82,202,186,220,185,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 438) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(438,'232,105,41,177,19,142,4,57,226,161,179')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 439) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(439,'232,224,105,41,77,189,43,99,19,142,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 440) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(440,'232,224,105,41,77,189,43,99,19,142,230,315,316,179')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 441) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(441,'232,93,38,53,54,177,248,249,36,29')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 442) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(442,'232,105,41,77,189,177,19,142,53,54,4,57')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 443) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(443,'232,224,105,41,77,189,43,99,177,19,142,230')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 444) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(444,'91,41,43,53,54,37,36,18,46,38,12,11,19,4,57,55,34,40,58,202,314,27')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 445) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(445,'91,219,41,111,105,309')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 446) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(446,'91,219,102,41,106,111,105,204,243,100,113')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 447) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(447,'91,219,102,41,106,111,105,204,100,108,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 448) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(448,'91,219,41,106,111,105,100,108,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 449) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(449,'91,219,102,41,106,111,105,204,100,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 450) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(450,'91,219,41,106,111,105,100,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 451) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(451,'91,219,102,41,106,111,105,204,101,108,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 452) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(452,'91,219,41,106,111,105,101,108,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 453) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(453,'91,219,102,41,106,111,105,204,101,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 454) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(454,'91,219,41,106,111,105,101,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 455) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(455,'91,219,102,41,106,111,105,204,100,240,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 456) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(456,'91,219,41,106,111,105,100,240,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 457) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(457,'91,219,102,41,106,111,105,204,100,108,242,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 458) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(458,'91,219,41,106,111,105,100,108,242,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 459) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(459,'91,219,102,41,106,111,105,204,100,240,242,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 460) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(460,'91,219,41,106,111,105,100,240,242,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 461) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(461,'91,219,41,106,111,105,243,100,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 462) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(462,'91,219,102,41,106,111,105,204,243,100,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 463) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(463,'91,219,102,41,106,111,105,204,244,60,113,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 464) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(464,'232,233,220,186,185,221,222,223,224,225,41,43,99,177,105,142,19,82,7,226,161,228,229,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 465) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(465,'232,233,234,220,186,185,221,222,224,105,41,43,99,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 466) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(466,'91,219,102,204,235,41,105,43,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 467) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(467,'94,95,127,73,123,43,41,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 468) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(468,'94,95,127,121,73,123,43,41,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 469) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(469,'94,95,127,73,124,43,41,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 470) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(470,'94,95,127,121,73,124,43,41,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 471) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(471,'260,262,264,265,105,43,19,142,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 472) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(472,'255,102,269,270,271,272,41,43,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 473) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(473,'236,251,246,301,239,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 474) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(474,'94,239,104,60,41,105,43,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 475) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(475,'91,219,239,102,204,319,41,105,51,34,43,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 476) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(476,'91,219,239,232,102,204,319,41,105,43,51,34,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 477) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(477,'91,219,239,102,204,243,256,179,248,249,250,12,11,36,37,41,38,202,19,142,53,54,105,43,58,237,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 478) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(478,'91,239,102,204,243,60,41,43,36,12,11,34,51,37,19,142,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 479) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(479,'91,239,102,204,244,60,20,41,38,43,19,142,53,54,191,178,237,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 480) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(480,'91,277,239,102,204,105,43,244,60,20,41,38,19,142,53,54,191,178,279,280,282,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 481) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(481,'94,239,102,204,287,289,41,105,43,19,142,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 482) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(482,'291,239,292,41,43,105,19,142,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 483) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(483,'291,239,297,41,38,43,105,19,142,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 484) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(484,'277,239,304,41,43,19,142,88,305,172,307,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 485) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(485,'277,239,304,41,38,19,142,88,313,238,43,105,172,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 486) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(486,'277,239,252,236,246,304,41,38,43,105,19,142,88,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 487) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(487,'184,320,322,325,287,230,41,38,105,43,19,142,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 488) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(488,'184,320,287,322,230,41,38,19,142,43,105,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 489) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(489,'91,219,239,102,204,243,287,230,41,43,105,19,142,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 490) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(490,'94,287,230,41,43,105,19,142,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 491) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(491,'241,288,239,247,246,294,296,230,41,43,19,142,105,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 492) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(492,'260,239,41,19,142,287,105,43,102,204,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 493) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(493,'241,239,285,287,230,41,43,19,142,105,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 494) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(494,'255,239,246,275,278,230,43,105,41,19,142,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 495) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(495,'91,219,239,179,259,41,43,105,230,238,261,263,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 496) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(496,'255,219,239,94,91,246,258,41,43,105,19,142,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 497) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(497,'241,239,253,254,41,43,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 498) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(498,'232,224,105,41,77,189,43,99,19,142,89,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 499) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(499,'232,224,41,43,99,177,19,142,161,105,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 500) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(500,'232,224,105,41,77,189,43,99,177,19,142,226,161,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 501) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(501,'232,224,105,41,77,189,43,99,19,142,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 502) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(502,'232,224,105,41,77,189,43,99,19,142,230,315,316,179,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 503) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(503,'232,224,105,41,77,189,43,99,177,19,142,230,129')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 504) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(504,'64,87,94')
if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 505) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(505,'64,77,87,94')


print '1.34 - Modificare ListaTipServiciiXCerinte - OK'
------------------------------------------ End v1.34

------------------------------------------ Start v1.35

update ListaTipServicii
set DataValabilitate = NULL
where IdTipServiciu in (128, 129, 130, 131, 132, 133, 155)

update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)

print '1.35 - ListaTipServicii - OK'
------------------------------------------ End v1.35
------------------------------------------ Start v1.36
update ListaTipServicii
set DataValabilitate = '2024-08-31'
where IdTipServiciu = 29

if not exists (select * from ListaTipServicii where IdTipServiciu = 506)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])
VALUES(506,'Monitorizarea evolutiei si raspunsului la tratamentul mielomului multiplu, amiloidozei tip lant usor, macroglobulinemiei Waldenstrom, bolii de depozitare a lanturilor usoare, cu punctie aspirativa de maduva osoasa - se deconteaza maxim un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_385', NULL, '2024-09-01')

if not exists (select * from ListaTipServicii where IdTipServiciu = 507)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(507,'Brahiterapie utero-vaginala', NULL, 1, 0,'B.3.1','SPT_3.51', NULL, '2024-09-01')

if not exists (select * from ListaTipServicii where IdTipServiciu = 508)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(508,'Brahiterapie utero-vaginala si parametriala interstitiala', NULL, 1, 0,'B.3.1','SPT_3.52', NULL, '2024-09-01')

if not exists (select * from ListaTipServicii where IdTipServiciu = 509)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(509,'Brahiterapie interstitiala prostata HDR', NULL, 1, 0,'B.3.1','SPT_3.53', NULL, '2024-09-01')

if not exists (select * from ListaTipServicii where IdTipServiciu = 510)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(510,'Brahiterapie interstitiala prostata LDR', NULL, 1, 0,'B.3.1','SPT_3.54', NULL, '2024-09-01')

if not exists (select * from ListaTipServicii where IdTipServiciu = 511)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(511,'Brahiterapie interstitiala', NULL, 1, 0,'B.3.1','SPT_3.55', NULL, '2024-09-01')

if not exists (select * from ListaTipServicii where IdTipServiciu = 512)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(512,'Brahiterapie intracavitara', NULL, 1, 0,'B.3.1','SPT_3.56', NULL, '2024-09-01')

if not exists (select * from ListaTipServicii where IdTipServiciu = 513)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(513,'Brahiterapie de contact', NULL, 1, 0,'B.3.1','SPT_3.57', NULL, '2024-09-01')

update ListaTipServicii
set DenTipServiciu = 'Monitorizarea evolutiei si raspunsului la tratamentul mielomului multiplu, amiloidozei tip lant usor, macroglobulinemiei Waldenstrom, bolii de depozitare a lanturilor usoare - se deconteaza maxim 4 servicii/an/pacient'
where IdTipServiciu = 318

update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)

print '1.36 - ListaTipServicii - OK'

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 506) 
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte]) VALUES(506,'232,202,220,186,185,221,222,225,41,43,99,177,142,19,82,7,53,54,37,36,226,161,228,229')

Update ListaTipServiciuXCerinta set DataEnd = '2024-08-31'
where IdTipServiciu in (287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 302, 303, 304, 305, 306, 307, 308, 309, 446, 300, 301, 318, 344, 371, 137)
and DataStart is null

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 287 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,100,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (287 , '91,219,102,41,106,111,105,204,100,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 288 and IdsTipServiciuCerinte = '91,219,41,106,111,105,100,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (288 , '91,219,41,106,111,105,100,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 289 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,100,108,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (289 , '91,219,102,41,106,111,105,204,100,108,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 290 and IdsTipServiciuCerinte = '91,219,41,106,111,105,100,108,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (290 , '91,219,41,106,111,105,100,108,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 291 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,100,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (291 , '91,219,102,41,106,111,105,204,100,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 292 and IdsTipServiciuCerinte = '91,219,41,106,111,105,100,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (292 , '91,219,41,106,111,105,100,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 293 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,101,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (293 , '91,219,102,41,106,111,105,204,101,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 294 and IdsTipServiciuCerinte = '91,219,41,106,111,105,101,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (294 , '91,219,41,106,111,105,101,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 295 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,101,108,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (295 , '91,219,102,41,106,111,105,204,101,108,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 296 and IdsTipServiciuCerinte = '91,219,41,106,111,105,101,108,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (296 , '91,219,41,106,111,105,101,108,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 297 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,101,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (297 , '91,219,102,41,106,111,105,204,101,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 298 and IdsTipServiciuCerinte = '91,219,41,106,111,105,101,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (298 , '91,219,41,106,111,105,101,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 299 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,100,240,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (299 , '91,219,102,41,106,111,105,204,100,240,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 302 and IdsTipServiciuCerinte = '91,219,41,106,111,105,100,240,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (302 , '91,219,41,106,111,105,100,240,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 303 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,100,108,242,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (303 , '91,219,102,41,106,111,105,204,100,108,242,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 304 and IdsTipServiciuCerinte = '91,219,41,106,111,105,100,108,242,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (304 , '91,219,41,106,111,105,100,108,242,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 305 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,100,240,242,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (305 , '91,219,102,41,106,111,105,204,100,240,242,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 306 and IdsTipServiciuCerinte = '91,219,41,106,111,105,100,240,242,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (306 , '91,219,41,106,111,105,100,240,242,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 307 and IdsTipServiciuCerinte = '91,219,41,106,111,105,243,100,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (307 , '91,219,41,106,111,105,243,100,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 308 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,243,100,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (308 , '91,219,102,41,106,111,105,204,243,100,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 309 and IdsTipServiciuCerinte = '91,219,41,106,111,105,243,100,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (309 , '91,219,41,106,111,105,243,100,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 446 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,243,100,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (446 , '91,219,102,41,106,111,105,204,243,100,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 300 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,244,60,113,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (300 , '91,219,102,41,106,111,105,204,244,60,113,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 301 and IdsTipServiciuCerinte = '91,219,102,41,106,111,105,204,244,95')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (301 , '91,219,102,41,106,111,105,204,244,95', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 318 and IdsTipServiciuCerinte = '232,202,220,186,185,221,222,41,43,99,177,142,19,82,7,53,54,37,36,226,161,228')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (318 , '232,202,220,186,185,221,222,41,43,99,177,142,19,82,7,53,54,37,36,226,161,228', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 344 and IdsTipServiciuCerinte = '93,239,247,95,38,53,54,37,19,142,248,249,250,161,12,36,48,45,202,29,51,34,94')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (344 , '93,239,247,95,38,53,54,37,19,142,248,249,250,161,12,36,48,45,202,29,51,34,94', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 371 and IdsTipServiciuCerinte = '93,239,38,106,53,54,37,161,248,250,249,36,48,45,12,202,29,95,94')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (371 , '93,239,38,106,53,54,37,161,248,250,249,36,48,45,12,202,29,95,94', 'B.4.1', '2024-09-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 137 and IdsTipServiciuCerinte = '64,78,83,87,94')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (137 , '64,78,83,87,94', 'B.4.1', '2024-09-01', NULL)

print '1.36 - ListaTipServiciuXCerinta - OK'

------------------------------------------ End v1.36

------------------------------------------ Start v1.37
if not exists (select * from ListaTipServicii where IdTipServiciu = 514)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(514,'Manometrie esofagiana de inalta rezolutie - Se deconteaza maximum un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_517', NULL, '2025-03-01')

if not exists (select * from ListaTipServicii where IdTipServiciu = 515)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(515,'Manometrie anorectala de inalta rezolutie - Se deconteaza maximum un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_518', NULL, '2025-03-01')

if not exists (select * from ListaTipServicii where IdTipServiciu = 516)
INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu],[DataStart])  
VALUES(516,'pHmetrie esofagiana cu impedanta esofagiana - Se deconteaza maximum un serviciu/an/pacient', NULL, 0, 0,'B.4.1','SPT_519', NULL, '2025-03-01')

update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)

print '1.37 - ListaTipServicii - OK'

if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 326) 
INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (326,'Procedura de manometrie esofagiana de inalta rezolutie')

if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 327) 
INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (327,'Procedura de manometrie anorectala de inalta rezolutie')

if not exists(select * from ListaTipServiciiCerinte where IdTipServiciuCerinta = 328) 
INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta], [DenTipServiciuCerinta]) VALUES (328,'Procedura pHmetrie esofagiana cu impedanta esofagiana')

update ListaTipServiciiCerinte
set DenTipServiciuCerintaCalculata = DenTipServiciuCerinta + ' -- ' + (case when DataValabilitate is null then 'NA' else convert(varchar, DataValabilitate, 103) end)

print '1.37 - Modificare ListaTipServiciiCerinte - OK'

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 514 and IdsTipServiciuCerinte = '91,41,111,326')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (514, '91,41,111,326', 'B.4.1', '2025-03-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 515 and IdsTipServiciuCerinte = '91,41,111,327')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (515, '91,41,111,327', 'B.4.1', '2025-03-01', NULL)

if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu = 516 and IdsTipServiciuCerinte = '91,41,111,328')
INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu], [IdsTipServiciuCerinte], [TipLista], [DataStart], [DataEnd])
VALUES (516, '91,41,111,328', 'B.4.1', '2025-03-01', NULL)

print '1.37 - ListaTipServiciuXCerinta - OK'
------------------------------------------ End v1.37

	UPDATE DBVersion
	SET CurrentVersion = '1.37'
	print 'UPDATE DBVersion to 1.37 - OK'
	
	set nocount off
    COMMIT
END TRY
BEGIN CATCH
 print 'Eroare nr. ' + cast(ERROR_NUMBER() as varchar(50)) + ' la linia ' + cast(ERROR_LINE() as varchar(50)) + ' cu mesajul ' + ERROR_MESSAGE()
 ROLLBACK
END CATCH