﻿USE [DRGNationalDB]
GO

BEGIN TRY
	SET QUOTED_IDENTIFIER ON
    BEGIN TRANSACTION
	set nocount on

	--modificari Lista Sectii
	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id and t.name = 'ListaSectii' and c.name = 'DataExpirare')
	begin
		update ListaSectii set DataExpirare = '2017-04-01'  where CodSectie in ('1272.1','1272.2','1333')

		if not exists (select * from [dbo].[ListaSectii] where CodSectie = '1423.3')
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare]) 
		VALUES ('1423.3','Exceptie anexa 25: sectia de recuperare medicala neuropsihomotorie copii din cadrul spitalului CT11',0,'14233',NULL)

		if not exists (select * from [dbo].[ListaSectii] where CodSectie = '1423.4')
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare]) 
		VALUES ('1423.4','Exceptie anexa 25: compartimentul recuperare neuro-psiho-motorie din cadrul spitalului BH18',0,'14234',NULL)

		update [dbo].[ListaSectii] set DenSectie = 'Exceptie anexa 23C sectia de recuperare medicala neurologie din cadrul spitalului B_80'
		where CodSectie = '1393.4'
		print '1.15 - Update lista sectii - OK'
	end

	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id 
	and t.name = 'ListaCazRezolvatInterventiiChirurgicale' and c.name = 'DenCazRezolvatInterventieComplet')
	begin
		update ListaCazRezolvatInterventiiChirurgicale
		set DenCazRezolvatInterventieComplet = DenCazRezolvatInterventiiChirurgicale 
						+ case when DataValabilitate is not null then ' - ' + convert(varchar(20), ISNULL(DataValabilitate,''),103)
						  else '' end
	end

	if not exists(select * from ListaSectii where CodSectie='1393.4')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1393.4','Exceptie anexa 23C sectia clinica(IV) de recuperare medicala neurologie din cadrul spitalului B_70',0,'13934',NULL)
	end

	--vers 1.19
	if not exists(select * from ListaSectii where CodSectie='1493')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1493','Genetica medicala (acuti si cronici)',1,'1493',NULL)
	end

	print 'Update lista sectii - OK'

	--vers 1.20
	if not exists(select * from ListaAccidente where IdAccident='6')
	begin
		INSERT INTO [dbo].[ListaAccidente] ([IdAccident],[DenAccident])
		VALUES (6,'Infectie confirmata cu COVID-19')
	end

	if not exists(select * from ListaAccidente where IdAccident='7')
	begin
		INSERT INTO [dbo].[ListaAccidente] ([IdAccident],[DenAccident])
		VALUES (7,'Suspiciune/testare pentru infectie cu COVID-19, neconfirmata')
	end

	print 'Update lista accidente - OK'

	--vers 1.21
	if not exists(select * from ListaDiagnosticeClase where IdClasaDiagnostic=22)
	begin
		INSERT INTO [dbo].[ListaDiagnosticeClase] ([IdClasaDiagnostic],[DenClasaDiagnostic])
		VALUES (22,'Coduri pentru scopuri speciale')
	end
	print 'v1.21 - Update ListaDiagnosticeClase - OK'

	if not exists(select * from ListaDiagnosticeSubClase where IdSubClasaDiagnostic=274)
	begin
		INSERT INTO [dbo].[ListaDiagnosticeSubClase] ([IdSubClasaDiagnostic],[IdClasaDiagnostic],[DenSubClasaDiagnostic])
		VALUES (274,22,'Afectiuni noi, de etiologie incerta, alocate temporar sau in situatii de urgenta U00-U49')
	end
	print 'v1.21 - Update ListaDiagnosticeSubClase - OK'

	if not exists(select * from ListaDiagnostice where IdDiagnostic=15928)
	begin
		INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])
		VALUES(15928,'U07.1',274,'COVID-19, virus identificat',1,0,0,0,0,0,'U07.1 - COVID-19, virus identificat')
	end

	if not exists(select * from ListaDiagnostice where IdDiagnostic=15929)
	begin
		INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])
		VALUES(15929,'U07.2',274,'COVID-19, virus neidentificat',1,0,0,0,0,0,'U07.2 - COVID-19, virus neidentificat')
	end
	print 'v1.21 - Update ListaDiagnostice - OK'

	if not exists(select * from ListaDiagnosticeSubClase where IdSubClasaDiagnostic=275)
	begin
		INSERT INTO [dbo].[ListaDiagnosticeSubClase] ([IdSubClasaDiagnostic],[IdClasaDiagnostic],[DenSubClasaDiagnostic])
		VALUES (275,22,'Rezistenta la medicamente antimicrobiene si antineoplazice (U82-U85)')
	end
	print 'v1.22 - Update ListaDiagnosticeSubClase - OK'

	if not exists(select * from ListaDiagnostice where IdDiagnostic=15930) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15930,'U04.9',274,'Sindromul sever respirator acut [SARS], nespecificat',0,0,0,0,1,0,'U04.9 - Sindromul sever respirator acut [SARS], nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15931) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15931,'U07.0',274,'Tulburari asociate inhalarii de vapori din dispozitive electronice',0,0,0,0,1,0,'U07.0 - Tulburari asociate inhalarii de vapori din dispozitive electronice')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15932) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15932,'U08.9',274,'Istoric personal de COVID-19, nespecificat',0,0,0,0,1,0,'U08.9 - Istoric personal de COVID-19, nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15933) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15933,'U09.9',274,'Conditie (status) post-COVID-19, nespecificata',0,0,0,0,1,0,'U09.9 - Conditie (status) post-COVID-19, nespecificata')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15934) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15934,'U10.9',274,'Sindrom inflamator multisistemic asociat cu COVID-19, nespecificat',0,0,0,0,1,0,'U10.9 - Sindrom inflamator multisistemic asociat cu COVID-19, nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15935) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15935,'U11.9',274,'Necesitatea imunizarii impotriva COVID-19, nespecificata',0,0,0,0,1,0,'U11.9 - Necesitatea imunizarii impotriva COVID-19, nespecificata')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15936) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15936,'U12.9',274,'Vaccinuri anti-COVID-19 producand efecte adverse in utilizare terapeutica, nespecificate',0,0,0,0,1,0,'U12.9 - Vaccinuri anti-COVID-19 producand efecte adverse in utilizare terapeutica, nespecificate')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15937) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15937,'U82.0',275,'Rezistenta la penicilina',0,0,0,0,1,0,'U82.0 - Rezistenta la penicilina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15938) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15938,'U82.1',275,'Rezistenta la meticilina',0,0,0,0,1,0,'U82.1 - Rezistenta la meticilina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15939) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15939,'U82.2',275,'Rezistenta de tip beta-lactamaze cu spectru extins',0,0,0,0,1,0,'U82.2 - Rezistenta de tip beta-lactamaze cu spectru extins')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15940) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15940,'U82.8',275,'Rezistenta la alte beta-lactamine',0,0,0,0,1,0,'U82.8 - Rezistenta la alte beta-lactamine')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15941) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15941,'U82.9',275,'Rezistenta la beta-lactamine, nespecificate',0,0,0,0,1,0,'U82.9 - Rezistenta la beta-lactamine, nespecificate')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15942) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15942,'U83.0',275,'Rezistenta la vancomicina',0,0,0,0,1,0,'U83.0 - Rezistenta la vancomicina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15943) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15943,'U83.1',275,'Rezistenta la alte antibiotice inrudite cu vancomicina',0,0,0,0,1,0,'U83.1 - Rezistenta la alte antibiotice inrudite cu vancomicina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15944) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15944,'U83.2',275,'Rezistenta la chinolone',0,0,0,0,1,0,'U83.2 - Rezistenta la chinolone')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15945) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15945,'U83.7',275,'Rezistenta la antibiotice multiple',0,0,0,0,1,0,'U83.7 - Rezistenta la antibiotice multiple')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15946) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15946,'U83.8',275,'Rezistenta la alt antibiotic unic, specificat',0,0,0,0,1,0,'U83.8 - Rezistenta la alt antibiotic unic, specificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15947) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15947,'U83.9',275,'Rezistenta la antibiotic nespecificat',0,0,0,0,1,0,'U83.9 - Rezistenta la antibiotic nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15948) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15948,'U84.0',275,'Rezistenta la medicament(e) antiparazitare',0,0,0,0,1,0,'U84.0 - Rezistenta la medicament(e) antiparazitare')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15949) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15949,'U84.1',275,'Rezistenta la medicament(e) antifungice',0,0,0,0,1,0,'U84.1 - Rezistenta la medicament(e) antifungice')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15950) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15950,'U84.2',275,'Rezistenta la medicament(e) antivirale',0,0,0,0,1,0,'U84.2 - Rezistenta la medicament(e) antivirale')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15951) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15951,'U84.3',275,'Rezistenta la medicament(e) tuberculostatice',0,0,0,0,1,0,'U84.3 - Rezistenta la medicament(e) tuberculostatice')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15952) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15952,'U84.7',275,'Rezistenta la multiple medicamente antimicrobiene',0,0,0,0,1,0,'U84.7 - Rezistenta la multiple medicamente antimicrobiene')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15953) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15953,'U84.8 ',275,'Rezistenta la alt medicament antimicrobian specificat',0,0,0,0,1,0,'U84.8  - Rezistenta la alt medicament antimicrobian specificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15954) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15954,'U84.9',275,'Rezistenta la medicamente antimicrobiene nespecificate',0,0,0,0,1,0,'U84.9 - Rezistenta la medicamente antimicrobiene nespecificate')

	print 'v1.22 - Update ListaDiagnostice - OK'
	
	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=156))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (156
        ,'Evaluarea sindromului Post Covid-19'
        ,NULL
        ,0
        ,0
        ,'B.3.2'
        ,'SPT_191'
        ,'156 -- Evaluarea sindromului Post Covid-19 -- NA -- B.3.2')

	print 'v1.22 - Update lista [ListaTipServicii] - OK'

	update ListaSectii set densectie='Ingrijiri paleative' where codsectie='1061_PAL'--Ingrijiri paliative
	update ListaSectii set densectie='Exceptie anexa 25: Geriatrie si gerontologie' where codsectie='1121.1'--Exceptie anexa 25 Geriatrie si gerontologie
	update ListaSectii set densectie='Hematologie' where codsectie='1131'--Hematologie clinica
	update ListaSectii set densectie='Neonatologie (prematuri) aferente unei maternitati de grd II' where codsectie='1222.1'--Neonatologie (prematuri)_MaternitateGrII
	update ListaSectii set densectie='Neonatologie (prematuri) aferente unei maternitati de gradul III' where codsectie='1222.2'--Neonatologie (prematuri)_MaternitateGrIII
	update ListaSectii set densectie='Neurologie' where codsectie='1231'--Neurologie
	update ListaSectii set densectie='Pediatrie (Recuperare pediatrica)' where codsectie='1272'--Pediatrie ( recuperare pediatrica)
	update ListaSectii set densectie='Psihatrie pediatrica' where codsectie='1312'--Psihiatrie pediatrica
	update ListaSectii set densectie='Psihiatrie(Nevroze)' where codsectie='1321'--Psihiatrie (Nevroze)
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare, medicina fizica si balneologie copii' where codsectie='1372.1'--Exceptie anexa 25 Recuperare, medicina fizica si balneologie copii
	update ListaSectii set densectie='Recuperare medicala cardiovasculara' where codsectie='1383'--Recuperare medicala - cardiovasculara
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare medicala cardiovasculara' where codsectie='1383.1'--Exceptie anexa 25 Recuperare medicala cardiovasculara
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare medicala neurologie' where codsectie='1393.1'--Exceptie anexa 25 Recuperare medicala neurologie
	update ListaSectii set densectie='Exceptie anexa 23C: Recuperare medicala neurologie' where codsectie='1393.2'--Exceptie anexa 23C Recuperare medicala neurologie
	update ListaSectii set densectie='Exceptie anexele 23C si 25: Recuperare medicala neurologie' where codsectie='1393.3'--Exceptie anexele 23C si 25 Recuperare medicala neurologie
	update ListaSectii set densectie='Recuperare medicala neurologie' where codsectie='1393.4'--Exceptie anexa 23C sectia de recuperare medicala neurologie din cadrul spitalului B_80
	update ListaSectii set densectie='Recuperare medicala ortopedie si traumatologie' where codsectie='1403'--Recuperare medicala - ortopedie  si traumatologie
	update ListaSectii set densectie='Recuperare medicala respiratorie' where codsectie='1413'--Recuperare medicala - respiratorie
	update ListaSectii set densectie='Recuperare neuro-psihomotorie' where codsectie='1423'--Recuperare neuro-psiho-motorie
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare neuro-psihomotorie' where codsectie='1423.1'--Exceptie anexa 25 Recuperare neuro-psihomotorie
	update ListaSectii set densectie='Exceptie anexa 23C: Recuperare neuro-psihomotorie' where codsectie='1423.2'--Exceptie anexa 23C Recuperare neuro-psihomotorie
	update ListaSectii set densectie='Exceptie anexa 25: sectia de recuperare medicala neuropsihomotorie copii din cadrul spitalului CT11' where codsectie='1423.3'--Exceptie anexa 25 sectia de recuperare medicala neuropsihomotorie copii din CT11
	update ListaSectii set densectie='Exceptie anexa 25: compartimentul recuperare neuro-psiho-motorie din cadrul spitalului BH18' where codsectie='1423.4'--Exceptie anexa 25 compartimentul recuperare neuro-psiho-motorie din BH18
	update ListaSectii set densectie='Terapie intensiva coronarieni - UTIC' where codsectie='1453'--Terapie intensiva coronarieni -UTIC
	update ListaSectii set densectie='Sectii sanatoriale altele decat balneare' where codsectie='1473'--Sectii sanatoriale
	update ListaSectii set densectie='Otorinolaringologie (ORL)- implant cohlear' where codsectie='2233'--Otorinolaringologie (ORL) - implant cohlear
	update ListaSectii set densectie='Sterilitate-infertilitate' where codsectie='2241'--Sterilitate- infertilitate
	update ListaSectii set densectie='Sterilitate -infertilitate (Fertilizare in vitro)' where codsectie='2251'--Sterilitate- infertilitate (Fertilizare in vitro)
	update ListaSectii set densectie='Urgenta-CPU' where codsectie='3023'--Urgenta - CPU
	update ListaSectii set densectie='Urgenta-UPU' where codsectie='3033'--Urgenta - UPU
	update ListaSectii set densectie='Urgenta-MU' where codsectie='3043'--Urgenta - MU
	update ListaSectii set densectie='Bloc operator**' where codsectie='4023'--Bloc Operator
	update ListaSectii set densectie='Laborator de prevenire si control infectii nosocomia' where codsectie='4143'--Laborator de prevenire si control infectii nosocomiale
	update ListaSectii set densectie='Cabinete de ambulator de specialitate' where codsectie='8013'--Cabinete de specialitate ambulator

	print 'v1.22 - Update lista [ListaSectii] - OK'

	print 'v1.23 - Start'

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=157))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (157,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii',NULL,0,0,'B.4.x','SPT_192','157 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=158))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (158,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii–cu investigatie CT',NULL,0,0,'B.4.x','SPT_193','158 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii–cu investigatie CT -- NA -- B.4.x')
 
	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=159))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (159,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii–cu investigatie RX',NULL,0,0,'B.4.x','SPT_194','159 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii–cu investigatie RX -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=160))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (160,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului–cu investigatie CT',NULL,0,0,'B.4.x','SPT_195','160 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului–cu investigatie CT -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=161))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (161,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului–cu investigatie RX',NULL,0,0,'B.4.x','SPT_196','161 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului–cu investigatie RX -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=162))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (162,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului',NULL,0,0,'B.4.x','SPT_197','162 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=163))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (163,'Infectie cu SARS-CoV-2 confirmata–fara tratament',NULL,0,0,'B.4.x','SPT_198','163 -- Infectie cu SARS-CoV-2 confirmata–fara tratament -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=164))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (164,'Infectie cu SARS-CoV-2 confirmata–cu RX– fara tratament',NULL,0,0,'B.4.x','SPT_199','164 -- Infectie cu SARS-CoV-2 confirmata–cu RX– fara tratament -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=165))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (165,'Infectie cu SARS-CoV-2 confirmata–cu investigatie CT–fara tratament',NULL,0,0,'B.4.x','SPT_200','165 -- Infectie cu SARS-CoV-2 confirmata–cu investigatie CT–fara tratament -- NA -- B.4.x')

	print 'v1.23 - Update lista [ListaTipServicii] - OK'
	
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=115)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (115,'Pulsoximetrie',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=116)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (116,'Administrare de medicamente injectabil/ perfuzii/ alte tipuri de administrari de medicamente',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=117)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (117,'Medicamente cu actiune antivirala administrate parenteral/oral: anticorpi monoclonali neutralizanti/molnupiravir/paxlovid sau alte medicamente achizitionate de Ministerul Sanatatii si distribuite gratuit la nivelul centrului de evaluare',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=118)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (118,'Computer tomografie torace',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=119)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (119,'Examen radiologic torace ansamblu',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=120)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (120,'Medicamente cu actiune antivirala, cu administrare orala achizitionate la nivelul unitatii sanitare:  Favipiravir administrat in centrul de evaluare si eliberat pacientului pentru tratament la domiciliu',NULL)

	print '1.23 - update ListaTipServiciiCerinte - OK'

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=157) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (157,'103,41,53,54,38,19,89,109,105,115,116,117','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=158) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (158,'103,41,53,54,38,19,89,109,118,105,115,116,117','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=159) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (159,'103,41,53,54,38,19,89,109,119,105,115,116,117','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=160) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (160,'103,41,53,54,38,19,89,109,45,48,118,105,115,116,120','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=161) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (161,'103,41,53,54,38,19,89,109,45,48,119,105,115,116,120','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=162) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (162,'103,41,53,54,38,19,89,109,45,48,105,115,116,120','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=163) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (163,'103,41,53,54,38,19,89,109,105,115','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=164) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (164,'103,41,53,54,38,19,89,109,119,105,115','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=165) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (165,'103,41,53,54,38,19,89,109,118,105,115','B4.x')

	print '1.23 - update ListaTipServiciuXCerinta - OK'

	if not exists(select * from ListaSectii where CodSectie='1483.2')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1483.2','Centru de evaluare',0,'14832',NULL)
	end
	print '1.23 - update ListaSectii - OK'

	print 'v1.23 - Stop'

	print 'v1.25 - Start'

	if not exists(select * from [dbo].[ListaTipAsigurareCNAS] where IdTipAsigurareCNAS=6)
	begin
		INSERT INTO [dbo].[ListaTipAsigurareCNAS] ([IdTipAsigurareCNAS],[DenTipAsigurareCNAS],[DataValabilitate]) 
		VALUES (6,'Beneficiari OUG 15',NULL)
	end
	print 'v1.25 - update ListaTipAsigurareCNAS - OK'
	print 'v1.25 - Stop'

	---------------------------------------- 	print 'v1.26 - Start'     ----------------------------------------

	print 'v1.26 - Start'

	print 'v1.26 - Update lista [ListaTipServicii] - OK'
	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=166))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (166
        ,'Infectii acute ale cailor respiratorii la copii - fara tratament'
        ,NULL
        ,0
        ,0
        ,'B.4.x'
        ,'SPT_201'
        ,'166 -- Infectii acute ale cailor respiratorii la copii - fara tratament -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=167))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (167
        ,'Infectii acute ale cailor respiratorii la copii cu RX - fara tratament'
        ,NULL
        ,0
        ,0
        ,'B.4.x'
        ,'SPT_202'
        ,'167 -- Infectii acute ale cailor respiratorii la copii cu RX - fara tratament -- NA -- B.4.x')

	print 'v1.26 - update ListaTipServicii - OK'

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=166) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (166,'103,41,53,54,38,19,89,109,105,115','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=167) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (167,'103,41,53,54,38,19,89,109,119,105,115','B4.x')

	print 'v1.26 - update ListaTipServiciuXCerinta - OK'
	---------------------------------------- 	print 'v1.26 - Stop'     ----------------------------------------

	---------------------------------------- 	print 'v1.27 - Start'     ----------------------------------------

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=168))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (168
        ,'Inductia tratamentului cu Esketaminum (1) – maxim 7 vizite/luna/asigurat'
        ,NULL
        ,1
        ,0
        ,'B.3.1'
        ,'SPT_203'
        ,'168 -- Inductia tratamentului cu Esketaminum (1) – maxim 7 vizite/luna/asigurat -- NA -- B.3.1')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=169))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (169
        ,'Intretinerea tratamentului cu Esketaminum (1) – maxim 4 vizite/luna/asigurat'
        ,NULL
        ,1
        ,0
        ,'B.3.1'
        ,'SPT_204'
        ,'169 -- Intretinerea tratamentului cu Esketaminum (1) – maxim 4 vizite/luna/asigurat -- NA -- B.3.1')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=170))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (170
        ,'Initiere protocol de administrare a Esketaminum (1)'
        ,NULL
        ,0
        ,0
        ,'B.3.2'
        ,'SPT_205'
        ,'170 -- Initiere protocol de administrare a Esketaminum (1) -- NA -- B.3.2')


	print 'v1.27 - Update lista [ListaTipServicii] - OK'

---------------------------------------- 	print 'v1.27 - Stop'     ----------------------------------------

---------------------------------------- 	print 'v1.28 - Start'     ----------------------------------------

-------------------------------------------INSERT SERVICII NOI-----------------------------------------------------------
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=171))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (171, 'Depistarea precoce a cancerului de san cu suspiciune identificata mamografic*5b)',NULL,0, 0, 'B.4.2', 'SPT_301')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=172))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (172, 'Depistarea precoce a cancerului de san cu suspiciune de leziuni infraclinice ale sanului identificate mamografic si ecografic *6a)',NULL,0, 0, 'B.4.2', 'SPT_302')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=173))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (173, 'Depistarea precoce a cancerului de san cu suspiciune de leziuni infraclinice (microcalcificari) ale sanului identificate mamografic si / sau ecografic *6b)',NULL,0, 0, 'B.4.2', 'SPT_303')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=174))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (174, 'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare - tip IV(Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_247')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=175))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (175, 'Depistarea si controlul insuficientei cardiace la populatia la risc (incluzand examinare RMN cord si determinarea NT-proBNP) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_248')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=176))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (176, 'Monitorizarea prin RMN cardiac a pacientului cu infarct miocardic acut in antecedente (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_249')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=177))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (177, 'Monitorizarea prin Angio CT cardiac a pacientului cu stent sau bypass coronarian (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_250')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=178))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (178, 'Monitorizarea prin Angio CT periferic a pacientului cu stent periferic, bypass periferic sau in urma unei proceduri de angioplastie periferica (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_251')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=179))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (179, 'Managementul sindroamelor coronariene cronice (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_252')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=180))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (180, 'Evaluarea cardiomiopatiilor si a patologiei cardiace complexe (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_253')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=181))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (181, 'Evaluarea si monitorizarea ischemiei miocardice in sindromul coronarian cronic (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_254')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=182))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (182, 'Evaluarea riscului cardiovascular la pacientii cu istoric familial, prin depistarea mutatiilor genetice asociate cu risc crescut de boli cardiovasculare rare cu transmitere genetica (o data in viata)',NULL,0, 0, 'B.4.1', 'SPT_255')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=183))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (183, 'Boli alergice cu suspiciune de polisensibilizare si limitarea testarii in vivo – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_256')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=184))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (184, 'Boli alergice cu suspiciune de polisensibilizare si limitarea testarii in vivo – monitorizare (5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_257')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=185))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (185, 'Boli alergice cu suspiciune de sensibilizare la alergene respiratorii si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_258')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=186))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (186, 'Boli alergice cu suspiciune de sensibilizare la alergene respiratorii si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_259')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=187))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (187, 'Boli alergice cu suspiciune de sensibilizare la alergene alimentare si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_260')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=188))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (188, 'Boli alergice cu suspiciune de sensibilizare la alergene alimentare si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_261')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=189))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (189, 'Boli alergice cu suspiciune de sensibilizare la alergene din veninuri de himenoptere  si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_262')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=190))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (190, 'Boli alergice cu suspiciune de sensibilizare la alergene din veninuri de himenoptere  si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_263')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=191))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (191, 'Boli alergice cu suspiciune de sensibilizare la medicamente si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_264')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=192))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (192, 'Boli alergice cu suspiciune de sensibilizare la medicamente si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_265')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=193))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (193, 'Boli alergice cu suspiciune de sensibilizare la latex si limitarea testarii in vivo  – diagnostic(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_266')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=194))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (194, 'Boli alergice cu suspiciune de sensibilizare la latex si limitarea testarii in vivo  – monitorizare(5) (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_267')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=195))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (195, 'Acondroplazia – monitorizare cu proceduri de inalta performanta la pacientii cu suspiciune de  complicatii neurologice si respiratorii severe (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_268')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=196))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (196, 'Boala Fabry – monitorizare (Serviciu bianual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_269')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=197))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (197, 'Osteogenza imperfecta - monitorizare (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_270')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=198))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (198, 'Sindromul Down – monitorizare (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_271')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=200))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (200, 'Sindrom DiGeorge – monitorizare (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_273')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=201))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (201, 'Sindromul Williams – monitorizare (Serviciu anual per asigurat)',NULL,0, 0, 'B.4.1', 'SPT_274')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=202))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (202, 'Hiperchilomicoanemie',NULL,0, 0, 'B.4.1', 'SPT_275')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=203))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (203, 'Sindrom Smith Lemil Opitz',NULL,0, 0, 'B.4.1', 'SPT_276')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=204))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (204, 'Boala depozitarii glicogenului',NULL,0, 0, 'B.4.1', 'SPT_277')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=205))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (205, 'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore (6)',NULL,0, 0, 'B.4.1', 'SPT_278')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=206))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (206, 'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore cu administrare de fier intravenos 500 mg(6)',NULL,0, 0, 'B.4.1', 'SPT_279')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=207))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (207, 'Evaluarea preoperatorie a pacientilor programati pentru interventii chirurgicale elective majore cu administrare de fier intravenos 1000 mg(6)',NULL,0, 0, 'B.4.1', 'SPT_280')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=208))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (208, 'Monitorizarea nou-nascutului prematur',NULL,0, 0, 'B.4.1', 'SPT_281')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=209))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (209, 'Gastroenterite alimentare si alergice la copii',NULL,0, 0, 'B.4.1', 'SPT_282')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=210))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (210, 'Evaluarea cardiologica a  bolnavului  oncologic, inainte  de initierea tratamentul chimio si /sau radioterapic',NULL,0, 0, 'B.4.1', 'SPT_283')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=211))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (211, 'Evaluarea cardiologica a bolnavului  oncologic, in timpul chimio/radioterapiei',NULL,0, 0, 'B.4.1', 'SPT_284')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=212))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (212, 'Tratamentul cariei simple la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_285')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=213))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (213, 'Obturatia dintelui dupa tratamentul afectiunilor pulpare sau al gangrenei la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_286')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=214))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (214, 'Tratamentul de urgenta al traumatismelor dento-alveolare la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_287')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=215))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (215, 'Tratamentul afectiunilor pulpare la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_288')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=216))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (216, 'Tratamentul gangrenei pulpare la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_289')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=217))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (217, 'Tratamentul paradontitelor apicale prin incizie la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_290')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=218))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (218, 'Tratamentul afectiunilor paradontiului la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_291')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=219))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (219, 'Tratamentul afectiunilor mucoasei bucale la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_292')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=220))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (220, 'Extractia dintilor temporari la copii cu nevoi speciale ',NULL,0, 0, 'B.4.1', 'SPT_293')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=221))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (221, 'Extractia dintilor permanenti la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_294')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=222))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (222, 'Chiuretaj alveolar si tratamentul hemoragiei la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_295')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=223))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (223, 'Decapusonarea la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_296')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=224))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (224, 'Reducerea luxatiei articulatiei temporo-mandibulare la copii cu nevoi speciale sau adulti cu dizabilitati',NULL,0, 0, 'B.4.1', 'SPT_297')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=225))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (225, 'Fluorizare la copii cu nevoi speciale ',NULL,0, 0, 'B.4.1', 'SPT_298')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=226))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (226, 'Artropatia psoriazica pentru tratamentul cu imunosupresoare (4)',NULL,0, 0, 'B.3.2', 'SPT_92')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=227))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (227, 'Terapia distoniilor musculare cu dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru adulti; Terapia paraliziilor cerebrale/paraliziilor care genereaza spasticitate cu dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru copii cu greutate peste 25 kg',NULL,0, 0, 'B.3.2', 'SPT_136')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=228))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (228, 'Terapia distoniilor musculare fara dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru adulti; Terapia paraliziilor cerebrale/paraliziilor care genereaza spasticitate fara dirijare electromiografica (cervicale, craniofaciale, ale membrelor, laringiene etc.) cu toxina botulinica pentru copii cu greutate peste 25 kg',NULL,0, 0, 'B.3.2', 'SPT_138')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=229))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (229, 'Terapia spasticitatii membrului superior si/sau inferior aparuta ca urmare a unui accident vascular cerebral pentru pacientul adult – cu toxina botulinica',NULL,0, 0, 'B.3.2', 'SPT_147')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=230))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (230, 'Monitorizarea pacientului cu stenoze coronariene sau periferice',NULL,0, 0, 'B.3.2', 'SPT_206')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=231))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (231, 'Monitorizarea prin RMN cardiac a pacientului cu infarct miocardic acut in antecedente',NULL,0, 0, 'B.3.2', 'SPT_249')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=232))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (232, 'Monitorizarea prin Angio CT cardiac a pacientului cu stent sau bypass coronarian',NULL,0, 0, 'B.3.2', 'SPT_250')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=233))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (233, 'Monitorizarea prin Angio CT periferic a pacientului cu stent periferic, bypass periferic sau in urma unei proceduri de angioplastie periferica',NULL,0, 0, 'B.3.2', 'SPT_251')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=234))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (234, 'Tratamentul anemiei prin carenta de fier la pacientii cu insuficienta cardiaca cronica prin administrare de fier injectabil intravenos',NULL,0, 0, 'B.3.2', 'SPT_210')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=235))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (235, 'Monitorizarea cardiaca a pacientului post-COVID prin RMN cardiac',NULL,0, 0, 'B.3.2', 'SPT_211')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=236))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (236, 'Monitorizarea cardiaca a pacientului post-COVID prin Angio CT coronarian',NULL,0, 0, 'B.3.2', 'SPT_212')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=237))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (237, 'Tratamentul anemiei din boala cronica renala',NULL,0, 0, 'B.3.2', 'SPT_213')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=238))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (238, 'Terapie imunosupresiva in boala cronica renala',NULL,0, 0, 'B.3.2', 'SPT_214')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=239))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (239, 'Monitorizarea evolutiei fenilcetonuriei',NULL,0, 0, 'B.3.2', 'SPT_215')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=240))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (240, 'Diagnostic si/sau stadializare cu proceduri de inalta performanta (2 segmente torace/abdomen sau abdomen/pelvis) in tumori digestive',NULL,0, 0, 'B.3.2', 'SPT_216')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=241))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (241, 'Diagnostic si stadializare cu proceduri de inalta performanta (3 segmente torace/abdomen/pelvis) in tumori digestive',NULL,0, 0, 'B.3.2', 'SPT_217')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=242))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (242, 'Diagnostic cu proceduri de inalta performanta (1 segment abdomen) in boli inflamatorii intestinale',NULL,0, 0, 'B.3.2', 'SPT_218')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=243))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (243, 'Paracenteza',NULL,0, 0, 'B.3.2', 'SPT_219')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=244))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (244, 'Reechilibrare hidro-electrolitica la pacientii cu boli cronice progresive',NULL,0, 0, 'B.3.2', 'SPT_220')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=245))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (245, 'Initierea terapiei antalgice la pacientii cu durere severa',NULL,0, 0, 'B.3.2', 'SPT_221')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=246))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (246, 'Evaluare si tratament la pacientul cu limfedem secundar',NULL,0, 0, 'B.3.2', 'SPT_222')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=247))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (247, 'Monitorizarea pacientului cu durere cronica severa generata de boli cronice progresive',NULL,0, 0, 'B.3.2', 'SPT_223')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=248))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (248, 'Monitorizarea pacientului cu dermatita atopica forma moderat-severa in tratament cu terapii inovatoare (biologice sau cu molecule mici)',NULL,0, 0, 'B.3.2', 'SPT_224')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=249))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (249, 'Tratamentul prin titrare automata al apneei de somn diagnosticata prin poligrafie',NULL,0, 0, 'B.3.2', 'SPT_225')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=250))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (250, 'Monitorizarea si ajustarea tratamentului tulburarilor respiratorii de somn',NULL,0, 0, 'B.3.2', 'SPT_226')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=251))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (251, 'Diagnosticul, tratamentul si monitorizarea tulburarilor respiratorii de somn',NULL,0, 0, 'B.3.2', 'SPT_227')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=252))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (252, 'Poligrafie',NULL,0, 0, 'B.3.2', 'SPT_228')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=253))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (253, 'Poligrafie si titrare automata',NULL,0, 0, 'B.3.2', 'SPT_229')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=254))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (254, 'Polisomnografie si titrare automata',NULL,0, 0, 'B.3.2', 'SPT_230')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=255))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (255, 'Diagnosticul complex al bolii de suprafata oculara (DED) si al altor boli ale suprafatei oculare',NULL,0, 0, 'B.3.2', 'SPT_231')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=256))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (256, 'Tratamentul bolii de suprafata oculara (DED) cu ser autolog si sau imunomodulatoare topice',NULL,0, 0, 'B.3.2', 'SPT_232')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=257))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (257, 'Crosslinking pentru keratoconus',NULL,0, 0, 'B.3.2', 'SPT_233')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=258))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (258, 'Injectare intravitreana de substante terapeutice si monitorizare',NULL,0, 0, 'B.3.2', 'SPT_234')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=259))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (259, 'Tratament si monitorizare tratament chirurgical glob ocular',NULL,0, 0, 'B.3.2', 'SPT_235')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=260))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (260, 'Tratament si monitorizare examinare copil in narcoza',NULL,0, 0, 'B.3.2', 'SPT_236')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=261))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (261, 'Tratament si monitorizare injectie intraoculara',NULL,0, 0, 'B.3.2', 'SPT_237')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=262))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (262, 'Tratament si monitorizare tratament laser glaucom',NULL,0, 0, 'B.3.2', 'SPT_238')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=263))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (263, 'Tratament si monitorizare tratament laser pol posterior al globului ocular',NULL,0, 0, 'B.3.2', 'SPT_239')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=264))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (264, 'Tratament si monitorizare sondaj cai lacrimale la copil in narcoza',NULL,0, 0, 'B.3.2', 'SPT_240')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=265))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (265, 'Diagnosticul si tratamentul anemiei si/sau deficitului de fier, cu fier intravenos, la pacientii cu boli inflamatorii intestinale',NULL,0, 0, 'B.3.2', 'SPT_241')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=266))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (266, 'Monitorizarea pacientilor cu tumori neuroendocrine utilizand scintigrafie 99m-Tc-EDDA-HYNIC TOC (Tektrotyd)  (8)',NULL,0, 0, 'B.3.2', 'SPT_242')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=267))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (267, 'Initiere protocol de administrare a Esketaminei (1)',NULL,0, 0, 'B.3.2', 'SPT_205')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=268))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (268, 'Montare pompe de insulina sau pompe de insulina cu senzori de monitorizare continua a glicemiei',NULL,0, 0, 'B.3.2', 'SPT_243')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=269))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (269, 'Montare sisteme de monitorizare continua a glicemiei',NULL,0, 0, 'B.3.2', 'SPT_244')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=270))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (270, 'Urgenta medicala cu investigatii de inalta performanta (CT, RMN) in camerele de garda',NULL,0, 1, 'B.3.2', 'SPT_245')
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=271))  INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (271, 'Urgenta medicala cu investigatii de inalta performanta (CT, RMN, ANGIOGRAFIE) in structurile de urgenta din cadrul spitalelor pentru care finantarea nu se face din bugetul Ministerului Sanatatii',NULL,0, 1, 'B.3.2', 'SPT_246')
print '1.28 - INSERT INTO [dbo].[ListaTipServicii] - OK'

--------------------------------------------- UPDATE Denumire servicii
update ListaTipServicii   set DenTipServiciu = 'Monitorizare boli neurologice (epilepsie si tulburari de somn, boala Parkinson si alte manifestari extrapiramidale, boli neuromusculare, miastenia gravis si sindromul miastenic, neuropatii periferice, boli neurodegenerative ale sistemului nervos central, ' where IdTipServiciu = 40
update ListaTipServicii   set DenTipServiciu = 'Monitorizare afectiuni oncologice, cu investigatii de inalta performanta' where IdTipServiciu = 77
update ListaTipServicii   set DenTipServiciu = 'Monitorizare afectiuni oncologice, fara investigatii de inalta performanta' where IdTipServiciu = 78
update ListaTipServicii   set DenTipServiciu = 'Chimioterapie (1) cu monitorizare' where IdTipServiciu = 92
update ListaTipServicii   set DenTipServiciu = 'Monitorizarea bolilor psihiatrice adulti si copii (tulburari cognitive minore, demente incipiente, tulburari psihotice si afective în perioade de remisiune, tulburari nevrotice si de personalitate)' where IdTipServiciu = 93
update ListaTipServicii   set DenTipServiciu = 'Implantarea cateterului venos central cu camera implantabila destinat administrarii de chimioterapice (în cure lungi de 6 - 24 luni) pentru pacientii oncologici ?i hematologici. Tariful aferent acestui serviciu include costul cateterului venos central ?i camerei implantabile.' where IdTipServiciu = 98
update ListaTipServicii   set DenTipServiciu = 'Monitorizarea si tratamentul colagenenozelor: poliartrita reumatoida, lupus  eritematos  sistemic,  dermato-polimiozita,  sindrom  Sjorgen, vasculite sistemice.' where IdTipServiciu = 99
update ListaTipServicii   set DenTipServiciu = 'Ciroza hepatica – monitorizare  cu  proceduri de inalta performanta la pacientii cu suspiciune de hepatocarcinom (Serviciu anual per asigurat)' where IdTipServiciu = 111
update ListaTipServicii   set DenTipServiciu = 'Ciroza hepatica virala -  monitorizare si prescriere tratament antiviral (1) (Serviciu lunar per asigurat)' where IdTipServiciu = 113
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala B – diagnostic (Serviciu anual per asigurat)' where IdTipServiciu = 114
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala B fara agent delta – monitorizare tratament antiviral (Serviciu anual per asigurat)' where IdTipServiciu = 115
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala B cu agent delta – diagnostic (Serviciu anual per asigurat)' where IdTipServiciu = 116
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala B cu agent delta - Monitorizarea eficientei si stabilirea continuarii terapiei antivirale (Serviciu anual per asigurat)' where IdTipServiciu = 117
update ListaTipServicii   set DenTipServiciu = 'Hepatita cronica virala C – diagnostic (Serviciu anual per asigurat)' where IdTipServiciu = 118
update ListaTipServicii   set DenTipServiciu = 'Boli inflamatorii intestinale – administrare si prescriere tratament biologic (4) (Serviciu lunar per asigurat)' where IdTipServiciu = 119
update ListaTipServicii   set DenTipServiciu = 'Boli inflamatorii intestinale – monitorizare (Serviciu bianual per asigurat)' where IdTipServiciu = 120
update ListaTipServicii   set DenTipServiciu = 'Monitorizare lunara si prescriere tratament antiviral B, C, D (4) (Serviciu lunar per asigurat)' where IdTipServiciu = 121
update ListaTipServicii   set DenTipServiciu = 'Stadializare fibroza hepatica – Fibroscan la pacientii cu afectiuni hepatice preexistente (Serviciu anual per asigurat)' where IdTipServiciu = 122
update ListaTipServicii   set DenTipServiciu = 'Evaluare postransplant hepatic (Serviciu anual per asigurat)' where IdTipServiciu = 123
update ListaTipServicii   set DenTipServiciu = 'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare-tip I (Serviciu anual per asigurat)' where IdTipServiciu = 124
update ListaTipServicii   set DenTipServiciu = 'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare- tip II (Serviciu anual per asigurat)' where IdTipServiciu = 125
update ListaTipServicii   set DenTipServiciu = 'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare- tip III (Serviciu anual per asigurat)' where IdTipServiciu = 126
update ListaTipServicii   set DenTipServiciu = 'Supravegherea unei sarcini normale (la gravida care nu detine documente medicale care sa ateste existenta in antecedentele personale patologice a rubeolei, toxoplasmozei, infectiei CMV) (1)' where IdTipServiciu = 128
update ListaTipServicii   set DenTipServiciu = 'Supravegherea unei sarcini normale (la gravida care detine documente medicale ce atesta existenta in antecedentele personale patologice a hepatita B si C rubeolei, toxoplasmozei, infectiei CMV) (1)' where IdTipServiciu = 129
update ListaTipServicii   set DenTipServiciu = 'Screening prenatal (S11 - S19+6 zile) (2)' where IdTipServiciu = 130
update ListaTipServicii   set DenTipServiciu = 'Supravegherea altor sarcini cu risc crescut (edem gestational) (3)' where IdTipServiciu = 131
update ListaTipServicii   set DenTipServiciu = 'Supravegherea altor sarcini cu risc crescut (hiperemeza gravidica usoara) (3)' where IdTipServiciu = 132
update ListaTipServicii   set DenTipServiciu = 'Supravegherea altor sarcini cu risc crescut (evaluarea gravidelor cu uter cicatriceal in trimestrul III) (6)' where IdTipServiciu = 133
update ListaTipServicii   set DenTipServiciu = 'Depistarea precoce a cancerului de sân (4)' where IdTipServiciu = 134
update ListaTipServicii   set DenTipServiciu = 'Depistarea si diagonsticarea precoce a leziunilor displazice ale  colului uterin (6)' where IdTipServiciu = 136
update ListaTipServicii   set DenTipServiciu = 'Depistarea si diagonsticarea precoce a leziunilor displazice ale  colului uterin cu examen citologic (7)' where IdTipServiciu = 137
update ListaTipServicii   set DenTipServiciu = 'Diagnosticarea precoce a leziunilor displazice ale colului uterin cu biopsie*8)' where IdTipServiciu = 138
update ListaTipServicii   set DenTipServiciu = 'Terapia spasticitatii membrului superior ?i/sau inferior aparuta ca urmare a unui accident vascular cerebral pentru pacientul adult-cu toxina botulinica' where IdTipServiciu = 140
update ListaTipServicii   set DenTipServiciu = 'Endoscopie digestiva inferioara cu sedare, fara biopsie - colonoscopie flexibila pâna la cec' where IdTipServiciu = 143
update ListaTipServicii   set DenTipServiciu = 'Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pâna la cec' where IdTipServiciu = 144
update ListaTipServicii   set DenTipServiciu = 'Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pâna la flexura hepatica' where IdTipServiciu = 150
update ListaTipServicii   set DenTipServiciu = 'Tratamentul excizional sau ablativ al leziunilor precanceroase ale colului uterin (9)' where IdTipServiciu = 155
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii (1)' where IdTipServiciu = 157
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii (1) –cu investigatie CT' where IdTipServiciu = 158
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii (1) –cu investigatie RX' where IdTipServiciu = 159
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului (2) –cu investigatie CT' where IdTipServiciu = 160
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului  (2) –cu investigatie RX' where IdTipServiciu = 161
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului  (2)' where IdTipServiciu = 162
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata – fara tratament' where IdTipServiciu = 163
update ListaTipServicii   set DenTipServiciu = 'Infectie cu SARS-CoV-2 confirmata–cu investigatie CT – fara tratament' where IdTipServiciu = 165
update ListaTipServicii   set DenTipServiciu = 'Distrofie musculara Duchenne/Becker – monitorizare (Serviciu anual per asigurat)' where IdTipServiciu = 199
print '1.28 - Update Denumire servicii - OK'

------------------------------------------------------ UPDATE DataStart servicii
update ListaTipServicii   set DataStart = '2023-06-01 00:00:00' where IdTipServiciu = 168
update ListaTipServicii   set DataStart = '2023-06-01 00:00:00' where IdTipServiciu = 169
update ListaTipServicii   set DataStart = '2023-06-01 00:00:00' where IdTipServiciu = 170
update ListaTipServicii   set DataStart = '2023-07-01 00:00:00' where IdTipServiciu between 171 and 271
print '1.28 - Update DataStart servicii - OK'

-------------------------------------------------------UPDATE Denumire completa servicii
update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)
print '1.28 - Update IdDenDataTipServiciu - OK'

------------------------------------------------------ UPDATE ListaCazRezolvatInterventiiChirurgicale
if not exists (select * from [ListaCazRezolvatInterventiiChirurgicale] where IDCazRezolvatInterventiiChirurgicale = 95)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicale]([IDCazRezolvatInterventiiChirurgicale],[DenCazRezolvatInterventiiChirurgicale],[DataValabilitate],[DenCazRezolvatInterventieComplet])
VALUES (95, 'Montare drenaj ureteral intern', NULL, 'Montare drenaj ureteral intern')

if not exists (select * from [ListaCazRezolvatInterventiiChirurgicale] where IDCazRezolvatInterventiiChirurgicale = 96)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicale]([IDCazRezolvatInterventiiChirurgicale],[DenCazRezolvatInterventiiChirurgicale],[DataValabilitate],[DenCazRezolvatInterventieComplet])
VALUES (96, 'Dezobstructia tractului urinar superior', NULL, 'Dezobstructia tractului urinar superior')

if not exists (select * from [ListaCazRezolvatInterventiiChirurgicale] where IDCazRezolvatInterventiiChirurgicale = 97)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicale]([IDCazRezolvatInterventiiChirurgicale],[DenCazRezolvatInterventiiChirurgicale],[DataValabilitate],[DenCazRezolvatInterventieComplet])
VALUES (97, 'Dilatarea progresiva a stricturilor uretrale', NULL, 'Dilatarea progresiva a stricturilor uretrale')
print '1.28 - Update ListaCazRezolvatInterventiiChirurgicale - OK'

------------------------------------------------------ UPDATE ListaCazRezolvatAfectiuni
if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 114))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (114 ,'Degenerescenta senila a creierului, neclasificata altundeva' ,'G31.1',NULL,'G31.1' + ' - ' + 'Degenerescenta senila a creierului, neclasificata altundeva')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 115))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (115 ,'Osteoporoza (Alte afectiuni specificate ale densitatii si structurii osoase, localizari multiple)' ,'M85.50',NULL,'M85.50' + ' - ' + 'Osteoporoza (Alte afectiuni specificate ale densitatii si structurii osoase, localizari multiple)')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 116))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (116 ,'Pubertate precoce' ,'E30.1',NULL,'E30.1' + ' - ' + 'Pubertate precoce')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 117))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (117 ,'Insuficienta staturala' ,'E34.3',NULL,'E34.3' + ' - ' + 'Insuficienta staturala')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 118))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (118 ,'Alte tireotoxicoze' ,'E05.8',NULL,'E05.8' + ' - ' + 'Alte tireotoxicoze')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 119))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (119 ,'Tumora tiroida cu evolutie imprevizibila si necunoscuta' ,'D44.0',NULL,'D44.0' + ' - ' + 'Tumora tiroida cu evolutie imprevizibila si necunoscuta')

if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 120))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (120 ,'Pubertate intarziata' ,'E30.0',NULL,'E30.0' + ' - ' + 'Pubertate intarziata')

print '1.28 - Update ListaCazRezolvatAfectiuni - OK'

------------------------------------------------------ UPDATE camp ListaNorme
Update ListaTipServicii
set ListaNorme = 'B.3.2'
where IdTipServiciu in ('1','2','3','4','9','10','11','12','13','14','15','16','17','18','19','20','21','22','30','31','32','71','72')
print '1.28 - Update camp ListaNorme - OK'

------------------------------------------------------ UPDATE camp DataValabilitate
Update ListaTipServicii
set DataValabilitate = '2023-06-30 23:59:59'
where IdTipServiciu = 48
print '1.28 - Update camp DataValabilitate - OK'
------------------------------------------------------ UPDATE ListaTipServiciiCerinte
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =121 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (121,'Mamografie cu tomosinteză unilateral')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =122 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (122,'Senologie imagistică')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =123 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (123,'Puncție biopsie mamară ghidată ecografic, cu marcaj aplicat*10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =124 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (124,'Puncție biopsie mamară cu vacuum ghidată mamografic (stereotactic) sau ecografic, cu marcaj aplicat*10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =125 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (125,'Examen histopatologic procedura completă HE şi coloraţii speciale (1 - 3 blocuri) *10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =126 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (126,'Consultație de specialitate obstetrică-ginecologie (interpretare integrative a rezultatelor)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =127 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (127,'Mamografie digitala (10)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =128 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (128,'Teste imuno-histochimice *10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =129 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (129,'Examen imunohistochimic *10a)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =130 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (130,'EKG de repaus 12 derivații')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =131 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (131,'Doppler color')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =132 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (132,'Angio CT')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =133 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (133,'RMN cord cu contrast')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =134 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (134,'Determinarea NT-pro BNP')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =135 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (135,'Consultatie chirurgie cardiovasculara')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =136 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (136,'Angio CT cardiac cu contrast')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =137 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (137,'Consultatie chirurgie vasculara')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =138 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (138,'Angio CT periferic cu contrast')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =139 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (139,'Angio CT coronarian')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =140 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (140,'Lipidograma')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =141 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (141,'Ionograma')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =142 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (142,'eRFG')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =143 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (143,'Test de efort')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =144 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (144,'RMN')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =145 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (145,'Scintigrafie cardiaca de stress si repaus')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =146 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (146,'Anticorpi anti-gliadina/anti-transglutaminaza tisulara')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =147 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (147,'Testare genetica “next generation sequencing” panel boli cardiovasculare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =148 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (148,'Consultatie de specialitate alergologie si imunologie clinica')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =149 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (149,'IgE specifice serice pentru alergene moleculare multiple (multiplex)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =150 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (150,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 8 alergene moleculare respiratorii)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =151 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (151,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 8 alergene moleculare alimentare)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =152 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (152,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 6 alergene moleculare din veninuri de himenoptere)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =153 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (153,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 4 alergene moleculare medicamentoase)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =154 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (154,'IgE specifice serice pentru alergen molecular individual (singleplex) (set de 2 alergene moleculare din latex)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =155 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (155,'Consultatie de specialitate genetica medicala')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =156 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (156,'Spirometrie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =157 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (157,'RMN craniu nativ si cu substanta de contrast ')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =158 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (158,'Rata filtrarii glomerulare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =159 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (159,'Microalbuminurie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =160 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (160,'Examen sumar de urina')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =161 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (161,'Calciu seric total')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =162 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (162,'Fosfor seric')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =163 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (163,'25-OH Vit. D')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =164 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (164,'DXA coloana lombara si sold')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =165 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (165,'Radiografie coloana anteroposterior si profil')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =166 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (166,'Audiometrie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =167 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (167,'Creatinkinaza (CK)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =168 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (168,'Evaluare respiratorie functionala')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =169 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (169,'Evaluare status nutritional')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =170 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (170,'Ecografie renala ')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =171 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (171,'Parathormon seric')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =172 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (172,'FT4')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =173 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (173,'Radiografie coloana vertebrala')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =174 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (174,'Calciu urinar')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =175 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (175,'Consultatie de specialitate pediatrie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =176 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (176,'Consultatie de specialitate diabet si boli metabolice')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =177 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (177,'LDH')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =178 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (178,'Lipaza')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =179 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (179,'Ecografie abdomen ')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =180 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (180,'Determinare grup sanguin si Rh')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =181 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (181,'Fier injectabil intravenos 1000 mg')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =182 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (182,'Consultatie neurologie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =183 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (183,'Consultatie oftalmologie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =184 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (184,'Consultatie dermatologie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =185 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (185,'IgM')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =186 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (186,'IgG')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =187 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (187,'Ecografie sold')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =188 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (188,'Ecografie transfontanelara (ETF)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =189 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (189,'Frotiu sangvin')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =190 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (190,'IgE')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =191 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (191,'Amilaza')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =192 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (192,'Calciu ionic')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =193 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (193,'Bicarbonat seric')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =194 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (194,'Test pt hemoragii oculte')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =195 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (195,'Antigen Helicobacter Pylori')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =196 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (196,'Coeficient de saturatie al transferinei')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =197 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (197,'Ecografie Doppler vasculara periferica (artere sau vene)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =198 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (198,'Ecocardiografie Doppler color, inclusiv GLS (deformare longitudinala globala)')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =199 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (199,'Holter EKG 24 ore')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =200 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (200,'Holter EKG 72 ore')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =201 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (201,'Holter TA 24 ore')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =202 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (202,'Electroforeza proteinelor serice')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =203 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (203,'D-Dimeri')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =204 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (204,'Sedare procedurala')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =205 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (205,'Tratamentul cariei simple')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =206 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (206,'Obturatia dintelui după tratamentul afectiunilor pulpare sau al gangrenei')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =207 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (207,'Tratamentul de urgenta al traumatismelor dento-alveolare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =208 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (208,'Tratamentul afectiunilor pulpare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =209 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (209,'Tratamentul gangrenei pulpare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =210 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (210,'Tratamentul paradontitelor apicale prin incizie')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =211 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (211,'Tratamentul afecțiunilor paradontiului')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =212 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (212,'Tratamentul afectiunilor mucoasei bucale')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =213 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (213,'Extractia dintilor temporari')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =214 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (214,'Extractia dintilor permanenti')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =215 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (215,'Chiuretaj alveolar si tratamentul hemoragiei')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =216 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (216,'Decapusonare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =217 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (217,'Reducerea luxatiei articulatiei temporo-mandibulare')
if not exists (select * from [dbo].[ListaTipServiciiCerinte] where IdTipServiciuCerinta =218 ) INSERT INTO [dbo].[ListaTipServiciiCerinte]([IdTipServiciuCerinta],[DenTipServiciuCerinta]) VALUES (218,'Fluorizare')
print '1.28 - INSERT ListaTipServiciiCerinte - OK'

------------------------------------------------------ UPDATE ListaTipServiciuXCerinta
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 171) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (171,'95,94,127,121,122,63','B4.2')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 172) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (172,'123,125,128,63','B4.2')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 173) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (173,'124,80,129,63','B4.2')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 174) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (174,'93,38,40,18,46,39,55,19,4,53,54,130,42,29,31,13,32,132','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 175) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (175,'93, 133, 134','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 176) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (176,'93,130,42,29,133','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 177) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (177,'(93 sau 135) si 136','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 178) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (178,'(93 sau 135 sau 137) si 138','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 179) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (179,'93, 41, 38, 140, 141, 89, 19, 105, 139','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 180) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (180,'93, 41, 38, 140, 141, 89, 19, 29, 105, 143, 144','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 181) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (181,'93, 41, 38, 140, 141, 167, 19, 29, 105, 143, 145','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 182) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (182,'93, 41, 38, 140, 141, 19, 167, 134, 29, 105, 147','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 183) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (183,'148, 149','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 184) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (184,'148, 149','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 185) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (185,'148, 150','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 186) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (186,'148, 150','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 187) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (187,'148, 151','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 188) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (188,'148, 151','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 189) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (189,'148, 152','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 190) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (190,'148, 152','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 191) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (191,'148, 153','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 192) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (192,'148, 153','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 193) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (193,'148, 154','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 194) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (194,'148, 154','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 195) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (195,'(155 sau 182) si 19, 156, 157','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 196) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (196,'103, 41, 89, 19, 158, 68, 159, 160, 18, 55, 46, 39, 48, 45, 161, 29, 131, 156','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 197) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (197,'103, 41, 161, 162, 36, 82, 53, 54, 19, 142, 163, 79, 164, 165','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 198) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (198,'103, 41, 51, 34, 38, 18, 55, 53, 54, 19, 161, 48, 45, 109, 88, 146, 79, 29, 131, 166, 105','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 199) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (199,'103, 41, 51, 34, 38, 82, 18, 55, 53, 54, 161, 48, 45, 163, 56, 109, 167, 88, 79, 105, 29, 131, 168, 169, 19','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 200) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (200,'103, 41, 161, 171, 88, 172, 105, 29, 131, 170, 166, 173','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 201) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (201,'103, 41, 51, 38, 18, 55, 53, 54, 19, 48, 45, 161, 174, 163, 56, 109, 88, 79, 105, 29, 131, 170','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 202) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (202,'(175 sau 176) si 41, 38, 53, 54, 11, 12, 82, 7, 37, 36, 177, 111, 99, 106, 88, 18, 39, 46, 55','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 203) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (203,'(175 sau 176) si 41, 38, 53, 54, 18, 39, 46, 55, 178','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 204) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (204,'(175, sau176) si 41, 38, 53, 57, 11, 12, 82, 7, 37, 36, 177, 111, 99, 106, 18, 39, 46, 54, 89, 19, 159, 167, 48, 45, 29, 179','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 205) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (205,'41, 34, 109, 38, 19, 89, 111, 99, 82, 7, 53, 54, 180, 93, 105, 29, 102','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 206) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (206,'41, 34, 109, 38, 19, 89, 111, 99, 82, 7, 53, 54, 180, 93, 105, 29, 102, 112','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 207) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (207,'41, 34, 109, 38, 19, 89, 111, 99, 82, 7, 53, 54, 180, 93, 105, 29, 102, 181','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 208) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (208,'(175 sau 183 sau 182 sau 184), 41, 109, 82, 11, 12, 51, 185, 186, 89, 19, 179, 29, 187, 188','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 209) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (209,'(175 sau 91 sau 148) si41, 189, 109,  56, 82, 7, 18, 46, 39, 55, 51, 34, 190, 53, 54, 89, 19, 99, 111, 106, 191, 48, 45, 161, 192, 193, 194, 195, 179,38','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 210) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (210,'93, 130, 131, 18, 46, 39, 55, 38, 53, 54, 19, 142, 89, 141, 4, 41, 34, 196, 51, 172, 88','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 211) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (211,'93 si 130 si 197 si 198 si (199 sau 200 sau 201) si 19, 142, 89, 82, 202, 53, 54, 203, 134, 141, 41, 51, 34, 196','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 212) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (212,'102, 204, 205','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 213) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (213,'102, 204, 206','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 214) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (214,'102, 204, 207','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 215) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (215,'102, 204, 208','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 216) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (216,'102, 204, 209','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 217) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (217,'102, 204, 210','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 218) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (218,'102, 204, 211','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 219) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (219,'102, 204, 212','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 220) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (220,'102, 204, 213','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 221) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (221,'102, 204, 214','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 222) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (222,'102, 204, 215','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 223) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (223,'102, 204, 216','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 224) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (224,'102, 204, 217','B4.1')
if not exists (select * from [dbo].[ListaTipServiciuXCerinta] where IdTipServiciu = 225) INSERT INTO [dbo].[ListaTipServiciuXCerinta]([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista]) VALUES (225,'102, 204, 218','B4.1')

------------------------------------------------------ Marire camp ListaTipServiciuXCerinta
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,19,20,44,17', [TipLista] = 'B4.1' WHERE IdTipServiciu = 111
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,41,43,7,38,19,48,45,15,5', [TipLista] = 'B4.1' WHERE IdTipServiciu = 112
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,41,43,53,54,7,38,11,12,19,48,45', [TipLista] = 'B4.1' WHERE IdTipServiciu = 113
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,1,6,2,3,22,35', [TipLista] = 'B4.1' WHERE IdTipServiciu = 114
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,41,53,54,1,6,2,22', [TipLista] = 'B4.1' WHERE IdTipServiciu = 115
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,23', [TipLista] = 'B4.1' WHERE IdTipServiciu = 116
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,23', [TipLista] = 'B4.1' WHERE IdTipServiciu = 117
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92 si 21,35', [TipLista] = 'B4.1' WHERE IdTipServiciu = 118
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,41,7,38,19,53,54,48,45', [TipLista] = 'B4.1' WHERE IdTipServiciu = 119
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,41,43,7,38,19,53,54,36,37,49,56,14,34,51', [TipLista] = 'B4.1' WHERE IdTipServiciu = 120
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,41,53,54,19', [TipLista] = 'B4.1' WHERE IdTipServiciu = 121
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,92,35', [TipLista] = 'B4.1' WHERE IdTipServiciu = 122
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '91,16,25,52,58,27,22,21', [TipLista] = 'B4.1' WHERE IdTipServiciu = 123
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '93,38,40,18,46,39,55,19,4,53,54,26,42,29,13,32', [TipLista] = 'B4.1' WHERE IdTipServiciu = 124
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '93,38,40,18,46,39,55,19,4,53,54,26,42,29,13,32,(31sau47)', [TipLista] = 'B4.1' WHERE IdTipServiciu = 125
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '93,38,40,18,46,39,55,19,4,53,54,26,42,29,13,32,31,47', [TipLista] = 'B4.1' WHERE IdTipServiciu = 126
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,10,49,50,24,96,33,9,8,30', [TipLista] = 'B4.1' WHERE IdTipServiciu = 127
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,41,66,67,89,57,19,38,53,54,88,79,90,86,76,84,70,78,85,40,59,65', [TipLista] = 'B4.2' WHERE IdTipServiciu = 128
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,41,66,67,89,57,19,38,53,54,88,79,90,86,75,84,70,78,85,40,59,65', [TipLista] = 'B4.2' WHERE IdTipServiciu = 129
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,69,72', [TipLista] = 'B4.2' WHERE IdTipServiciu = 130
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,41,19,57,53,54,79,68,82,30', [TipLista] = 'B4.2' WHERE IdTipServiciu = 131
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,41,48,79,45,57,19,30,89', [TipLista] = 'B4.2' WHERE IdTipServiciu = 132
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,62,30', [TipLista] = 'B4.2' WHERE IdTipServiciu = 133
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '95,94,127,63', [TipLista] = 'B4.2' WHERE IdTipServiciu = 134
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '95,94,127,122,63', [TipLista] = 'B4.2' WHERE IdTipServiciu = 135
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,87,83,64', [TipLista] = 'B4.2' WHERE IdTipServiciu = 136
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,87,83,77,64', [TipLista] = 'B4.2' WHERE IdTipServiciu = 137
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,60,80', [TipLista] = 'B4.2' WHERE IdTipServiciu = 138
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,34,110,41,51,109,38,19,89,111,99,112', [TipLista] = 'B4.1' WHERE IdTipServiciu = 142
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,100', [TipLista] = 'B4.1' WHERE IdTipServiciu = 143
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,100', [TipLista] = 'B4.1' WHERE IdTipServiciu = 144
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,100,108,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 145
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,100,108,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 146
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,100,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 147
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,100,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 148
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,101', [TipLista] = 'B4.1' WHERE IdTipServiciu = 149
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,101', [TipLista] = 'B4.1' WHERE IdTipServiciu = 150
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,101,108,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 151
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,101,108,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 152
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,102,41,106,111,99,105,98,101,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 153
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,106,111,99,105,101,114', [TipLista] = 'B4.1' WHERE IdTipServiciu = 154
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '94,104,97,107,113', [TipLista] = 'B4.2' WHERE IdTipServiciu = 155
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 157
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 157
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,118,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 158
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,118,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 158
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,119,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 159
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,119,105,115,116,117', [TipLista] = 'B4.x' WHERE IdTipServiciu = 159
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,118,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 160
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,118,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 160
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,119,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 161
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,119,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 161
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 162
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,45,48,105,115,116,120', [TipLista] = 'B4.x' WHERE IdTipServiciu = 162
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 163
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 163
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,119,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 164
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,119,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 164
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,118,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 165
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109,118,105,115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 165
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109, 105, 115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 166
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109, 105, 115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 166
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109, 119,105, 115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 167
UPDATE [dbo].[ListaTipServiciuXCerinta] SET [IdsTipServiciuCerinte] = '103,41,53,54,38,19,89,109, 119,105, 115', [TipLista] = 'B4.x' WHERE IdTipServiciu = 167
print '1.28 - UPDATE ListaTipServiciuXCerinta - OK'

------------------------------------------------------ Marire camp RegulaIncalcata
alter table PacientFisa
alter column RegulaIncalcata nvarchar(2000) NULL
print '1.28 - Marire camp RegulaIncalcata - OK'


---------------------------------------- 	print 'v1.28 - Stop'     ----------------------------------------

---------------------------------------- 	print 'v1.29 - Stop'     ----------------------------------------
-------------------------------------------------------Stergere servicii inactive
update PacientTipServiciiSZ
set IdTipServiciu = NULL
where IdTipServiciu in (227, 228, 231, 232, 233)

update PacientFisaSZ
set IdTipServiciuUPU = NULL
where IdTipServiciuUPU in (227, 228, 231, 232, 233)

delete from ListaTipServiciuXCerinta
where IdTipServiciu in (227, 228, 231, 232, 233)

delete from ListaTipServicii
where IdTipServiciu in (227, 228, 231, 232, 233)
print '1.29 - Stergere servicii inactive - OK'

--------------------------------------------Expirate la 2023/6/30: 134, 135, 140
update ListaTipServicii
set DataValabilitate = '2023-06-30 23:59:59.000'
where IdTipServiciu in (134, 135, 140)
print '1.29 - Expirare servicii 134, 135, 140 - OK'

-------------------------------------------Inserare servicii noi
if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=999))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI])  VALUES (999, 'NA',NULL,0, 0, 'B.3.2', NULL)

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=272))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  VALUES (272, 'Depistarea precoce a cancerului de san (4)',NULL,0, 0, 'B.4.2', 'SPT_299', '2023-07-01 00:00:00.000')

if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=273))  
INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu], [DenTipServiciu], [DataValabilitate], [PentruVizita], [UPU], [ListaNorme], [Cod_SIUI], [DataStart])  VALUES (273, 'Depistarea precoce a leziunilor precanceroase ale sanului cu suspiciune identificata mamografic',NULL,0, 0, 'B.4.2', 'SPT_300', '2023-07-01 00:00:00.000')

update ListaTipServicii
set IdDenDataTipServiciu = [dbo].[GetDenTipServiciuComplet](IdTipServiciu)
print '1.29 - Insert servicii noi  999, 272, 273 - OK'

-------------------------------------------Inserare itemuri noi in ListaCazRezolvatInterventiiChirurgicaleProceduri
if not exists (select * from [ListaCazRezolvatInterventiiChirurgicaleProceduri] where [IDCazRezolvatInterventiiChirurgicaleProceduri] = 155)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicaleProceduri]([IDCazRezolvatInterventiiChirurgicaleProceduri],[IDCazRezolvatInterventiiChirurgicale],[CodProcedura])
VALUES (155, 95, 'K02801')

if not exists (select * from [ListaCazRezolvatInterventiiChirurgicaleProceduri] where [IDCazRezolvatInterventiiChirurgicaleProceduri] = 156)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicaleProceduri]([IDCazRezolvatInterventiiChirurgicaleProceduri],[IDCazRezolvatInterventiiChirurgicale],[CodProcedura])
VALUES (156, 96, 'K02901')

if not exists (select * from [ListaCazRezolvatInterventiiChirurgicaleProceduri] where [IDCazRezolvatInterventiiChirurgicaleProceduri] = 157)
INSERT INTO [dbo].[ListaCazRezolvatInterventiiChirurgicaleProceduri]([IDCazRezolvatInterventiiChirurgicaleProceduri],[IDCazRezolvatInterventiiChirurgicale],[CodProcedura])
VALUES (157, 97, 'K08202')
print '1.29 - Insert proceduri in [ListaCazRezolvatInterventiiChirurgicaleProceduri] - OK'
----------------------------------------- End v1.29

------------------------------------------ Start v1.30
if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 121))
INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
    VALUES (121 ,'Hiposecretia si alte tulburari ale glandei hipofizare' ,'E23.0',NULL,'E23.0' + ' - ' + 'Hiposecretia si alte tulburari ale glandei hipofizare')

update [dbo].[ListaCazRezolvatAfectiuni]
set CodDiagnostic = 'M85.80',
	DenCazRezolvatAfectiuneComplet = 'M85.80 - Osteoporoza (Alte afectiuni specificate ale densitatii si structurii osoase, localizari multiple)'
where IDCazRezolvatAfectiune = 115
print '1.30 - Modificari in [ListaCazRezolvatAfectiuni] - OK'
------------------------------------------ End v1.30

	UPDATE DBVersion
	SET CurrentVersion = '1.30'
	print 'UPDATE DBVersion to 1.30 - OK'
	
	set nocount off
    COMMIT
END TRY
BEGIN CATCH
 print 'Eroare nr. ' + cast(ERROR_NUMBER() as varchar(50)) + ' la linia ' + cast(ERROR_LINE() as varchar(50)) + ' cu mesajul ' + ERROR_MESSAGE()
 ROLLBACK
END CATCH


