﻿USE [DRGNationalDB]
GO

BEGIN TRY
	SET QUOTED_IDENTIFIER ON
    BEGIN TRANSACTION
	set nocount on

	if exists(select * from sys.objects where name = 'FK_ListaSectiiFiltrat_ListaSectii')
	BEGIN
		ALTER TABLE [dbo].[ListaSectiiFiltrat] DROP CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii]
		print 'DROP CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii] - OK'
	END

	if not exists(select * from sys.objects where name = 'FK_ListaSectiiFiltrat_ListaSectii')
	BEGIN
		ALTER TABLE [dbo].[ListaSectiiFiltrat]  WITH CHECK ADD  CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii] FOREIGN KEY([CodSectie])
		REFERENCES [dbo].[ListaSectii] ([CodSectie])
		ON UPDATE CASCADE
		print 'ADD CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii] - OK'
	END

	update ListaSectii 
	set DenSectie = 'Medicina generala'
	where CodSectie = '1163'
	print 'update ListaSectii 1163 - OK'

	update ListaSectii
	set CodSectie='8023'
	where DenSectie = 'Medicina de familie'
	print 'update ListaSectii 8023 - OK' 

	update ListaSectii
	set CodSectie='1121.1'
	where CodSectie like '1121.1%'
	print 'update ListaSectii 1121.1 - OK' 

	update ListaSectii
	set CodSectie='1372.1'
	where CodSectie like '1372.1%'
	print 'update ListaSectii 1372.1 - OK' 

	update ListaSectii
	set CodSectie='1423.1'
	where CodSectie like '1423.1%'
	print 'update ListaSectii 1423.1 - OK' 

	update ListaSectii
	set CodSectie='1423.2'
	where CodSectie like '1423.2%'
	print 'update ListaSectii 1423.2 - OK' 

	--create filtered index
	IF EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.Persoane') AND NAME ='IX_CNP_UNIC')
	BEGIN
		DROP INDEX IX_CNP_UNIC ON dbo.Persoane;
		print 'DROP INDEX IX_CNP_UNIC - OK'
	END
	IF NOT EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.Persoane') AND NAME ='IX_CNP_UNIC_NOTNULL')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX IX_CNP_UNIC_NOTNULL
		ON dbo.Persoane(CNP)
		WHERE CNP IS NOT NULL
		print 'CREATE INDEX IX_CNP_UNIC - OK'
	END

	--IstoricPF
	alter table IstoricPF
	alter column IdPacientFisa int null

	alter table IstoricPF
	alter column CazID nvarchar(36) null

	alter table IstoricPF
	alter column IdSpital int null

	--alter table IstoricPF
	--alter column NFO int null

	alter table IstoricPF
	alter column DataInternare datetime null

	alter table IstoricPF
	alter column IdTipInternare tinyint null

	alter table IstoricPF
	alter column IdSectieInternare int null

	alter table IstoricPF
	alter column IdLocalitate int null

	alter table IstoricPF
	alter column IdTipCetatenie tinyint null

	alter table IstoricPF
	alter column IdStatutAsigurat tinyint  null

	alter table IstoricPF
	alter column IdMedicCurant int null

	alter table IstoricPF
	alter column IdDI int null

	alter table IstoricPF
	alter column IdStareRecord tinyint null

	alter table IstoricPF
	alter column Finalizat bit null

	alter table IstoricPF
	alter column CodValiditateICP bit null

	alter table IstoricPF
	alter column CodValiditateDP1 bit null

	alter table IstoricPF
	alter column CodValiditateDP2 bit null

	alter table IstoricPF
	alter column IdUtilizator int null

	alter table IstoricPF
	alter column ReinternatTransfer bit null

	alter table IstoricPF
	alter column AvizComisie bit null

	alter table IstoricPF
	alter column IdSursaInternare tinyint null

	alter table IstoricPF
	alter column IdPersoana int null

	alter table IstoricPF
	alter column SelectieExport bit null
	print 'IstoricPF - OK'

	--IstoricPFSZ
	alter table IstoricPFSZ
	alter column IdPacientFisa int null

	alter table IstoricPFSZ
	alter column CazID nvarchar(52) null

	alter table IstoricPFSZ
	alter column IdSpital int null

	alter table IstoricPFSZ
	alter column IdSectie int null

	--alter table IstoricPFSZ
	--alter column NFO int null

	alter table IstoricPFSZ
	alter column DataDeschidereFisa datetime null

	alter table IstoricPFSZ
	alter column IdLocalitate int null

	alter table IstoricPFSZ
	alter column DataNastere datetime null

	alter table IstoricPFSZ
	alter column Sex bit null

	alter table IstoricPFSZ
	alter column IdTipCetatenie tinyint null

	alter table IstoricPFSZ
	alter column IdStatutAsigurat tinyint  null

	alter table IstoricPFSZ
	alter column IdMedic int null

	alter table IstoricPFSZ
	alter column IdDP1 int null

	alter table IstoricPFSZ
	alter column IdStareRecord tinyint null

	alter table IstoricPFSZ
	alter column SelectieExport bit null
	
	alter table IstoricPFSZ
	alter column Finalizat bit null

	alter table IstoricPFSZ
	alter column IdUtilizator int null

	alter table IstoricPFSZ
	alter column Ord1782 bit null

	alter table IstoricPFSZ
	alter column AvizComisie bit null

	alter table IstoricPFSZ
	alter column UPU bit null
	print 'IstoricPFSZ - OK'

	update ListaSectiiFiltrat
	set DenSectie = ls.DenSectie
	from ListaSectiiFiltrat lsf
	inner join ListaSectii ls on ls.CodSectie=lsf.CodSectie
	where lsf.DenSectie is null
	print 'Update ListaSectiiFiltrat - OK'

	--create index on IdSpital, CodParafa
	IF EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.ListaMedici') AND NAME ='IXU_CodParafa')
	BEGIN
		DROP INDEX IXU_CodParafa ON dbo.ListaMedici;
		print 'DROP INDEX IXU_CodParafa - OK'
	END
	IF NOT EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.ListaMedici') AND NAME ='IXU_Spital_CodParafa')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX IXU_Spital_CodParafa
		ON dbo.ListaMedici(IdSpital, CodParafa)
		WHERE IdSpital IS NOT NULL
		print 'CREATE INDEX IXU_Spital_CodParafa - OK'
	END

	--update ListaRapoarte
	if not exists(select * from ListaRapoarte where IdRaport=14)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (14, 'Numar cazuri grupate pe diagnostic principal cod 1','NrCazuri_DiagnosticPrincipalCod1')

	if not exists(select * from ListaRapoarte where IdRaport=15)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (15, 'Numar cazuri grupate pe ICP','NrCazuri_ICP')

	if not exists(select * from ListaRapoarte where IdRaport=16)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (16, 'Raport diagnostice secundare','RaportDiagSec')

	if not exists(select * from ListaRapoarte where IdRaport=17)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (17, 'Numar cazuri pe mediu de rezidenta','NrCazuriMediuRezidenta')

	if not exists(select * from ListaRapoarte where IdRaport=18)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (18, 'Decedati la 24 de ore de la internare','Decedati24OreInternare')

	if not exists(select * from ListaRapoarte where IdRaport=19)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (19, 'Decedati in primele 48 de ore de la ICP','Decedati48OreICP')

	if not exists(select * from ListaRapoarteSZ where IdRaport=10)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(10,'Analize medicale - sex','AnalizeMedicaleSex')

	if not exists(select * from ListaRapoarteSZ where IdRaport=11)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(11,'Analize Medicale - Medii de rezidenta','AnalizeMedicaleMedii')

	if not exists(select * from ListaRapoarteSZ where IdRaport=12)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(12,'Proceduri - sex','ProceduriSex')

	if not exists(select * from ListaRapoarteSZ where IdRaport=13)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(13,'Proceduri - Medii de rezidenta','ProceduriMedii')

	if not exists(select * from ListaRapoarteSZ where IdRaport=14)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(14,'Numar cazuri grupate pe medii de rezidenta','NrCazuriMedii')

	print 'insert into ListaRapoarte - OK'
	
	alter table PacientFisa
	alter column NFO varchar(10) not null

	alter table PacientFisa
	alter column NFOMama varchar(10) null

	alter table IstoricPF
	alter column NFO varchar(10) null

	alter table IstoricPF
	alter column NFOMama varchar(10) null

	alter table PacientFisaSZ
	alter column NFO varchar(10) not null

	alter table IstoricPFSZ
	alter column NFO varchar(10) null

	print 'NFO text - OK'

	if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 112))
	INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
     VALUES (112 ,'Colita ulcerativa nespecificata' ,'K51.9',NULL,'K51.9' + ' - ' + 'Colita ulcerativa nespecificata')

	if (not exists(select IDCazRezolvatAfectiune from ListaCazRezolvatAfectiuni where IDCazRezolvatAfectiune = 113))
	INSERT INTO [dbo].[ListaCazRezolvatAfectiuni] ([IDCazRezolvatAfectiune],[DenCazRezolvatAfectiune],[CodDiagnostic],[DataValabilitate],[DenCazRezolvatAfectiuneComplet])
     VALUES (113 ,'Boala pancreasului nespecificata' ,'K86.9',NULL,'K86.9' + ' - ' + 'Boala pancreasului nespecificata')

	 print 'Update lista [ListaCazRezolvatAfectiuni] - OK'

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=110))
	 INSERT INTO [dbo].[ListaTipServicii]
           ([IdTipServiciu]
           ,[DenTipServiciu]
           ,[DataValabilitate]
           ,[PentruVizita]
           ,[UPU]
           ,[ListaNorme]
           ,[Cod_SIUI]
           ,[IdDenDataTipServiciu])
     VALUES
           (110
           ,'Bronhoscopia asociata echografiei (EBUS)'
           ,NULL
           ,0
           ,0
           ,'B.3.2'
           ,'SPT_145'
           ,'110 -- Bronhoscopia asociata echografiei (EBUS) -- NA -- B.3.2')

	print 'Update lista [ListaTipServicii] - OK'

	if not exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id 
	and t.name = 'ListaSectii' and c.name = 'DataExpirare')
	begin
		alter table ListaSectii
		add DataExpirare smalldatetime null
		--update ListaSectii set DataExpirare = '2017-04-01'  where CodSectie in ('1272.1','1272.2','1333')
	end

	if not exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id 
	and t.name = 'ListaCazRezolvatInterventiiChirurgicale' and c.name = 'DenCazRezolvatInterventieComplet')
	begin
		alter table ListaCazRezolvatInterventiiChirurgicale
		add DenCazRezolvatInterventieComplet nvarchar(300) null
	end
	
	alter table ListaSectiiFiltrat
	drop column [DenNrSectie]

	alter table ListaSectiiFiltrat
	add [DenNrSectie]  AS (([DenSectie]+' ')+CONVERT([varchar](10),[NumarSectie],(0))+' - '+[CodSectie])

	print 'Update lista sectii filtrat - OK'

	--START Aprilie 2018
	--update ListaCazRezolvatInterventiiChirurgicale
	update [ListaCazRezolvatInterventiiChirurgicale] set DataValabilitate='2018-03-31' where IDCazRezolvatInterventiiChirurgicale = 23
	print '1.15 - update ListaCazRezolvatInterventiiChirurgicale - OK'

	--update ListaCazRezolvatAfectiuni
	update [ListaCazRezolvatAfectiuni] 
	set DataValabilitate='2018-03-31',
	DenCazRezolvatAfectiuneComplet = CodDiagnostic + ' - ' + DenCazRezolvatAfectiune + ' - ' + convert(varchar(30), DataValabilitate, 103)
	where IDCazRezolvatAfectiune in (5,6,23,112)
	print '1.15 - update ListaCazRezolvatAfectiuni - OK'

	--update ListaAccidente
	if not exists (select * from [dbo].[ListaAccidente] where IdAccident=5)
	INSERT INTO [dbo].[ListaAccidente]([IdAccident],[DenAccident]) 
	VALUES (5,'Internare nevoluntara conform Legii nr. 487/2002, republicata')
	print '1.15 - update ListaAccidente - OK'


	--adaugare tabela ListaTipServiciiCerinte
	if not exists(select * from sys.tables t where t.name = 'ListaTipServiciiCerinte')
	begin
		CREATE TABLE [dbo].[ListaTipServiciiCerinte](
			[IdTipServiciuCerinta] [smallint] NOT NULL,
			[DenTipServiciuCerinta] [nvarchar](500) NOT NULL,
			[DataValabilitate] [smalldatetime] NULL,
		 CONSTRAINT [PK_ListaTipServiciiCerinte] PRIMARY KEY CLUSTERED 
		(
			[IdTipServiciuCerinta] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
		) ON [PRIMARY]
		print '1.15 - Creare lista noua ListaTipServiciiCerinte - OK'
	end

	--update lista noua ListaTipServiciiCerinte - OK'
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=1) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (1,'Ac Anti HBs',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=2) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (2,'Ac anti-HBe',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=3) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (3,'Ac anti-VHD',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=4) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (4,'Acid uric',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=5) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (5,'Administrare Albumina umana 20%  100 ml',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=6) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (6,'AgHBe',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=7) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (7,'Albumina',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=8) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (8,'Anticoagulant lupic confirmare',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=9) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (9,'Anticoagulant lupic screening',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=10) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (10,'Antitrombina III',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=11) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (11,'Bilirubina directa',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=12) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (12,'Bilirubina totala',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=13) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (13,'Calcularea riscului cardiovascular pe baza modelului Heart Score',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=14) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (14,'Calprotectina in materii fecale (cantitativ)',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=15) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (15,'Citodiagnostic lichid punctie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=16) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (16,'CMV Ig M',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=17) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (17,'Colangio-IRM',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=18) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (18,'Colesterol seric total',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=19) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (19,'Creatinina serica',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=20) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (20,'CT abdomen cu substanta de contrast',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=21) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (21,'Determinare cantitativa  ARN VHC',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=22) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (22,'Determinare cantitativa ADN VHB',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=23) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (23,'Determinare cantitativa ARN VHD',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=24) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (24,'Dozarea hemocisteinei serice',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=25) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (25,'EBV Ig M',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=26) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (26,'ECG de repaus 12 derivatii',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=27) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (27,'Ecografie abdomen + pelvis',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=28) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (28,'Ecografie pelvis',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=29) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (29,'Ecografie cardiaca',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=30) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (30,'Ecografie obstetricala si ginecologica',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=31) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (31,'Ecografie vasculara (artere)',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=32) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (32,'Educatie in domeniul preventiei cardiovasculare',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=33) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (33,'Factor V Leyden',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=34) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (34,'Feritina serica',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=35) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (35,'Fibroscan',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=36) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (36,'Fosfataza alcalina',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=37) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (37,'Gama GT',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=38) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (38,'Glicemie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=39) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (39,'HDL colesterol',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=40) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (40,'Hemoglobina glicata',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=41) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (41,'Hemoleucograma completa',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=42) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (42,'Indicele glezna-brat (Doppler)',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=43) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (43,'INR',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=44) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (44,'IRM  abdomen cu substanta de contrast',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=45) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (45,'Potasiu seric',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=46) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (46,'LDL colesterol',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=47) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (47,'Monitorizare Holter tensiune arteriala',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=48) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (48,'Sodiu seric',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=49) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (49,'Proteina C',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=50) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (50,'Proteina S',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=51) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (51,'Sideremie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=52) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (52,'Tacrolinemie /sirolinemie/ciclosporinemie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=53) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (53,'TGO',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=54) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (54,'TGP',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=55) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (55,'Trigliceride serice',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=56) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (56,'VSH',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=57) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (57,'Acid uric seric',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=58) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (58,'AFP',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=59) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (59,'Biometrie fetala',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=60) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (60,'Biopsie',NULL)
	--if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=61) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (61,'Calcularea riscului cardiovascular pe baza modelului Heart Score',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=62) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (62,'Cardiotocografie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=63) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (63,'Comunicare rezultat',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=64) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (64,'Comunicare rezultat si consiliere privind conduita in functie de rezultate',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=65) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (65,'Detectia Streptococului de grup B',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=66) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (66,'Determinare la gravida a grupului sanguin ABO',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=67) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (67,'Determinare la gravida a grupului sanguin Rh',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=68) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (68,'Dozare proteine urinare',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=69) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (69,'Dublu test / triplu test',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=70) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (70,'Ecografie de confirmare, viabilitate si datare a sarcinii',NULL)
	--if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=71) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (71,'Ecografie obstetricala si ginecologica',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=72) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (72,'Ecografie pentru depistarea anomaliilor fetale',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=73) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (73,'Ecografie san',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=74) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (74,'Mamografie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=75) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (75,'Evaluarea gravidei pentru infectii cu risc pentru sarcina (hepatita B si C)',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=76) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (76,'Evaluarea gravidei pentru infectii cu risc pentru sarcina (pentru rubeola, toxoplasmoza, infectia CMV, hepatita B si C)',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=77) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (77,'Examen citologic',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=78) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (78,'Examen citologic cervico-vaginal Babes-Papanicolau',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=79) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (79,'Examen complet de urina (sumar + sediment)',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=80) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (80,'Examen histopatologic',NULL)
	--if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=81) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (81,'Glicemie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=82) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (82,'Proteine totale serice',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=83) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (83,'Recoltare frotiu citovaginal',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=84) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (84,'Secretie vaginala',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=85) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (85,'Test de toleranta la glucoza per os',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=86) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (86,'Testare HIV la gravida',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=87) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (87,'Testare infectie HPV',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=88) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (88,'TSH',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=89) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (89,'Uree serica',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=90) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (90,'VDRL sau RPR',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=91) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (91,'Consultatii de specialitate gastroenterologie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=92) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (92,'Consultatii de specialitate boli infectioase',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=93) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (93,'Consultatii de specialitate cardiologie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=94) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (94,'Consultatii de specialitate obstetrica-ginecologie',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=95) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (95,'Consultatie chirurgie generala',NULL)
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=96) INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (96,'Control Hemocisteina serica',NULL)
	print '1.15 - Update lista noua ListaTipServiciiCerinte - OK'

	--Update lista ListaTipServicii
	update [ListaTipServicii] 
	set DataValabilitate='2018-03-31',
	IdDenDataTipServiciu = cast(IdTipServiciu as varchar(10)) + ' -- ' + DenTipServiciu + ' -- ' + convert(varchar(20),DataValabilitate,103) + ' -- ' + ListaNorme
	where IdTipServiciu in (42,43,46)

	if not exists (select * from ListaTipServicii where IDTipServiciu=111) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (111,'Ciroza hepatica – monitorizare  cu  proceduri de inalta performanta la pacientii cu suspiciune de hepatocarcinom ',NULL,0,0,'B.4.1','SPT_149','111 -- Ciroza hepatica – monitorizare  cu  proceduri de inalta performanta la pacientii cu suspiciune de hepatocarcinom  -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=112) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (112,'Ciroza hepatica – monitorizare pacienti cu ascita/hidrotorax',NULL,0,0,'B.4.1','SPT_150','112 -- Ciroza hepatica – monitorizare pacienti cu ascita/hidrotorax -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=113) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (113,'Ciroza hepatica virala -  monitorizare si prescriere tratament antiviral ',NULL,0,0,'B.4.1','SPT_151','113 -- Ciroza hepatica virala -  monitorizare si prescriere tratament antiviral -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=114) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (114,'Hepatita cronica virala B – diagnostic ',NULL,0,0,'B.4.1','SPT_152','114 -- Hepatita cronica virala B – diagnostic -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=115) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (115,'Hepatita cronica virala B fara agent delta – monitorizare tratament antiviral ',NULL,0,0,'B.4.1','SPT_153','115 -- Hepatita cronica virala B fara agent delta – monitorizare tratament antiviral -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=116) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (116,'Hepatita cronica virala B cu agent delta – diagnostic',NULL,0,0,'B.4.1','SPT_154','116 -- Hepatita cronica virala B cu agent delta – diagnostic -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=117) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (117,'Hepatita cronica virala B cu agent delta - Monitorizarea eficientei si stabilirea continuarii terapiei antivirale',NULL,0,0,'B.4.1','SPT_155','117 -- Hepatita cronica virala B cu agent delta - Monitorizarea eficientei si stabilirea continuarii terapiei antivirale -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=118) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (118,'Hepatita cronica virala C – diagnostic',NULL,0,0,'B.4.1','SPT_156','118 -- Hepatita cronica virala C – diagnostic -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=119) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (119,'Boli inflamatorii intestinale – administrare si prescriere tratament biologic',NULL,0,0,'B.4.1','SPT_157','119 -- Boli inflamatorii intestinale – administrare si prescriere tratament biologic -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=120) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (120,'Boli inflamatorii intestinale – monitorizare ',NULL,0,0,'B.4.1','SPT_158','120 -- Boli inflamatorii intestinale – monitorizare -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=121) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (121,'Monitorizare lunara si prescriere tratament antiviral B, C, D',NULL,0,0,'B.4.1','SPT_159','121 -- Monitorizare lunara si prescriere tratament antiviral B, C, D -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=122) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (122,'Stadializare fibroza hepatica – Fibroscan la pacientii cu afectiuni hepatice preexistente',NULL,0,0,'B.4.1','SPT_160','122 -- Stadializare fibroza hepatica – Fibroscan la pacientii cu afectiuni hepatice preexistente -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=123) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (123,'Evaluare postransplant hepatic ',NULL,0,0,'B.4.1','SPT_161','123 -- Evaluare postransplant hepatic -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=124) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (124,'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare-tip I ',NULL,0,0,'B.4.1','SPT_162','124 -- Depistarea si controlul factorilor de risc ai bolilor cardiovasculare-tip I -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=125) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (125,'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare- tip II   ',NULL,0,0,'B.4.1','SPT_163','125 -- Depistarea si controlul factorilor de risc ai bolilor cardiovasculare- tip II -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=126) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (126,'Depistarea si controlul factorilor de risc ai bolilor cardiovasculare- tip III   ',NULL,0,0,'B.4.1','SPT_164','126 -- Depistarea si controlul factorilor de risc ai bolilor cardiovasculare- tip III -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=127) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (127,'Monitorizarea sarcinii cu risc crescut  la gravida cu tulburari  de coagulare / trombofilii ereditare si dobandite ',NULL,0,0,'B.4.1','SPT_165','127 -- Monitorizarea sarcinii cu risc crescut  la gravida cu tulburari  de coagulare / trombofilii ereditare si dobandite -- NA -- B.4.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=128) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (128,'Supravegherea unei sarcini normale (la gravida care nu detine documente medicale care sa ateste existenta in antecedentele personale patologice a rubeolei, toxoplasmozei, infecţiei CMV)',NULL,0,0,'B.4.2','SPT_166','128 -- Supravegherea unei sarcini normale (la gravida care nu detine documente medicale care sa ateste existenta in antecedentele personale patologice a rubeolei, toxoplasmozei, infecţiei CMV) -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=129) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (129,'Supravegherea unei sarcini normale (la gravida care detine documente medicale ce atesta existenta in antecedentele personale patologice a hepatita B şi C rubeolei, toxoplasmozei, infecţiei CMV)',NULL,0,0,'B.4.2','SPT_167','129 -- Supravegherea unei sarcini normale (la gravida care detine documente medicale ce atesta existenta in antecedentele personale patologice a hepatita B şi C rubeolei, toxoplasmozei, infecţiei CMV) -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=130) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (130,'Screening prenatal (S11 - S19+6 zile)',NULL,0,0,'B.4.2','SPT_168','130 -- Screening prenatal (S11 - S19+6 zile) -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=131) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (131,'Supravegherea altor sarcini cu risc crescut (edem gestational)',NULL,0,0,'B.4.2','SPT_169','131 -- Supravegherea altor sarcini cu risc crescut (edem gestational) -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=132) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (132,'Supravegherea altor sarcini cu risc crescut (hiperemeza gravidica usoara)',NULL,0,0,'B.4.2','SPT_170','132 -- Supravegherea altor sarcini cu risc crescut (hiperemeza gravidica usoara) -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=133) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (133,'Supravegherea altor sarcini cu risc crescut (evaluarea gravidelor cu uter cicatriceal in trimestrul III)',NULL,0,0,'B.4.2','SPT_171','133 -- Supravegherea altor sarcini cu risc crescut (evaluarea gravidelor cu uter cicatriceal in trimestrul III) -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=134) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (134,'Depistarea precoce a leziunilor precanceroase ale sanului',NULL,0,0,'B.4.2','SPT_172','134 -- Depistarea precoce a leziunilor precanceroase ale sanului -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=135) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (135,'Depistarea precoce a leziunilor precanceroase ale sanului cu suspiciune identificata mamografic',NULL,0,0,'B.4.2','SPT_173','135 -- Depistarea precoce a leziunilor precanceroase ale sanului cu suspiciune identificata mamografic -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=136) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (136,'Depistarea si diagonsticarea precoce a leziunilor displazice ale  colului uterin',NULL,0,0,'B.4.2','SPT_174','136 -- Depistarea si diagonsticarea precoce a leziunilor displazice ale  colului uterin -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=137) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (137,'Depistarea si diagonsticarea precoce a leziunilor displazice ale  colului uterin cu examen citologic',NULL,0,0,'B.4.2','SPT_175','137 -- Depistarea si diagonsticarea precoce a leziunilor displazice ale  colului uterin cu examen citologic -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=138) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (138,'Diagonsticarea precoce a leziunilor displazice ale  colului uterin - Se efectueaza de medicii din specialitatea obstetrica-ginecologie',NULL,0,0,'B.4.2','SPT_176','138 -- Diagonsticarea precoce a leziunilor displazice ale  colului uterin - Se efectueaza de medicii din specialitatea obstetrica-ginecologie -- NA -- B.4.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=139) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (139,'Supleere a functiei intestinale la bolnavii cu insuficienta intestinala cronica care necesita nutritie parenterala pentru o perioada mai mare de 3 luni de zile',NULL,1,0,'B.3.1','SPT_146','139 -- Supleere a functiei intestinale la bolnavii cu insuficienta intestinala cronica care necesita nutritie parenterala pentru o perioada mai mare de 3 luni de zile -- NA -- B.3.1')
	if not exists (select * from ListaTipServicii where IDTipServiciu=140) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (140,'Terapia spasticitatii membrului superior aparuta ca urmare a unui accident vascular cerebral pentru pacientul adult-cu toxina botulinica',NULL,0,0,'B.3.2','SPT_147','140 -- Terapia spasticitatii membrului superior aparuta ca urmare a unui accident vascular cerebral pentru pacientul adult-cu toxina botulinica -- NA -- B.3.2')
	if not exists (select * from ListaTipServicii where IDTipServiciu=141) INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu]) VALUES (141,'Cordonocenteza',NULL,0,0,'B.3.2','SPT_148','141 -- Cordonocenteza -- NA -- B.3.2')
	print '1.15 - Update lista ListaTipServicii - OK'

	if not exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id and t.name = 'PacientTipServiciiSZ' and c.name = 'IdPacientTipServiciuGuid')
	alter table [dbo].[PacientTipServiciiSZ]
	add [IdPacientTipServiciuGuid] nvarchar(36) NOT NULL DEFAULT (newid())

	IF NOT EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('PacientTipServiciiSZ') AND NAME ='IX_IdPacientTipServiciuGuid_UNIC_NOTNULL')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX IX_IdPacientTipServiciuGuid_UNIC_NOTNULL
		ON dbo.PacientTipServiciiSZ(IdPacientTipServiciuGuid)
	END
	print '1.15 - Adaugare camp nou IdPacientTipServiciuGuid - OK'

	-- 'Adaugare tabela noua PacientTipServiciiCerinteSZ - OK'
	if not exists(select * from sys.tables t where t.name = 'PacientTipServiciiCerinteSZ')
	BEGIN
		CREATE TABLE [dbo].[PacientTipServiciiCerinteSZ](
			[IdPacientTipServiciuCerinte] [int] IDENTITY(1,1) NOT NULL,
			[IdPacientTipServiciu] [int] NOT NULL,
			[IdPacientTipServiciuGuid] [nvarchar](36) NOT NULL,
			[IdTipServiciuCerinta] [smallint] NOT NULL,
		 CONSTRAINT [PK_PacientTipServiciiCerinteSZ] PRIMARY KEY CLUSTERED 
		(
			[IdPacientTipServiciuCerinte] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
		) ON [PRIMARY]

		ALTER TABLE [dbo].[PacientTipServiciiCerinteSZ]  WITH CHECK ADD  CONSTRAINT [FK_PacientTipServiciiCerinteSZ_ListaTipServiciiCerinte] FOREIGN KEY([IdTipServiciuCerinta])
		REFERENCES [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta])

		ALTER TABLE [dbo].[PacientTipServiciiCerinteSZ] CHECK CONSTRAINT [FK_PacientTipServiciiCerinteSZ_ListaTipServiciiCerinte]

		ALTER TABLE [dbo].[PacientTipServiciiCerinteSZ]  WITH CHECK ADD  CONSTRAINT [FK_PacientTipServiciiCerinteSZ_PacientTipServiciiSZ] FOREIGN KEY([IdPacientTipServiciu])
		REFERENCES [dbo].[PacientTipServiciiSZ] ([IdPacientTipServiciu])
		ON DELETE CASCADE

		ALTER TABLE [dbo].[PacientTipServiciiCerinteSZ] CHECK CONSTRAINT [FK_PacientTipServiciiCerinteSZ_PacientTipServiciiSZ]

		ALTER TABLE [dbo].[PacientTipServiciiCerinteSZ]  WITH CHECK ADD  CONSTRAINT [FK_PacientTipServiciiCerinteSZ_PacientTipServiciiSZ1] FOREIGN KEY([IdPacientTipServiciuGuid])
		REFERENCES [dbo].[PacientTipServiciiSZ] ([IdPacientTipServiciuGuid])

		ALTER TABLE [dbo].[PacientTipServiciiCerinteSZ] CHECK CONSTRAINT [FK_PacientTipServiciiCerinteSZ_PacientTipServiciiSZ1]

	END
	print '1.15 - Adaugare tabela noua PacientTipServiciiCerinteSZ - OK'
	

	--STOP Aprilie 2018

	--START Iunie 2019
	--update ListaCazRezolvatInterventiiChirurgicale
	update [ListaCazRezolvatInterventiiChirurgicale] set DataValabilitate='2019-06-30' where IDCazRezolvatInterventiiChirurgicale in (26,29,30)
	print '1.16 - update ListaCazRezolvatInterventiiChirurgicale - OK'

	--Update lista ListaTipServicii
	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=142))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (142,'Evaluarea si tratamentul anemiei prin carenta de fier cu fier injectabil intravenos',NULL,0,0,'B.4.1','SPT_177','142 -- Evaluarea si tratamentul anemiei prin carenta de fier cu fier injectabil intravenos -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=143))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (143,'Endoscopie digestiva inferioara cu sedare, fara biopsie - colonoscopie flexibila pana la cec',NULL,0,0,'B.4.1','SPT_178','143 -- Endoscopie digestiva inferioara cu sedare, fara biopsie - colonoscopie flexibila pana la cec -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=144))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (144,'Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pana la cec',NULL,0,0,'B.4.1','SPT_179','144 -- Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pana la cec -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=145))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (145,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la cec',NULL,0,0,'B.4.1','SPT_180','145 -- Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la cec -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=146))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (146,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la cec',NULL,0,0,'B.4.1','SPT_181','146 -- Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la cec -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=147))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (147,'Endoscopie digestiva inferioara cu sedare, cu biopsie - colonoscopie flexibila pana la cec',NULL,0,0,'B.4.1','SPT_182','147 -- Endoscopie digestiva inferioara cu sedare, cu biopsie - colonoscopie flexibila pana la cec -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=148))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (148,'Endoscopie digestiva inferioara fara sedare, cu biopsie - colonoscopie flexibila pana la cec',NULL,0,0,'B.4.1','SPT_183','148 -- Endoscopie digestiva inferioara fara sedare, cu biopsie - colonoscopie flexibila pana la cec -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=149))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (149,'Endoscopie digestiva inferioara cu sedare, fara biopsie - colonoscopie flexibila pana la flexura hepatica',NULL,0,0,'B.4.1','SPT_184','149 -- Endoscopie digestiva inferioara cu sedare, fara biopsie - colonoscopie flexibila pana la flexura hepatica -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=150))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (150,'Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pana la flexura hepatica',NULL,0,0,'B.4.1','SPT_185','150 -- Endoscopie digestiva inferioara fara sedare, fara biopsie - colonoscopie flexibila pana la flexura hepatica -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=151))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (151,'Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la flexura hepatica',NULL,0,0,'B.4.1','SPT_186','151 -- Endoscopie digestiva inferioara cu sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la flexura hepatica -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=152))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (152,'Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la flexura hepatica',NULL,0,0,'B.4.1','SPT_187','152 -- Endoscopie digestiva inferioara fara sedare, cu polipectomie si biopsie - colonoscopie flexibila pana la flexura hepatica -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=153))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (153,'Endoscopie digestiva inferioara cu sedare, cu biopsie - colonoscopie flexibila pana la flexura hepatica',NULL,0,0,'B.4.1','SPT_188','153 -- Endoscopie digestiva inferioara cu sedare, cu biopsie - colonoscopie flexibila pana la flexura hepatica -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=154))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (154,'Endoscopie digestiva inferioara fara sedare, cu biopsie - colonoscopie flexibila pana la flexura hepatica',NULL,0,0,'B.4.1','SPT_189','154 -- Endoscopie digestiva inferioara fara sedare, cu biopsie - colonoscopie flexibila pana la flexura hepatica -- NA -- B.4.1')

	 if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=155))
	 INSERT INTO [dbo].[ListaTipServicii] ([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
     VALUES (155,'Tratamentul excizional sau ablativ al leziunilor precanceroase ale colului uterin',NULL,0,0,'B.4.2','SPT_190','155 -- Tratamentul excizional sau ablativ al leziunilor precanceroase ale colului uterin -- NA -- B.4.1')
	 print '1.16 - update ListaTipServicii - OK'

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=97) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (97,'Anestezie locala',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=98) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (98,'Anestezie mizadolam/propofol',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=99) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (99,'APTT',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=100) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (100,'Colonoscopie pana la cec',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=101) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (101,'Colonoscopie pana la flexura hepatica',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=102) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (102,'Consultatie ATI',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=103) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (103,'Consultatii de specialitate',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=104) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (104,'Colposcopie',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=105) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (105,'EKG',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=106) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (106,'Fibrinogen',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=107) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (107,'Prelevare tesut ERAD (bisturiu rece)',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=108) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (108,'Polipectomie',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=109) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (109,'Proteina C reactiva (CRP)',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=110) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (110,'Transferina',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=111) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (111,'Timp Quick (inclusiv INR)',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=112) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (112,'Fier injectabil intravenos 500 mg',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=113) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (113,'Examen histopatologic (1-3 blocuri)',NULL)
	print '1.16 - update ListaTipServiciiCerinte - OK'
	--STOP Iunie 2019

	--START August 2019
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=114) 
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (114,'Examen anatomo-patologic',NULL)
	print '1.17 - update ListaTipServiciiCerinte - OK'

	--creare tabel nou ListaTipServiciuXCerinta
	if not exists(select * from sys.tables t where t.name = 'ListaTipServiciuXCerinta')
	BEGIN
		CREATE TABLE [dbo].[ListaTipServiciuXCerinta](
		[IdTipServiciu] [tinyint] NOT NULL,
		[IdsTipServiciuCerinte] [nvarchar](200) NOT NULL,
		[TipLista] [nvarchar](50) NULL
		) ON [PRIMARY]

		ALTER TABLE [dbo].[ListaTipServiciuXCerinta]  WITH CHECK ADD  CONSTRAINT [FK_ListaTipServiciuXCerinta_ListaTipServicii] FOREIGN KEY([IdTipServiciu])
		REFERENCES [dbo].[ListaTipServicii] ([IdTipServiciu])
		ON DELETE CASCADE

		ALTER TABLE [dbo].[ListaTipServiciuXCerinta] CHECK CONSTRAINT [FK_ListaTipServiciuXCerinta_ListaTipServicii]
	END
	print '1.17 - create ListaTipServiciuXCerinta - OK'

	--insert valori in ListaTipServiciuXCerinta
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=111) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (111,'91,19,20,44,17','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=112) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (112,'91,92,43,7,38,19,48,45,15,5,41','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=113) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (113,'91,92,43,7,38,19,48,45,11,12,53,54,41','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=114) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (114,'91,92,1,6,2,3,22,35','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=115) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (115,'91,92,41,53,54,1,6,2,22','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=116) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (116,'91,92,23','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=117) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (117,'91,92,23','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=118) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (118,'91,92,21,35','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=119) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (119,'91,41,7,38,19,53,54,48,45','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=120) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (120,'91,41,43,7,38,19,53,54,36,37,49,56,14,34,51','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=121) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (121,'91,92,41,53,54,19','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=122) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (122,'91,92,35','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=123) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (123,'91,16,25,52,58,27,22,21','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=124) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (124,'93,38,40,18,46,39,55,19,4,53,54,26,42,29,13,32','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=125) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (125,'93,38,40,18,46,39,55,19,4,53,54,26,42,29,13,32,31,47','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=126) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (126,'93,38,40,18,46,39,55,19,4,53,54,26,42,29,13,32,31,47','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=127) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (127,'94,10,49,50,24,96,33,9,8,30','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=142) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (142,'103,34,110,41,51,109,38,19,89,111,99,112','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=143) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (143,'103,102,41,106,111,99,105,98,100','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=144) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (144,'103,41,106,111,99,105,100','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=145) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (145,'103,102,41,106,111,99,105,98,100,108,114','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=146) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (146,'103,41,106,111,99,105,100,108,114','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=147) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (147,'103,102,41,106,111,99,105,98,100,114','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=148) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (148,'103,41,106,111,99,105,100,114','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=149) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (149,'103,102,41,106,111,99,105,98,101','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=150) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (150,'103,41, 106,111,99,105,101','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=151) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (151,'103,102,41,106,111,99,105,98,101,108,114','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=152) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (152,'103,41,106,111,99,105,101,108,114','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=153) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (153,'103,102,41,106,111,99,105,98,101,114','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=154) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (154,'103,41,106,111,99,105,101,114','B4.1')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=128) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (128,'94,41,66,67,89,4,19,38,53,54,88,79,90,86,76,84,70,78,85,40,59,65','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=129) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (129,'94,41,66,67,89,4,19,38,53,54,88,79,90,86,75,84,70,78,85,40,59,66','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=130) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (130,'94,69,72','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=131) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (131,'94,41,19,4,53,54,79,68,82,30','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=132) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (132,'94,41,48,79,45,4,19,30,89','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=133) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (133,'94,62,30','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=134) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (134,'95,94,74,63','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=135) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (135,'95,94.74,73,63','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=136) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (136,'94,87,83,64','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=137) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (137,'94,87,83,77,64','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=138) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (138,'94,60,80','B4.2')
	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=155) INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (155,'94,104,97,107,113','B4.2')
	print '1.17 - update ListaTipServiciuXCerinta - OK'
	--STOP August

	print '1.18 - update ListaTipServiciuXCerinta - OK'
	if exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=150) UPDATE [dbo].[ListaTipServiciuXCerinta] SET IdsTipServiciuCerinte = '103,41,106,111,99,105,101' where IdTipServiciu=150
	print '1.18 - update ListaTipServiciuXCerinta - OK'


---------------------------------------- 	print 'v1.28 - Start'     ----------------------------------------
-------------------------------------------DROP dependinte pentru ListaTipServicii
--0. ListaTipServiciuXCerinta
IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ListaTipServiciuXCerinta_ListaTipServicii]') AND parent_object_id = OBJECT_ID(N'[dbo].[ListaTipServiciuXCerinta]'))
BEGIN
	ALTER TABLE [dbo].[ListaTipServiciuXCerinta] DROP CONSTRAINT [FK_ListaTipServiciuXCerinta_ListaTipServicii]
	print '1.28 - DROP CONSTRAINT [FK_ListaTipServiciuXCerinta_ListaTipServicii] - OK'
END
--1. PacientTipServiciiSZ
IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PacientTipServiciiSZ_ListaTipServicii]') AND parent_object_id = OBJECT_ID(N'[dbo].[PacientTipServiciiSZ]'))
BEGIN
	ALTER TABLE [dbo].[PacientTipServiciiSZ] DROP CONSTRAINT [FK_PacientTipServiciiSZ_ListaTipServicii]
	print '1.28 - DROP CONSTRAINT [FK_PacientTipServiciiSZ_ListaTipServicii] - OK'
END

IF EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('PacientTipServiciiSZ') AND NAME ='IX_PacientTipServiciiSZ')
BEGIN
	DROP INDEX [IX_PacientTipServiciiSZ] ON [dbo].[PacientTipServiciiSZ]
	print '1.28 - DROP INDEX [IX_PacientTipServiciiSZ] ON [dbo].[PacientTipServiciiSZ] - OK'
END

--2. PacientFisaSZ
IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PacientFisaSZ_ListaTipServicii]') AND parent_object_id = OBJECT_ID(N'[dbo].[PacientFisaSZ]'))
BEGIN
	ALTER TABLE [dbo].[PacientFisaSZ] DROP CONSTRAINT [FK_PacientFisaSZ_ListaTipServicii]
	print '1.28 - DROP CONSTRAINT [FK_PacientFisaSZ_ListaTipServicii] - OK'
END

--3. ListaTipServicii
if exists (SELECT *  FROM SYS.KEY_CONSTRAINTS WHERE [TYPE] = 'PK' AND [PARENT_OBJECT_ID] = OBJECT_ID(N'[dbo].[ListaTipServicii]'))
BEGIN
	ALTER TABLE [dbo].[ListaTipServicii] DROP CONSTRAINT [PK_ListaTipServicii] WITH ( ONLINE = OFF )
	print '1.28 - DROP CONSTRAINT [PK_ListaTipServicii] - OK'
END
---------------------------------------------ALTER TABELE IdTipServiciu tinyint->smallint
ALTER TABLE [dbo].[ListaTipServicii]
ALTER COLUMN [IdTipServiciu] smallint NOT NULL
print '1.28 - ALTER COLUMN [ListaTipServicii].[IdTipServiciu] - OK'

if not exists(select * from sys.tables t inner join sys.columns c on c.object_id = t.object_id and t.name = 'ListaTipServicii' and c.name = 'DataStart')
BEGIN
	ALTER TABLE [dbo].[ListaTipServicii]
	ADD DataStart datetime NULL
	print '1.28 - ADD DataStart - OK'
END

ALTER TABLE [dbo].[ListaTipServiciuXCerinta]
ALTER COLUMN [IdTipServiciu] smallint NOT NULL
print '1.28 - ALTER COLUMN [ListaTipServiciuXCerinta].[IdTipServiciu] - OK'

ALTER TABLE [dbo].[PacientTipServiciiSZ]
ALTER COLUMN [IdTipServiciu] smallint NOT NULL
print '1.28 - ALTER COLUMN [PacientTipServiciiSZ].[IdTipServiciu] - OK'

ALTER TABLE [dbo].[PacientFisaSZ]
ALTER COLUMN [IdTipServiciuUPU] smallint NULL
print '1.28 - ALTER COLUMN [PacientFisaSZ].[IdTipServiciuUPU] - OK'
-----------------------------------------------ADAUGA dependinte pentru ListaTipServicii
--0. ListaTipServicii
if not exists (SELECT *  FROM SYS.KEY_CONSTRAINTS WHERE [TYPE] = 'PK' AND [PARENT_OBJECT_ID] = OBJECT_ID(N'[dbo].[ListaTipServicii]'))
BEGIN
	ALTER TABLE [dbo].[ListaTipServicii] ADD  CONSTRAINT [PK_ListaTipServicii] PRIMARY KEY CLUSTERED 
	(
		[IdTipServiciu] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	print '1.28 - ADD  CONSTRAINT [ListaTipServicii].[PK_ListaTipServicii] PRIMARY KEY - OK'
END
--1. ListaTipServiciuXCerinta
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ListaTipServiciuXCerinta_ListaTipServicii]') AND parent_object_id = OBJECT_ID(N'[dbo].[ListaTipServiciuXCerinta]'))
BEGIN
	ALTER TABLE [dbo].[ListaTipServiciuXCerinta]  WITH CHECK ADD  CONSTRAINT [FK_ListaTipServiciuXCerinta_ListaTipServicii] FOREIGN KEY([IdTipServiciu])
	REFERENCES [dbo].[ListaTipServicii] ([IdTipServiciu])
	ON DELETE CASCADE
	ALTER TABLE [dbo].[ListaTipServiciuXCerinta] CHECK CONSTRAINT [FK_ListaTipServiciuXCerinta_ListaTipServicii]
	print '1.28 - ADD  CONSTRAINT [ListaTipServiciuXCerinta].[FK_ListaTipServiciuXCerinta_ListaTipServicii] FOREIGN KEY - OK'
END

--2. PacientTipServiciiSZ
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PacientTipServiciiSZ_ListaTipServicii]') AND parent_object_id = OBJECT_ID(N'[dbo].[PacientTipServiciiSZ]'))
BEGIN
	ALTER TABLE [dbo].[PacientTipServiciiSZ]  WITH CHECK ADD  CONSTRAINT [FK_PacientTipServiciiSZ_ListaTipServicii] FOREIGN KEY([IdTipServiciu])
	REFERENCES [dbo].[ListaTipServicii] ([IdTipServiciu])
	ALTER TABLE [dbo].[PacientTipServiciiSZ] CHECK CONSTRAINT [FK_PacientTipServiciiSZ_ListaTipServicii]
	print '1.28 - ADD  CONSTRAINT [PacientTipServiciiSZ].[FK_PacientTipServiciiSZ_ListaTipServicii] FOREIGN KEY - OK'
END

IF NOT EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('PacientTipServiciiSZ') AND NAME ='IX_PacientTipServiciiSZ')
BEGIN
	CREATE UNIQUE NONCLUSTERED INDEX [IX_PacientTipServiciiSZ] ON [dbo].[PacientTipServiciiSZ]
	(
		[IdPacientVizita] ASC,
		[IdTipServiciu] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	print '1.28 - CREATE UNIQUE INDEX [IX_PacientTipServiciiSZ].[PacientTipServiciiSZ] - OK'
END

--3. PacientFisaSZ
if NOT EXISTS (SELECT *  FROM SYS.KEY_CONSTRAINTS WHERE [TYPE] = 'PK' AND [PARENT_OBJECT_ID] = OBJECT_ID(N'[dbo].[ListaTipServicii]'))
BEGIN
	ALTER TABLE [dbo].[PacientFisaSZ]  WITH CHECK ADD  CONSTRAINT [FK_PacientFisaSZ_ListaTipServicii] FOREIGN KEY([IdTipServiciuUPU])
	REFERENCES [dbo].[ListaTipServicii] ([IdTipServiciu])
	ALTER TABLE [dbo].[PacientFisaSZ] CHECK CONSTRAINT [FK_PacientFisaSZ_ListaTipServicii]
	print '1.28 - ADD  CONSTRAINT [PacientFisaSZ].[FK_PacientFisaSZ_ListaTipServicii] FOREIGN KEY - OK'
END

set nocount off
    COMMIT
END TRY
BEGIN CATCH
 print 'Eroare nr. ' + cast(ERROR_NUMBER() as varchar(50)) + ' la linia ' + cast(ERROR_LINE() as varchar(50)) + ' cu mesajul ' + ERROR_MESSAGE()
 ROLLBACK
END CATCH


