﻿USE [DRGNationalDB]
GO

SET QUOTED_IDENTIFIER ON
set nocount on

if exists(select lspf.CodSpitalCNAS, lsf.DenNrSectie, pfz.NFO, pfz.CNP, pfz.DataDeschidereFisa, pv.DataInceputVizita, pts.IdTipServiciu
	from PacientTipServiciiSZ pts
	inner join PacientViziteSZ pv on pv.IdPacientVizita = pts.IdPacientVizita
	inner join PacientFisaSZ pfz on pfz.IdPacientFisa = pv.IdPacientFisa
	inner join ListaSectiiFiltrat lsf on lsf.IdSectie = pfz.IdSectie
	inner join ListaSpitaleFiltrat lspf on lspf.IdSpital = pfz.IdSpital
	where IdTipServiciu in (227, 228, 231, 232, 233))
begin
	print 'Update-ul nu se poate realiza deoarece exista servicii inactive asignate pe vizite. Va rugam consultati lista de mai jos si stergeti aceste servicii folosind aplicatia DRGNational, 
			apoi reincercati rularea update-ului. In caz de neclaritati va rugam sa contactati personalul INMSS.'

select lspf.CodSpitalCNAS, lsf.DenNrSectie, pfz.NFO, pfz.CNP, pfz.DataDeschidereFisa, pv.DataInceputVizita, pts.IdTipServiciu
	from PacientTipServiciiSZ pts
	inner join PacientViziteSZ pv on pv.IdPacientVizita = pts.IdPacientVizita
	inner join PacientFisaSZ pfz on pfz.IdPacientFisa = pv.IdPacientFisa
	inner join ListaSectiiFiltrat lsf on lsf.IdSectie = pfz.IdSectie
	inner join ListaSpitaleFiltrat lspf on lspf.IdSpital = pfz.IdSpital
	where IdTipServiciu in (227, 228, 231, 232, 233)
			
	RAISERROR('Servicii inactive asignate pe vizite. Apasati orice tasta pentru a termina', 16, 1)
end
	
if exists(select lspf.CodSpitalCNAS, lsf.DenNrSectie, pfz.NFO, pfz.CNP, pfz.DataDeschidereFisa, pfz.IdTipServiciuUPU
	from PacientFisaSZ pfz
	inner join ListaSectiiFiltrat lsf on lsf.IdSectie = pfz.IdSectie
	inner join ListaSpitaleFiltrat lspf on lspf.IdSpital = pfz.IdSpital
	where IdTipServiciuUPU in (227, 228, 231, 232, 233))
begin
	print 'Update-ul nu se poate realiza deoarece exista servicii inactive asignate pe fise UPU. Va rugam consultati lista de mai jos si stergeti aceste servicii folosind aplicatia DRGNational, 
			apoi reincercati rularea update-ului. In caz de neclaritati va rugam sa contactati personalul INMSS.'

select lspf.CodSpitalCNAS, lsf.DenNrSectie, pfz.NFO, pfz.CNP, pfz.DataDeschidereFisa, pfz.IdTipServiciuUPU
	from PacientFisaSZ pfz
	inner join ListaSectiiFiltrat lsf on lsf.IdSectie = pfz.IdSectie
	inner join ListaSpitaleFiltrat lspf on lspf.IdSpital = pfz.IdSpital
	where IdTipServiciuUPU in (227, 228, 231, 232, 233)
		
	RAISERROR('Servicii inactive asignate pe fise UPU. Apasati orice tasta pentru a termina', 16, 1)
end

set nocount off


