USE [DRGNationalDB]
GO

BEGIN TRY
	SET QUOTED_IDENTIFIER ON
    BEGIN TRANSACTION

	--modificari Lista Sectii
	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id and t.name = 'ListaSectii' and c.name = 'DataExpirare')
	begin
		update ListaSectii set DataExpirare = '2017-04-01'  where CodSectie in ('1272.1','1272.2','1333')

		if not exists (select * from [dbo].[ListaSectii] where CodSectie = '1423.3')
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare]) 
		VALUES ('1423.3','Exceptie anexa 25: sectia de recuperare medicala neuropsihomotorie copii din cadrul spitalului CT11',0,'14233',NULL)

		if not exists (select * from [dbo].[ListaSectii] where CodSectie = '1423.4')
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare]) 
		VALUES ('1423.4','Exceptie anexa 25: compartimentul recuperare neuro-psiho-motorie din cadrul spitalului BH18',0,'14234',NULL)

		update [dbo].[ListaSectii] set DenSectie = 'Exceptie anexa 23C sectia de recuperare medicala neurologie din cadrul spitalului B_80'
		where CodSectie = '1393.4'
		print '1.15 - Update lista sectii - OK'
	end

	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id 
	and t.name = 'ListaCazRezolvatInterventiiChirurgicale' and c.name = 'DenCazRezolvatInterventieComplet')
	begin
		update ListaCazRezolvatInterventiiChirurgicale
		set DenCazRezolvatInterventieComplet = DenCazRezolvatInterventiiChirurgicale 
						+ case when DataValabilitate is not null then ' - ' + convert(varchar(20), ISNULL(DataValabilitate,''),103)
						  else '' end
	end

	if not exists(select * from ListaSectii where CodSectie='1393.4')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1393.4','Exceptie anexa 23C sectia clinica(IV) de recuperare medicala neurologie din cadrul spitalului B_70',0,'13934',NULL)
	end

	--vers 1.19
	if not exists(select * from ListaSectii where CodSectie='1493')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1493','Genetica medicala (acuti si cronici)',1,'1493',NULL)
	end

	print 'Update lista sectii - OK'

	--vers 1.20
	if not exists(select * from ListaAccidente where IdAccident='6')
	begin
		INSERT INTO [dbo].[ListaAccidente] ([IdAccident],[DenAccident])
		VALUES (6,'Infectie confirmata cu COVID-19')
	end

	if not exists(select * from ListaAccidente where IdAccident='7')
	begin
		INSERT INTO [dbo].[ListaAccidente] ([IdAccident],[DenAccident])
		VALUES (7,'Suspiciune/testare pentru infectie cu COVID-19, neconfirmata')
	end

	print 'Update lista accidente - OK'

	--vers 1.21
	if not exists(select * from ListaDiagnosticeClase where IdClasaDiagnostic=22)
	begin
		INSERT INTO [dbo].[ListaDiagnosticeClase] ([IdClasaDiagnostic],[DenClasaDiagnostic])
		VALUES (22,'Coduri pentru scopuri speciale')
	end
	print 'v1.21 - Update ListaDiagnosticeClase - OK'

	if not exists(select * from ListaDiagnosticeSubClase where IdSubClasaDiagnostic=274)
	begin
		INSERT INTO [dbo].[ListaDiagnosticeSubClase] ([IdSubClasaDiagnostic],[IdClasaDiagnostic],[DenSubClasaDiagnostic])
		VALUES (274,22,'Afectiuni noi, de etiologie incerta, alocate temporar sau in situatii de urgenta U00-U49')
	end
	print 'v1.21 - Update ListaDiagnosticeSubClase - OK'

	if not exists(select * from ListaDiagnostice where IdDiagnostic=15928)
	begin
		INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])
		VALUES(15928,'U07.1',274,'COVID-19, virus identificat',1,0,0,0,0,0,'U07.1 - COVID-19, virus identificat')
	end

	if not exists(select * from ListaDiagnostice where IdDiagnostic=15929)
	begin
		INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])
		VALUES(15929,'U07.2',274,'COVID-19, virus neidentificat',1,0,0,0,0,0,'U07.2 - COVID-19, virus neidentificat')
	end
	print 'v1.21 - Update ListaDiagnostice - OK'

	if not exists(select * from ListaDiagnosticeSubClase where IdSubClasaDiagnostic=275)
	begin
		INSERT INTO [dbo].[ListaDiagnosticeSubClase] ([IdSubClasaDiagnostic],[IdClasaDiagnostic],[DenSubClasaDiagnostic])
		VALUES (275,22,'Rezistenta la medicamente antimicrobiene si antineoplazice (U82-U85)')
	end
	print 'v1.22 - Update ListaDiagnosticeSubClase - OK'

	if not exists(select * from ListaDiagnostice where IdDiagnostic=15930) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15930,'U04.9',274,'Sindromul sever respirator acut [SARS], nespecificat',0,0,0,0,1,0,'U04.9 - Sindromul sever respirator acut [SARS], nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15931) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15931,'U07.0',274,'Tulburari asociate inhalarii de vapori din dispozitive electronice',0,0,0,0,1,0,'U07.0 - Tulburari asociate inhalarii de vapori din dispozitive electronice')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15932) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15932,'U08.9',274,'Istoric personal de COVID-19, nespecificat',0,0,0,0,1,0,'U08.9 - Istoric personal de COVID-19, nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15933) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15933,'U09.9',274,'Conditie (status) post-COVID-19, nespecificata',0,0,0,0,1,0,'U09.9 - Conditie (status) post-COVID-19, nespecificata')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15934) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15934,'U10.9',274,'Sindrom inflamator multisistemic asociat cu COVID-19, nespecificat',0,0,0,0,1,0,'U10.9 - Sindrom inflamator multisistemic asociat cu COVID-19, nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15935) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15935,'U11.9',274,'Necesitatea imunizarii impotriva COVID-19, nespecificata',0,0,0,0,1,0,'U11.9 - Necesitatea imunizarii impotriva COVID-19, nespecificata')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15936) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15936,'U12.9',274,'Vaccinuri anti-COVID-19 producand efecte adverse in utilizare terapeutica, nespecificate',0,0,0,0,1,0,'U12.9 - Vaccinuri anti-COVID-19 producand efecte adverse in utilizare terapeutica, nespecificate')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15937) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15937,'U82.0',275,'Rezistenta la penicilina',0,0,0,0,1,0,'U82.0 - Rezistenta la penicilina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15938) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15938,'U82.1',275,'Rezistenta la meticilina',0,0,0,0,1,0,'U82.1 - Rezistenta la meticilina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15939) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15939,'U82.2',275,'Rezistenta de tip beta-lactamaze cu spectru extins',0,0,0,0,1,0,'U82.2 - Rezistenta de tip beta-lactamaze cu spectru extins')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15940) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15940,'U82.8',275,'Rezistenta la alte beta-lactamine',0,0,0,0,1,0,'U82.8 - Rezistenta la alte beta-lactamine')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15941) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15941,'U82.9',275,'Rezistenta la beta-lactamine, nespecificate',0,0,0,0,1,0,'U82.9 - Rezistenta la beta-lactamine, nespecificate')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15942) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15942,'U83.0',275,'Rezistenta la vancomicina',0,0,0,0,1,0,'U83.0 - Rezistenta la vancomicina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15943) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15943,'U83.1',275,'Rezistenta la alte antibiotice inrudite cu vancomicina',0,0,0,0,1,0,'U83.1 - Rezistenta la alte antibiotice inrudite cu vancomicina')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15944) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15944,'U83.2',275,'Rezistenta la chinolone',0,0,0,0,1,0,'U83.2 - Rezistenta la chinolone')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15945) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15945,'U83.7',275,'Rezistenta la antibiotice multiple',0,0,0,0,1,0,'U83.7 - Rezistenta la antibiotice multiple')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15946) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15946,'U83.8',275,'Rezistenta la alt antibiotic unic, specificat',0,0,0,0,1,0,'U83.8 - Rezistenta la alt antibiotic unic, specificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15947) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15947,'U83.9',275,'Rezistenta la antibiotic nespecificat',0,0,0,0,1,0,'U83.9 - Rezistenta la antibiotic nespecificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15948) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15948,'U84.0',275,'Rezistenta la medicament(e) antiparazitare',0,0,0,0,1,0,'U84.0 - Rezistenta la medicament(e) antiparazitare')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15949) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15949,'U84.1',275,'Rezistenta la medicament(e) antifungice',0,0,0,0,1,0,'U84.1 - Rezistenta la medicament(e) antifungice')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15950) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15950,'U84.2',275,'Rezistenta la medicament(e) antivirale',0,0,0,0,1,0,'U84.2 - Rezistenta la medicament(e) antivirale')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15951) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15951,'U84.3',275,'Rezistenta la medicament(e) tuberculostatice',0,0,0,0,1,0,'U84.3 - Rezistenta la medicament(e) tuberculostatice')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15952) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15952,'U84.7',275,'Rezistenta la multiple medicamente antimicrobiene',0,0,0,0,1,0,'U84.7 - Rezistenta la multiple medicamente antimicrobiene')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15953) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15953,'U84.8 ',275,'Rezistenta la alt medicament antimicrobian specificat',0,0,0,0,1,0,'U84.8  - Rezistenta la alt medicament antimicrobian specificat')
	if not exists(select * from ListaDiagnostice where IdDiagnostic=15954) INSERT INTO [dbo].[ListaDiagnostice] ([IdDiagnostic],[CodDiagnostic],[IdSubClasaDiagnostic],[DenDiagnostic],[Simplu],[Dagger],[Asterisk],[Traumatism],[CauzaExterna],[Sechela],[CodDenDiagnostic])    VALUES(15954,'U84.9',275,'Rezistenta la medicamente antimicrobiene nespecificate',0,0,0,0,1,0,'U84.9 - Rezistenta la medicamente antimicrobiene nespecificate')

	print 'v1.22 - Update ListaDiagnostice - OK'
	
	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=156))
	INSERT INTO [dbo].[ListaTipServicii]
        ([IdTipServiciu]
        ,[DenTipServiciu]
        ,[DataValabilitate]
        ,[PentruVizita]
        ,[UPU]
        ,[ListaNorme]
        ,[Cod_SIUI]
        ,[IdDenDataTipServiciu])
    VALUES
        (156
        ,'Evaluarea sindromului Post Covid-19'
        ,NULL
        ,0
        ,0
        ,'B.3.2'
        ,'SPT_191'
        ,'156 -- Evaluarea sindromului Post Covid-19 -- NA -- B.3.2')

	print 'v1.22 - Update lista [ListaTipServicii] - OK'

	update ListaSectii set densectie='Ingrijiri paleative' where codsectie='1061_PAL'--Ingrijiri paliative
	update ListaSectii set densectie='Exceptie anexa 25: Geriatrie si gerontologie' where codsectie='1121.1'--Exceptie anexa 25 Geriatrie si gerontologie
	update ListaSectii set densectie='Hematologie' where codsectie='1131'--Hematologie clinica
	update ListaSectii set densectie='Neonatologie (prematuri) aferente unei maternitati de grd II' where codsectie='1222.1'--Neonatologie (prematuri)_MaternitateGrII
	update ListaSectii set densectie='Neonatologie (prematuri) aferente unei maternitati de gradul III' where codsectie='1222.2'--Neonatologie (prematuri)_MaternitateGrIII
	update ListaSectii set densectie='Neurologie' where codsectie='1231'--Neurologie
	update ListaSectii set densectie='Pediatrie (Recuperare pediatrica)' where codsectie='1272'--Pediatrie ( recuperare pediatrica)
	update ListaSectii set densectie='Psihatrie pediatrica' where codsectie='1312'--Psihiatrie pediatrica
	update ListaSectii set densectie='Psihiatrie(Nevroze)' where codsectie='1321'--Psihiatrie (Nevroze)
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare, medicina fizica si balneologie copii' where codsectie='1372.1'--Exceptie anexa 25 Recuperare, medicina fizica si balneologie copii
	update ListaSectii set densectie='Recuperare medicala cardiovasculara' where codsectie='1383'--Recuperare medicala - cardiovasculara
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare medicala cardiovasculara' where codsectie='1383.1'--Exceptie anexa 25 Recuperare medicala cardiovasculara
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare medicala neurologie' where codsectie='1393.1'--Exceptie anexa 25 Recuperare medicala neurologie
	update ListaSectii set densectie='Exceptie anexa 23C: Recuperare medicala neurologie' where codsectie='1393.2'--Exceptie anexa 23C Recuperare medicala neurologie
	update ListaSectii set densectie='Exceptie anexele 23C si 25: Recuperare medicala neurologie' where codsectie='1393.3'--Exceptie anexele 23C si 25 Recuperare medicala neurologie
	update ListaSectii set densectie='Recuperare medicala neurologie' where codsectie='1393.4'--Exceptie anexa 23C sectia de recuperare medicala neurologie din cadrul spitalului B_80
	update ListaSectii set densectie='Recuperare medicala ortopedie si traumatologie' where codsectie='1403'--Recuperare medicala - ortopedie  si traumatologie
	update ListaSectii set densectie='Recuperare medicala respiratorie' where codsectie='1413'--Recuperare medicala - respiratorie
	update ListaSectii set densectie='Recuperare neuro-psihomotorie' where codsectie='1423'--Recuperare neuro-psiho-motorie
	update ListaSectii set densectie='Exceptie anexa 25: Recuperare neuro-psihomotorie' where codsectie='1423.1'--Exceptie anexa 25 Recuperare neuro-psihomotorie
	update ListaSectii set densectie='Exceptie anexa 23C: Recuperare neuro-psihomotorie' where codsectie='1423.2'--Exceptie anexa 23C Recuperare neuro-psihomotorie
	update ListaSectii set densectie='Exceptie anexa 25: sectia de recuperare medicala neuropsihomotorie copii din cadrul spitalului CT11' where codsectie='1423.3'--Exceptie anexa 25 sectia de recuperare medicala neuropsihomotorie copii din CT11
	update ListaSectii set densectie='Exceptie anexa 25: compartimentul recuperare neuro-psiho-motorie din cadrul spitalului BH18' where codsectie='1423.4'--Exceptie anexa 25 compartimentul recuperare neuro-psiho-motorie din BH18
	update ListaSectii set densectie='Terapie intensiva coronarieni - UTIC' where codsectie='1453'--Terapie intensiva coronarieni -UTIC
	update ListaSectii set densectie='Sectii sanatoriale altele decat balneare' where codsectie='1473'--Sectii sanatoriale
	update ListaSectii set densectie='Otorinolaringologie (ORL)- implant cohlear' where codsectie='2233'--Otorinolaringologie (ORL) - implant cohlear
	update ListaSectii set densectie='Sterilitate-infertilitate' where codsectie='2241'--Sterilitate- infertilitate
	update ListaSectii set densectie='Sterilitate -infertilitate (Fertilizare in vitro)' where codsectie='2251'--Sterilitate- infertilitate (Fertilizare in vitro)
	update ListaSectii set densectie='Urgenta-CPU' where codsectie='3023'--Urgenta - CPU
	update ListaSectii set densectie='Urgenta-UPU' where codsectie='3033'--Urgenta - UPU
	update ListaSectii set densectie='Urgenta-MU' where codsectie='3043'--Urgenta - MU
	update ListaSectii set densectie='Bloc operator**' where codsectie='4023'--Bloc Operator
	update ListaSectii set densectie='Laborator de prevenire si control infectii nosocomia' where codsectie='4143'--Laborator de prevenire si control infectii nosocomiale
	update ListaSectii set densectie='Cabinete de ambulator de specialitate' where codsectie='8013'--Cabinete de specialitate ambulator

	print 'v1.22 - Update lista [ListaSectii] - OK'

	print 'v1.23 - Start'

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=157))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (157,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii',NULL,0,0,'B.4.x','SPT_192','157 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatii -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=158))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (158,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatiicu investigatie CT',NULL,0,0,'B.4.x','SPT_193','158 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatiicu investigatie CT -- NA -- B.4.x')
 
	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=159))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (159,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatiicu investigatie RX',NULL,0,0,'B.4.x','SPT_194','159 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin Ministerul Sanatatiicu investigatie RX -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=160))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (160,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitaluluicu investigatie CT',NULL,0,0,'B.4.x','SPT_195','160 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitaluluicu investigatie CT -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=161))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (161,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitaluluicu investigatie RX',NULL,0,0,'B.4.x','SPT_196','161 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitaluluicu investigatie RX -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=162))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (162,'Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului',NULL,0,0,'B.4.x','SPT_197','162 -- Infectie cu SARS-CoV-2 confirmata, cu asigurarea medicatiei prin farmacia cu circuit inchis a spitalului -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=163))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (163,'Infectie cu SARS-CoV-2 confirmatafara tratament',NULL,0,0,'B.4.x','SPT_198','163 -- Infectie cu SARS-CoV-2 confirmatafara tratament -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=164))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (164,'Infectie cu SARS-CoV-2 confirmatacu RX fara tratament',NULL,0,0,'B.4.x','SPT_199','164 -- Infectie cu SARS-CoV-2 confirmatacu RX fara tratament -- NA -- B.4.x')

	if (not exists(select IdTipServiciu from ListaTipServicii where IdTipServiciu=165))
	INSERT INTO [dbo].[ListaTipServicii]([IdTipServiciu],[DenTipServiciu],[DataValabilitate],[PentruVizita],[UPU],[ListaNorme],[Cod_SIUI],[IdDenDataTipServiciu])
    VALUES (165,'Infectie cu SARS-CoV-2 confirmatacu investigatie CTfara tratament',NULL,0,0,'B.4.x','SPT_200','165 -- Infectie cu SARS-CoV-2 confirmatacu investigatie CTfara tratament -- NA -- B.4.x')

	print 'v1.23 - Update lista [ListaTipServicii] - OK'
	
	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=115)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (115,'Pulsoximetrie',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=116)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (116,'Administrare de medicamente injectabil/ perfuzii/ alte tipuri de administrari de medicamente',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=117)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (117,'Medicamente cu actiune antivirala administrate parenteral/oral: anticorpi monoclonali neutralizanti/molnupiravir/paxlovid sau alte medicamente achizitionate de Ministerul Sanatatii si distribuite gratuit la nivelul centrului de evaluare',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=118)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (118,'Computer tomografie torace',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=119)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (119,'Examen radiologic torace ansamblu',NULL)

	if not exists (select * from ListaTipServiciiCerinte where IDTipServiciuCerinta=120)
	INSERT INTO [dbo].[ListaTipServiciiCerinte] ([IdTipServiciuCerinta],[DenTipServiciuCerinta],[DataValabilitate]) VALUES (120,'Medicamente cu actiune antivirala, cu administrare orala achizitionate la nivelul unitatii sanitare:  Favipiravir administrat in centrul de evaluare si eliberat pacientului pentru tratament la domiciliu',NULL)

	print '1.23 - update ListaTipServiciiCerinte - OK'

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=157) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (157,'103,41,53,54,38,19,89,109,105,115,116,117','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=158) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (158,'103,41,53,54,38,19,89,109,118,105,115,116,117','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=159) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (159,'103,41,53,54,38,19,89,109,119,105,115,116,117','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=160) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (160,'103,41,53,54,38,19,89,109,45,48,118,105,115,116,120','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=161) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (161,'103,41,53,54,38,19,89,109,45,48,119,105,115,116,120','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=162) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (162,'103,41,53,54,38,19,89,109,45,48,105,115,116,120','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=163) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (163,'103,41,53,54,38,19,89,109,105,115','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=164) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (164,'103,41,53,54,38,19,89,109,119,105,115','B4.x')

	if not exists (select * from ListaTipServiciuXCerinta where IdTipServiciu=165) 
	INSERT INTO [dbo].[ListaTipServiciuXCerinta] ([IdTipServiciu],[IdsTipServiciuCerinte],[TipLista])    VALUES (165,'103,41,53,54,38,19,89,109,118,105,115','B4.x')

	print '1.23 - update ListaTipServiciuXCerinta - OK'

	if not exists(select * from ListaSectii where CodSectie='1483.2')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1483.2','Centru de evaluare',0,'14832',NULL)
	end
	print '1.23 - update ListaSectii - OK'

	print 'v1.23 - Stop'

	UPDATE DBVersion
	SET CurrentVersion = '1.24'
	print 'UPDATE DBVersion to 1.24 - OK'

    COMMIT
END TRY
BEGIN CATCH
 print 'Eroare nr. ' + cast(ERROR_NUMBER() as varchar(50)) + ' la linia ' + cast(ERROR_LINE() as varchar(50)) + ' cu mesajul ' + ERROR_MESSAGE()
 ROLLBACK
END CATCH


