USE [DRGNationalDB]
GO
/****** Object:  StoredProcedure [dbo].[SELECT_PacientFisaSZ_ExportSNSPMS]    Script Date: 02/04/2018 10:37:41 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO



ALTER PROCEDURE [dbo].[SELECT_PacientFisaSZ_ExportSNSPMS] (@IdSpital int, @DataStart DATETIME, @DataStop DATETIME, @SelectieExport int, @IdStareValidare int) 
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

--Table - Lista_Spitale___Filtrat
select CodSpital, DenSpital as DenumireSpital, CUI 
from ListaSpitaleFiltrat 
where IdSpital=@IdSpital
--============================= START Export SZ=========================================

--Table1 - Pacient_Fisa___SZ
SELECT pfz.CazID, ls.CodSpital, lsf.CodSectie, lsf.NumarSectie as NrSectie, pfz.[NFO] as NFSZ, 
	year(pfz.DataDeschidereFisa) as AnDeschidereFisa, pfz.DataDeschidereFisa, pfz.DataInchidereFisa
	,pfz.IdTipInternare as IdTipInternare___SZ, pfz.SerieBilet as SerieBI, pfz.NumarBilet as NrBI, 
	pfz.IdCriteriuInternare as IDCriteriuInternare___SZ, pfz.CID, pfz.IdLocalitate, pfz.Strada, pfz.NrStrada,
	pfz.DataNastere, pfz.Sex, pfz.IdNivelInstruire, pfz.IdOcupatie, pfz.IdTipCetatenie, pfz.IdCetatenie,
	pfz.IdStatutAsigurat, pfz.IdTipAsigurareCNAS, pfz.IdCAS, pfz.NrCardEuropean, pfz.NrCardNational, pfz.NrPasaport,
	lm.CodParafa as CodMedic, lm.IdSpecialitate, ld2.CodDiagnostic as CodDP1, ld3.CodDiagnostic as CodDP2, 
	pfz.IdTipFinantare, pfz.IdTipCazRezolvat, pfz.IdCazRezolvatChirurgical as IDCazRezolvatInterventiiChirurgicale,
	pfz.IdCazRezolvatAfectiune as IDCazRezolvatAfectiune, pfz.Ord1782 as O1782, pfz.IdStareRecord
  FROM [dbo].[PacientFisaSZ] pfz
	INNER JOIN ListaSpitaleFiltrat ls ON ls.IdSpital = pfz.IdSpital
	INNER JOIN ListaSectiiFiltrat lsf ON lsf.IdSectie = pfz.IdSectie
	INNER JOIN ListaMedici lm ON lm.IdMedic = pfz.IdMedic
	left outer JOIN ListaDiagnostice ld2 ON ld2.IdDiagnostic = pfz.IdDP1
	LEFT OUTER JOIN ListaDiagnostice ld3 ON ld3.IdDiagnostic = pfz.IdDP2
WHERE pfz.IdSpital=@IdSpital 
	and pfz.Finalizat = 1
	and (@SelectieExport = 99 or pfz.SelectieExport = @SelectieExport)
	and pfz.UPU = 0
	and IdTipInternare is not null and IdCriteriuInternare is not null
	and (pfz.DataInchidereFisa is null or pfz.DataInchidereFisa BETWEEN @DataStart AND @DataStop)
	and (@IdStareValidare = 99 or pfz.IdStareValidare = @IdStareValidare) 	

--Table2 - Pacient_Vizite___SZ
select pv.VizID, pfz.CazID, pv.DataInceputVizita as DataVizita, pv.DataSfarsitVizita, pv.IdStareRecord
from PacientFisaSZ pfz
inner join PacientViziteSZ pv on pv.IdPacientFisa = pfz.IdPacientFisa
WHERE pfz.IdSpital=@IdSpital 
	and pfz.Finalizat = 1
	and (@SelectieExport = 99 or pfz.SelectieExport = @SelectieExport)
	and pfz.UPU = 0
	and IdTipInternare is not null and IdCriteriuInternare is not null
	and (pfz.DataInchidereFisa is null or pfz.DataInchidereFisa BETWEEN @DataStart AND @DataStop)
	and (@IdStareValidare = 99 or pfz.IdStareValidare = @IdStareValidare) 	
order by pv.IdPacientVizita

--Table3 - Pacient_DiagnosticeSecundare___SZ
SELECT	pfz.CazID,
		ld.CodDiagnostic as CodDiagnosticSecundar
 FROM PacientDiagnosticeSecundareSZ pfd
	inner join PacientFisaSZ pfz on pfz.IdPacientFisa = pfd.IdPacientFisa
	INNER JOIN ListaDiagnostice ld ON ld.IdDiagnostic = pfd.IdDiagnosticSecundar
WHERE pfz.IdSpital=@IdSpital 
	and pfz.Finalizat = 1
	and (@SelectieExport = 99 or pfz.SelectieExport = @SelectieExport)
	and pfz.UPU = 0
	and IdTipInternare is not null and IdCriteriuInternare is not null
	and (pfz.DataInchidereFisa is null or pfz.DataInchidereFisa BETWEEN @DataStart AND @DataStop)
	and (@IdStareValidare = 99 or pfz.IdStareValidare = @IdStareValidare) 	
order by pfd.IdPacientDiagnosticSecundar

----Table4 - Pacient_Proceduri___SZ
SELECT  pv.VizID,
		lp.CodProcedura,
		pfpz.Cantitate
FROM PacientProceduriSZ pfpz
INNER JOIN ListaProceduri lp ON lp.IdProcedura = pfpz.IdProcedura
INNER JOIN PacientViziteSZ pv on pv.IdPacientVizita = pfpz.IdPacientVizita
inner join PacientFisaSZ pfz on pfz.IdPacientFisa=pv.IdPacientFisa
WHERE pfz.IdSpital=@IdSpital 
	and pfz.Finalizat = 1
	and (@SelectieExport = 99 or pfz.SelectieExport = @SelectieExport)
	and pfz.UPU = 0
	and IdTipInternare is not null and IdCriteriuInternare is not null
	and (pfz.DataInchidereFisa is null or pfz.DataInchidereFisa BETWEEN @DataStart AND @DataStop)
	and (@IdStareValidare = 99 or pfz.IdStareValidare = @IdStareValidare) 	
order by pfpz.IdPacientProcedura

----Table5 - Pacient_AnalizeLaborator___SZ
SELECT  pv.VizID,
		la.CodAnaliza,
		pa.Cantitate
FROM PacientAnalizeLaboratorSZ pa
INNER JOIN ListaAnalize la ON la.IdAnaliza = pa.IdAnaliza
INNER JOIN PacientViziteSZ pv on pv.IdPacientVizita = pa.IdPacientVizita
inner join PacientFisaSZ pfz on pfz.IdPacientFisa=pv.IdPacientFisa
WHERE pfz.IdSpital=@IdSpital 
	and pfz.Finalizat = 1
	and (@SelectieExport = 99 or pfz.SelectieExport = @SelectieExport)
	and pfz.UPU = 0
	and IdTipInternare is not null and IdCriteriuInternare is not null
	and (pfz.DataInchidereFisa is null or pfz.DataInchidereFisa BETWEEN @DataStart AND @DataStop)
	and (@IdStareValidare = 99 or pfz.IdStareValidare = @IdStareValidare) 	
order by pa.IdPacientAnaliza

----Table6 - Pacient_TipServicii___SZ
SELECT  ps.IdPacientTipServiciu,
		pv.VizID,
		ps.IdTipServiciu
FROM PacientTipServiciiSZ ps
INNER JOIN ListaTipServicii ls ON ls.IdTipServiciu = ps.IdTipServiciu
INNER JOIN PacientViziteSZ pv on pv.IdPacientVizita = ps.IdPacientVizita
inner join PacientFisaSZ pfz on pfz.IdPacientFisa=pv.IdPacientFisa
WHERE pfz.IdSpital=@IdSpital 
	and pfz.Finalizat = 1
	and (@SelectieExport = 99 or pfz.SelectieExport = @SelectieExport)
	and pfz.UPU = 0
	and IdTipInternare is not null and IdCriteriuInternare is not null
	and (pfz.DataInchidereFisa is null or pfz.DataInchidereFisa BETWEEN @DataStart AND @DataStop)
	and (@IdStareValidare = 99 or pfz.IdStareValidare = @IdStareValidare) 	
order by ps.IdPacientTipServiciu

----Table7 - Pacient_TipServicii_Cerinte___SZ
SELECT  psc.IdPacientTipServiciu,
		psc.IdTipServiciuCerinta
FROM PacientTipServiciiCerinteSZ psc
inner join PacientTipServiciiSZ ps on ps.IdPacientTipServiciu=psc.IdPacientTipServiciu
--INNER JOIN ListaTipServicii ls ON ls.IdTipServiciu = ps.IdTipServiciu
INNER JOIN PacientViziteSZ pv on pv.IdPacientVizita = ps.IdPacientVizita
inner join PacientFisaSZ pfz on pfz.IdPacientFisa=pv.IdPacientFisa
WHERE pfz.IdSpital=@IdSpital 
	and pfz.Finalizat = 1
	and (@SelectieExport = 99 or pfz.SelectieExport = @SelectieExport)
	and pfz.UPU = 0
	and IdTipInternare is not null and IdCriteriuInternare is not null
	and (pfz.DataInchidereFisa is null or pfz.DataInchidereFisa BETWEEN @DataStart AND @DataStop)
	and (@IdStareValidare = 99 or pfz.IdStareValidare = @IdStareValidare) 	
order by ps.IdPacientTipServiciu, ps.IdTipServiciu

--============================= STOP Export SZ=========================================

--============================= START Export UPU=========================================

--Table8 - Pacient_Fisa___UPU
SELECT pfz.CazID, ls.CodSpital, lsf.CodSectie, lsf.NumarSectie as NrSectie, pfz.[NFO] as NFUPU, 
	year(pfz.DataDeschidereFisa) as AnPreluarePacient, pfz.DataDeschidereFisa as MomentPreluarePacient, pfz.DataInchidereFisa as MomentPredarePacient
	,pfz.CID, pfz.DataNastere, pfz.Sex, lm.CodParafa as CodMedic, lm.IdSpecialitate, pfz.IdTipServiciuUPU as IDTipServiciu, pfz.Ord1782 as O1782,
	pfz.IdStareRecord
  FROM [dbo].[PacientFisaSZ] pfz
	INNER JOIN ListaSpitaleFiltrat ls ON ls.IdSpital = pfz.IdSpital
	INNER JOIN ListaSectiiFiltrat lsf ON lsf.IdSectie = pfz.IdSectie
	INNER JOIN ListaMedici lm ON lm.IdMedic = pfz.IdMedic
WHERE pfz.IdSpital=@IdSpital 
	and pfz.Finalizat = 1
	and (@SelectieExport = 99 or pfz.SelectieExport = @SelectieExport)
	and pfz.UPU = 1
	and pfz.IdTipServiciuUPU is not null
	and (pfz.DataInchidereFisa BETWEEN @DataStart AND @DataStop)
	and (@IdStareValidare = 99 or pfz.IdStareValidare = @IdStareValidare) 	
--============================= STOP Export UPU=========================================

END



set ANSI_NULLS ON
set QUOTED_IDENTIFIER ON




