USE [DRGNationalDB]
GO

BEGIN TRY
	SET QUOTED_IDENTIFIER ON
    BEGIN TRANSACTION

	--modificari Lista Sectii
	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id and t.name = 'ListaSectii' and c.name = 'DataExpirare')
	begin
		update ListaSectii set DataExpirare = '2017-04-01'  where CodSectie in ('1272.1','1272.2','1333')

		if not exists (select * from [dbo].[ListaSectii] where CodSectie = '1423.3')
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare]) 
		VALUES ('1423.3','Exceptie anexa 25: sectia de recuperare medicala neuropsihomotorie copii din cadrul spitalului CT11',0,'14233',NULL)

		if not exists (select * from [dbo].[ListaSectii] where CodSectie = '1423.4')
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare]) 
		VALUES ('1423.4','Exceptie anexa 25: compartimentul recuperare neuro-psiho-motorie din cadrul spitalului BH18',0,'14234',NULL)

		update [dbo].[ListaSectii] set DenSectie = 'Exceptie anexa 23C sectia de recuperare medicala neurologie din cadrul spitalului B_80'
		where CodSectie = '1393.4'
		print '1.15 - Update lista sectii - OK'
	end

	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id 
	and t.name = 'ListaCazRezolvatInterventiiChirurgicale' and c.name = 'DenCazRezolvatInterventieComplet')
	begin
		update ListaCazRezolvatInterventiiChirurgicale
		set DenCazRezolvatInterventieComplet = DenCazRezolvatInterventiiChirurgicale 
						+ case when DataValabilitate is not null then ' - ' + convert(varchar(20), ISNULL(DataValabilitate,''),103)
						  else '' end
	end

	if not exists(select * from ListaSectii where CodSectie='1393.4')
	begin
		INSERT INTO [dbo].[ListaSectii]([CodSectie],[DenSectie],[Acut],[CodSectieInt],[DataExpirare])
		VALUES ('1393.4','Exceptie anexa 23C sectia clinica(IV) de recuperare medicala neurologie din cadrul spitalului B_70',0,'13934',NULL)
	end

	print 'Update lista sectii - OK'



	UPDATE DBVersion
	SET CurrentVersion = '1.18'
	print 'UPDATE DBVersion to 1.18 - OK'

    COMMIT
END TRY
BEGIN CATCH
 print 'Eroare nr. ' + cast(ERROR_NUMBER() as varchar(50)) + ' la linia ' + cast(ERROR_LINE() as varchar(50)) + ' cu mesajul ' + ERROR_MESSAGE()
 ROLLBACK
END CATCH


