USE [DRGNationalDB]
GO

BEGIN TRY
	SET QUOTED_IDENTIFIER ON
    BEGIN TRANSACTION

	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id 
	and t.name = 'ListaSectii' and c.name = 'DataExpirare')
	begin
		update ListaSectii set DataExpirare = '2017-04-01'  where CodSectie in ('1272.1','1272.2','1333')
	end

	if exists(select * from sys.tables t
	inner join sys.columns c on c.object_id = t.object_id 
	and t.name = 'ListaCazRezolvatInterventiiChirurgicale' and c.name = 'DenCazRezolvatInterventieComplet')
	begin
		update ListaCazRezolvatInterventiiChirurgicale
		set DenCazRezolvatInterventieComplet = DenCazRezolvatInterventiiChirurgicale 
						+ case when DataValabilitate is not null then ' - ' + convert(varchar(20), ISNULL(DataValabilitate,''),103)
						  else '' end
	end
	print 'Update lista sectii - OK'


	UPDATE DBVersion
	SET CurrentVersion = '1.12'
	print 'UPDATE DBVersion to 1.12 - OK'

    COMMIT
END TRY
BEGIN CATCH
 print 'Eroare nr. ' + cast(ERROR_NUMBER() as varchar(50)) + ' la linia ' + cast(ERROR_LINE() as varchar(50)) + ' cu mesajul ' + ERROR_MESSAGE()
 ROLLBACK
END CATCH


