USE [DRGNationalDB]
GO

BEGIN TRY
	SET QUOTED_IDENTIFIER ON
    BEGIN TRANSACTION
	
	if exists(select * from sys.objects where name = 'FK_ListaSectiiFiltrat_ListaSectii')
	BEGIN
		ALTER TABLE [dbo].[ListaSectiiFiltrat] DROP CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii]
		print 'DROP CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii] - OK'
	END

	if not exists(select * from sys.objects where name = 'FK_ListaSectiiFiltrat_ListaSectii')
	BEGIN
		ALTER TABLE [dbo].[ListaSectiiFiltrat]  WITH CHECK ADD  CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii] FOREIGN KEY([CodSectie])
		REFERENCES [dbo].[ListaSectii] ([CodSectie])
		ON UPDATE CASCADE
		print 'ADD CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii] - OK'
	END

	update ListaSectii 
	set DenSectie = 'Medicina generala'
	where CodSectie = '1163'
	print 'update ListaSectii 1163 - OK'

	update ListaSectii
	set CodSectie='8023'
	where DenSectie = 'Medicina de familie'
	print 'update ListaSectii 8023 - OK' 

	update ListaSectii
	set CodSectie='1121.1'
	where CodSectie like '1121.1%'
	print 'update ListaSectii 1121.1 - OK' 

	update ListaSectii
	set CodSectie='1372.1'
	where CodSectie like '1372.1%'
	print 'update ListaSectii 1372.1 - OK' 

	update ListaSectii
	set CodSectie='1423.1'
	where CodSectie like '1423.1%'
	print 'update ListaSectii 1423.1 - OK' 

	update ListaSectii
	set CodSectie='1423.2'
	where CodSectie like '1423.2%'
	print 'update ListaSectii 1423.2 - OK' 

	--create filtered index
	IF EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.Persoane') AND NAME ='IX_CNP_UNIC')
	BEGIN
		DROP INDEX IX_CNP_UNIC ON dbo.Persoane;
		print 'DROP INDEX IX_CNP_UNIC - OK'
	END
	IF NOT EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.Persoane') AND NAME ='IX_CNP_UNIC_NOTNULL')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX IX_CNP_UNIC_NOTNULL
		ON dbo.Persoane(CNP)
		WHERE CNP IS NOT NULL
		print 'CREATE INDEX IX_CNP_UNIC - OK'
	END

	--IstoricPF
	alter table IstoricPF
	alter column IdPacientFisa int null

	alter table IstoricPF
	alter column CazID nvarchar(36) null

	alter table IstoricPF
	alter column IdSpital int null

	--alter table IstoricPF
	--alter column NFO int null

	alter table IstoricPF
	alter column DataInternare datetime null

	alter table IstoricPF
	alter column IdTipInternare tinyint null

	alter table IstoricPF
	alter column IdSectieInternare int null

	alter table IstoricPF
	alter column IdLocalitate int null

	alter table IstoricPF
	alter column IdTipCetatenie tinyint null

	alter table IstoricPF
	alter column IdStatutAsigurat tinyint  null

	alter table IstoricPF
	alter column IdMedicCurant int null

	alter table IstoricPF
	alter column IdDI int null

	alter table IstoricPF
	alter column IdStareRecord tinyint null

	alter table IstoricPF
	alter column Finalizat bit null

	alter table IstoricPF
	alter column CodValiditateICP bit null

	alter table IstoricPF
	alter column CodValiditateDP1 bit null

	alter table IstoricPF
	alter column CodValiditateDP2 bit null

	alter table IstoricPF
	alter column IdUtilizator int null

	alter table IstoricPF
	alter column ReinternatTransfer bit null

	alter table IstoricPF
	alter column AvizComisie bit null

	alter table IstoricPF
	alter column IdSursaInternare tinyint null

	alter table IstoricPF
	alter column IdPersoana int null

	alter table IstoricPF
	alter column SelectieExport bit null
	print 'IstoricPF - OK'

	--IstoricPFSZ
	alter table IstoricPFSZ
	alter column IdPacientFisa int null

	alter table IstoricPFSZ
	alter column CazID nvarchar(52) null

	alter table IstoricPFSZ
	alter column IdSpital int null

	alter table IstoricPFSZ
	alter column IdSectie int null

	--alter table IstoricPFSZ
	--alter column NFO int null

	alter table IstoricPFSZ
	alter column DataDeschidereFisa datetime null

	alter table IstoricPFSZ
	alter column IdLocalitate int null

	alter table IstoricPFSZ
	alter column DataNastere datetime null

	alter table IstoricPFSZ
	alter column Sex bit null

	alter table IstoricPFSZ
	alter column IdTipCetatenie tinyint null

	alter table IstoricPFSZ
	alter column IdStatutAsigurat tinyint  null

	alter table IstoricPFSZ
	alter column IdMedic int null

	alter table IstoricPFSZ
	alter column IdDP1 int null

	alter table IstoricPFSZ
	alter column IdStareRecord tinyint null

	alter table IstoricPFSZ
	alter column SelectieExport bit null
	
	alter table IstoricPFSZ
	alter column Finalizat bit null

	alter table IstoricPFSZ
	alter column IdUtilizator int null

	alter table IstoricPFSZ
	alter column Ord1782 bit null

	alter table IstoricPFSZ
	alter column AvizComisie bit null

	alter table IstoricPFSZ
	alter column UPU bit null
	print 'IstoricPFSZ - OK'

	update ListaSectiiFiltrat
	set DenSectie = ls.DenSectie
	from ListaSectiiFiltrat lsf
	inner join ListaSectii ls on ls.CodSectie=lsf.CodSectie
	where lsf.DenSectie is null
	print 'Update ListaSectiiFiltrat - OK'

	--create index on IdSpital, CodParafa
	IF EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.ListaMedici') AND NAME ='IXU_CodParafa')
	BEGIN
		DROP INDEX IXU_CodParafa ON dbo.ListaMedici;
		print 'DROP INDEX IXU_CodParafa - OK'
	END
	IF NOT EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.ListaMedici') AND NAME ='IXU_Spital_CodParafa')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX IXU_Spital_CodParafa
		ON dbo.ListaMedici(IdSpital, CodParafa)
		WHERE IdSpital IS NOT NULL
		print 'CREATE INDEX IXU_Spital_CodParafa - OK'
	END

	--update ListaRapoarte
	if not exists(select * from ListaRapoarte where IdRaport=14)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (14, 'Numar cazuri grupate pe diagnostic principal cod 1','NrCazuri_DiagnosticPrincipalCod1')

	if not exists(select * from ListaRapoarte where IdRaport=15)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (15, 'Numar cazuri grupate pe ICP','NrCazuri_ICP')

	if not exists(select * from ListaRapoarte where IdRaport=16)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (16, 'Raport diagnostice secundare','RaportDiagSec')

	if not exists(select * from ListaRapoarte where IdRaport=17)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (17, 'Numar cazuri pe mediu de rezidenta','NrCazuriMediuRezidenta')

	if not exists(select * from ListaRapoarte where IdRaport=18)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (18, 'Decedati la 24 de ore de la internare','Decedati24OreInternare')

	if not exists(select * from ListaRapoarte where IdRaport=19)
	INSERT INTO [dbo].[ListaRapoarte] ([IdRaport],[DenRaport],[FisierExportat])
    VALUES (19, 'Decedati in primele 48 de ore de la ICP','Decedati48OreICP')

	if not exists(select * from ListaRapoarteSZ where IdRaport=10)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(10,'Analize medicale - sex','AnalizeMedicaleSex')

	if not exists(select * from ListaRapoarteSZ where IdRaport=11)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(11,'Analize Medicale - Medii de rezidenta','AnalizeMedicaleMedii')

	if not exists(select * from ListaRapoarteSZ where IdRaport=12)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(12,'Proceduri - sex','ProceduriSex')

	if not exists(select * from ListaRapoarteSZ where IdRaport=13)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(13,'Proceduri - Medii de rezidenta','ProceduriMedii')

	if not exists(select * from ListaRapoarteSZ where IdRaport=14)
	INSERT INTO [dbo].[ListaRapoarteSZ]([IdRaport],[DenRaport],[FisierExportat])
	VALUES(14,'Numar cazuri grupate pe medii de rezidenta','NrCazuriMedii')

	print 'insert into ListaRapoarte - OK'
	
	alter table PacientFisa
	alter column NFO varchar(10) not null

	alter table PacientFisa
	alter column NFOMama varchar(10) null

	alter table IstoricPF
	alter column NFO varchar(10) null

	alter table IstoricPF
	alter column NFOMama varchar(10) null

	alter table PacientFisaSZ
	alter column NFO varchar(10) not null

	alter table IstoricPFSZ
	alter column NFO varchar(10) null

	print 'NFO text - OK'

	UPDATE DBVersion
	SET CurrentVersion = '1.10'
	print 'UPDATE DBVersion to 1.10 - OK'

    COMMIT
END TRY
BEGIN CATCH
 print 'Eroare nr. ' + cast(ERROR_NUMBER() as varchar(50)) + ' la linia ' + cast(ERROR_LINE() as varchar(50)) + ' cu mesajul ' + ERROR_MESSAGE()
 ROLLBACK
END CATCH


