USE DRGNationalDB
GO

BEGIN TRY
	SET QUOTED_IDENTIFIER ON
    BEGIN TRANSACTION
	
	if exists(select * from sys.objects where name = 'FK_ListaSectiiFiltrat_ListaSectii')
	BEGIN
		ALTER TABLE [dbo].[ListaSectiiFiltrat] DROP CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii]
		print 'DROP CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii] - OK'
	END

	if not exists(select * from sys.objects where name = 'FK_ListaSectiiFiltrat_ListaSectii')
	BEGIN
		ALTER TABLE [dbo].[ListaSectiiFiltrat]  WITH CHECK ADD  CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii] FOREIGN KEY([CodSectie])
		REFERENCES [dbo].[ListaSectii] ([CodSectie])
		ON UPDATE CASCADE
		print 'ADD CONSTRAINT [FK_ListaSectiiFiltrat_ListaSectii] - OK'
	END

	update ListaSectii 
	set DenSectie = 'Medicina generala'
	where CodSectie = '1163'
	print 'update ListaSectii 1163 - OK'

	update ListaSectii
	set CodSectie='8023'
	where DenSectie = 'Medicina de familie'
	print 'update ListaSectii 8023 - OK' 

	update ListaSectii
	set CodSectie='1121.1'
	where CodSectie like '1121.1%'
	print 'update ListaSectii 1121.1 - OK' 

	update ListaSectii
	set CodSectie='1372.1'
	where CodSectie like '1372.1%'
	print 'update ListaSectii 1372.1 - OK' 

	update ListaSectii
	set CodSectie='1423.1'
	where CodSectie like '1423.1%'
	print 'update ListaSectii 1423.1 - OK' 

	update ListaSectii
	set CodSectie='1423.2'
	where CodSectie like '1423.2%'
	print 'update ListaSectii 1423.2 - OK' 

	--create filtered index
	IF EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.Persoane') AND NAME ='IX_CNP_UNIC')
	BEGIN
		DROP INDEX IX_CNP_UNIC ON dbo.Persoane;
		print 'DROP INDEX IX_CNP_UNIC - OK'
	END
	IF NOT EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.Persoane') AND NAME ='IX_CNP_UNIC_NOTNULL')
	BEGIN
		CREATE UNIQUE NONCLUSTERED INDEX IX_CNP_UNIC_NOTNULL
		ON dbo.Persoane(CNP)
		WHERE CNP IS NOT NULL
		print 'CREATE INDEX IX_CNP_UNIC - OK'
	END

	--IstoricPF
	alter table IstoricPF
	alter column IdPacientFisa int null

	alter table IstoricPF
	alter column CazID nvarchar(36) null

	alter table IstoricPF
	alter column IdSpital int null

	alter table IstoricPF
	alter column NFO int null

	alter table IstoricPF
	alter column DataInternare datetime null

	alter table IstoricPF
	alter column IdTipInternare tinyint null

	alter table IstoricPF
	alter column IdSectieInternare int null

	alter table IstoricPF
	alter column IdLocalitate int null

	alter table IstoricPF
	alter column IdTipCetatenie tinyint null

	alter table IstoricPF
	alter column IdStatutAsigurat tinyint  null

	alter table IstoricPF
	alter column IdMedicCurant int null

	alter table IstoricPF
	alter column IdDI int null

	alter table IstoricPF
	alter column IdStareRecord tinyint null

	alter table IstoricPF
	alter column Finalizat bit null

	alter table IstoricPF
	alter column CodValiditateICP bit null

	alter table IstoricPF
	alter column CodValiditateDP1 bit null

	alter table IstoricPF
	alter column CodValiditateDP2 bit null

	alter table IstoricPF
	alter column IdUtilizator int null

	alter table IstoricPF
	alter column ReinternatTransfer bit null

	alter table IstoricPF
	alter column AvizComisie bit null

	alter table IstoricPF
	alter column IdSursaInternare tinyint null

	alter table IstoricPF
	alter column IdPersoana int null

	alter table IstoricPF
	alter column SelectieExport bit null
	print 'IstoricPF - OK'

	--IstoricPFSZ
	alter table IstoricPFSZ
	alter column IdPacientFisa int null

	alter table IstoricPFSZ
	alter column CazID nvarchar(52) null

	alter table IstoricPFSZ
	alter column IdSpital int null

	alter table IstoricPFSZ
	alter column IdSectie int null

	alter table IstoricPFSZ
	alter column NFO int null

	alter table IstoricPFSZ
	alter column DataDeschidereFisa datetime null

	alter table IstoricPFSZ
	alter column IdLocalitate int null

	alter table IstoricPFSZ
	alter column DataNastere datetime null

	alter table IstoricPFSZ
	alter column Sex bit null

	alter table IstoricPFSZ
	alter column IdTipCetatenie tinyint null

	alter table IstoricPFSZ
	alter column IdStatutAsigurat tinyint  null

	alter table IstoricPFSZ
	alter column IdMedic int null

	alter table IstoricPFSZ
	alter column IdDP1 int null

	alter table IstoricPFSZ
	alter column IdStareRecord tinyint null

	alter table IstoricPFSZ
	alter column SelectieExport bit null
	
	alter table IstoricPFSZ
	alter column Finalizat bit null

	alter table IstoricPFSZ
	alter column IdUtilizator int null

	alter table IstoricPFSZ
	alter column Ord1782 bit null

	alter table IstoricPFSZ
	alter column AvizComisie bit null

	alter table IstoricPFSZ
	alter column UPU bit null
	print 'IstoricPFSZ - OK'

	UPDATE DBVersion
	SET CurrentVersion = '1.2'
	print 'UPDATE DBVersion - OK'

    COMMIT
END TRY
BEGIN CATCH
 print 'Eroare nr. ' + cast(ERROR_NUMBER() as varchar(50)) + ' la linia ' + cast(ERROR_LINE() as varchar(50)) + ' cu mesajul ' + ERROR_MESSAGE()
 ROLLBACK
END CATCH


